/*
 * Decompiled with CFR 0.152.
 */
package dalapo.autoutils.tileentity;

import dalapo.autoutils.helper.MiscHelper;
import dalapo.autoutils.helper.TileEntityHelper;
import dalapo.autoutils.logging.Logger;
import dalapo.autoutils.reference.UsefulLists;
import dalapo.autoutils.tileentity.TileEntityAutoUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityItemRedis
extends TileEntityAutoUtils {
    private boolean splitStacks;
    private int next = 0;
    private int[] ratios = new int[]{1, 1, 1, 1, 1};

    private int getSide(int n) {
        if (n > MiscHelper.sum(this.ratios)) {
            return 0;
        }
        int count = 0;
        int i = 0;
        for (i = 0; i < 5 && (count += this.ratios[i]) <= n; ++i) {
        }
        if (!MiscHelper.isInRange(i, 0, 4)) {
            return 0;
        }
        return i;
    }

    public boolean shouldSplit() {
        return this.splitStacks;
    }

    public int getRatio(int side) {
        if (MiscHelper.isInRange(side, 0, 4)) {
            return this.ratios[side];
        }
        return -1;
    }

    public void setRatio(int side, int val) {
        if (MiscHelper.isInRange(side, 0, 4) && val >= 0) {
            this.ratios[side] = val;
        }
    }

    public void changeRatio(int side, int val) {
        if (MiscHelper.isInRange(side, 0, 4) && this.ratios[side] + val >= 0) {
            int n = side;
            this.ratios[n] = this.ratios[n] + val;
        }
    }

    public void toggleSplit() {
        this.splitStacks = !this.splitStacks;
    }

    public void redistributeItems(ItemStack in) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.splitStacks) {
            ItemStack[] stacks = new ItemStack[5];
            for (int i = 0; i < 5; ++i) {
                stacks[i] = new ItemStack(in.func_77973_b(), 0, in.func_77960_j());
            }
            for (int itemsRemaining = in.field_77994_a; itemsRemaining > 0; --itemsRemaining) {
                ++stacks[this.getSide((int)this.next++)].field_77994_a;
                if (this.next != MiscHelper.sum(this.ratios)) continue;
                this.next = 0;
            }
            for (int i = 0; i < 6; ++i) {
                if (i == 1) continue;
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                ItemStack stack = stacks[i == 0 ? i : i - 1];
                if (stack.field_77994_a == 0) continue;
                stack.field_77990_d = in.field_77990_d;
                TileEntity dest = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                if (dest instanceof IInventory) {
                    stack = TileEntityHelper.tryInsertItem((IInventory)dest, stack, ForgeDirection.OPPOSITES[i == 0 ? i : i - 1]);
                }
                if (stack == null) continue;
                EntityItem ei = new EntityItem(this.field_145850_b, (double)(this.field_145851_c + dir.offsetX) + 0.5, (double)(this.field_145848_d + dir.offsetY) + 0.5, (double)(this.field_145849_e + dir.offsetZ) + 0.5, i == 0 ? stacks[i] : stacks[i - 1]);
                ei.field_70159_w = 0.0;
                ei.field_70181_x = 0.0;
                ei.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)ei);
            }
        } else {
            Logger.info("Next: " + this.next);
            ForgeDirection dir = UsefulLists.directionsMinusUp[this.getSide(this.next++)];
            Logger.info(dir.name());
            if (this.next >= MiscHelper.sum(this.ratios)) {
                this.next = 0;
            }
            EntityItem ei = new EntityItem(this.field_145850_b, (double)(this.field_145851_c + dir.offsetX) + 0.5, (double)(this.field_145848_d + dir.offsetY) + 0.5, (double)(this.field_145849_e + dir.offsetZ) + 0.5, in);
            ei.field_70159_w = 0.0;
            ei.field_70181_x = 0.0;
            ei.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)ei);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        String[] dirs = new String[]{"down", "north", "south", "west", "east"};
        for (int i = 0; i < 5; ++i) {
            nbt.func_74768_a(dirs[i], this.ratios[i]);
        }
        nbt.func_74768_a("next", this.next);
        nbt.func_74757_a("split", this.splitStacks);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        String[] dirs = new String[]{"down", "north", "south", "west", "east"};
        for (int i = 0; i < 5; ++i) {
            this.ratios[i] = nbt.func_74762_e(dirs[i]);
        }
        this.next = nbt.func_74762_e("next");
        this.splitStacks = nbt.func_74767_n("split");
    }
}

