/*
 * Decompiled with CFR 0.152.
 */
package dalapo.autoutils.registry;

import cpw.mods.fml.common.registry.GameRegistry;
import dalapo.autoutils.block.AutoUtilBlock;
import dalapo.autoutils.block.BlockItemRedis;
import dalapo.autoutils.block.BlockRSNotifier;
import dalapo.autoutils.block.BlockSequencePlacer;
import dalapo.autoutils.block.BlockSidedEmitter;
import dalapo.autoutils.block.BlockStackMover;
import dalapo.autoutils.item.AutoUtilItem;
import dalapo.autoutils.item.ItemRedstoneWatcher;
import dalapo.autoutils.tileentity.TileEntityItemRedis;
import dalapo.autoutils.tileentity.TileEntitySequencePlacer;
import dalapo.autoutils.tileentity.TileEntityStackMover;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;

@GameRegistry.ObjectHolder(value="AutoUtils")
public class ModRegistry {
    public static List<AutoUtilBlock> blocks = new ArrayList<AutoUtilBlock>();
    public static List<AutoUtilItem> items = new ArrayList<AutoUtilItem>();
    public static List<Class<? extends TileEntity>> tiles = new ArrayList<Class<? extends TileEntity>>();

    public static void initBlocks() {
        blocks.add(new BlockStackMover(Material.field_151575_d, "stackmover", false));
        blocks.add(new BlockStackMover(Material.field_151573_f, "filtermover", true));
        blocks.add(new BlockRSNotifier(Material.field_151575_d, "rednotifier"));
        blocks.add(new BlockSequencePlacer(Material.field_151576_e, "sequenceplacer"));
        blocks.add(new BlockItemRedis(Material.field_151575_d, "itemredis"));
        blocks.add(new BlockSidedEmitter(Material.field_151576_e, "sidedrs"));
        for (AutoUtilBlock b : blocks) {
            GameRegistry.registerBlock((Block)b, (String)b.getName());
        }
    }

    public static void initItems() {
        items.add(new ItemRedstoneWatcher("watcher"));
        for (AutoUtilItem i : items) {
            GameRegistry.registerItem((Item)i, (String)i.getName());
        }
    }

    public static void initTiles() {
        tiles.add(TileEntityStackMover.class);
        tiles.add(TileEntitySequencePlacer.class);
        tiles.add(TileEntityItemRedis.class);
        for (Class<? extends TileEntity> c : tiles) {
            GameRegistry.registerTileEntity(c, (String)c.getName());
        }
    }

    public static void init() {
        ModRegistry.initBlocks();
        ModRegistry.initItems();
        ModRegistry.initTiles();
    }

    public static int getSize() {
        return blocks.size();
    }
}

