/*
 * Decompiled with CFR 0.152.
 */
package dalapo.autoutils.helper;

import dalapo.autoutils.logging.Logger;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

public class TileEntityHelper {
    private TileEntityHelper() {
    }

    public static ItemStack getFirstItem(IInventory inv, int side) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!TileEntityHelper.isValidSlotForSide(inv, side, i) || inv.func_70301_a(i) == null) continue;
            return inv.func_70301_a(i);
        }
        return null;
    }

    public static boolean hasSpaceForItem(IInventory inv, ItemStack is, int side) {
        if (inv == null) {
            return true;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack test = inv.func_70301_a(i);
            if (!TileEntityHelper.isValidSlotForSide(inv, side, i) || test != null && (!is.func_77969_a(test) || test.field_77994_a >= test.func_77976_d())) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidSlotForSide(IInventory inv, int side, int slot) {
        if (!(inv instanceof ISidedInventory)) {
            return true;
        }
        ItemStack stack = inv.func_70301_a(slot);
        int[] slots = ((ISidedInventory)inv).func_94128_d(side);
        if (slots == null) {
            return false;
        }
        for (int s : slots) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    public static ItemStack tryInsertItem(IInventory inv, ItemStack itemstack, int side) {
        if (itemstack == null) {
            return null;
        }
        if (inv == null) {
            return itemstack;
        }
        Logger.info("Entered tryInsertItem with ItemStack " + itemstack.toString());
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!TileEntityHelper.isValidSlotForSide(inv, side, i)) continue;
            ItemStack is = inv.func_70301_a(i);
            if (is == null) {
                inv.func_70299_a(i, itemstack.func_77946_l());
                itemstack.field_77994_a = 0;
            } else if (is.func_77969_a(itemstack)) {
                int transfer = is.func_77976_d() - is.field_77994_a;
                if (transfer > itemstack.field_77994_a) {
                    transfer = itemstack.field_77994_a;
                }
                inv.func_70301_a((int)i).field_77994_a += transfer;
                itemstack.field_77994_a -= transfer;
            }
            if (itemstack.field_77994_a != 0) continue;
            return null;
        }
        return itemstack;
    }
}

