/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.calc.IExecutable;
import openmods.calc.SymbolCall;
import openmods.calc.Value;
import openmods.calc.parsing.IExprNode;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;

public class SliceCallNode
implements IExprNode<TypedValue> {
    public final IExprNode<TypedValue> target;
    public final IExprNode<TypedValue> args;

    public SliceCallNode(IExprNode<TypedValue> target, IExprNode<TypedValue> args) {
        this.target = target;
        this.args = args;
    }

    @Override
    public void flatten(List<IExecutable<TypedValue>> output) {
        this.target.flatten(output);
        this.flattenArgsAndSymbol(output);
    }

    protected void flattenArgsAndSymbol(List<IExecutable<TypedValue>> output) {
        int argCount = 0;
        for (IExprNode<TypedValue> arg : this.args.getChildren()) {
            arg.flatten(output);
            ++argCount;
        }
        output.add(new SymbolCall("slice", argCount + 1, 1));
    }

    @Override
    public Iterable<IExprNode<TypedValue>> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(this.target);
        builder.addAll(this.args.getChildren());
        return builder.build();
    }

    public static class NullAware
    extends SliceCallNode {
        private final TypeDomain domain;

        public NullAware(IExprNode<TypedValue> target, IExprNode<TypedValue> args, TypeDomain domain) {
            super(target, args);
            this.domain = domain;
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            this.target.flatten(output);
            ArrayList nonNullOp = Lists.newArrayList();
            this.flattenArgsAndSymbol(nonNullOp);
            output.add(Value.create(Code.wrap(this.domain, nonNullOp)));
            output.add(new SymbolCall("nexecute", 2, 1));
        }
    }
}

