/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import openmods.calc.IExecutable;
import openmods.calc.SymbolCall;
import openmods.calc.UnaryOperator;
import openmods.calc.Value;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.SymbolGetNode;
import openmods.calc.parsing.UnaryOpNode;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.RawCodeExprNode;
import openmods.calc.types.multi.Symbol;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;

public class ClosureCompilerHelper {
    private final TypeDomain domain;
    private final UnaryOperator<TypedValue> varArgMarker;

    public ClosureCompilerHelper(TypeDomain domain, UnaryOperator<TypedValue> varArgMarker) {
        this.domain = domain;
        this.varArgMarker = varArgMarker;
    }

    public void compile(List<IExecutable<TypedValue>> output, Iterable<IExprNode<TypedValue>> args, IExprNode<TypedValue> lambdaBody) {
        Optional<String> varArgName = this.compileArgs(output, args);
        if (varArgName.isPresent()) {
            this.compileClosureVarCall(output, lambdaBody, (String)varArgName.get());
        } else {
            this.compileClosureCall(output, lambdaBody);
        }
    }

    private Optional<String> compileArgs(List<IExecutable<TypedValue>> output, Iterable<IExprNode<TypedValue>> args) {
        Optional<String> varArgName = Optional.absent();
        int count = 0;
        for (IExprNode<TypedValue> arg : args) {
            Optional<String> newVarArgName = this.tryExtractVarArgName(arg);
            if (!newVarArgName.isPresent()) {
                if (varArgName.isPresent()) {
                    throw new IllegalStateException("Positional args after vararg: " + (String)varArgName.get());
                }
                Preconditions.checkState((!varArgName.isPresent() ? 1 : 0) != 0, (String)"", (Object[])new Object[]{varArgName});
                this.extractPatternFromNode(output, arg);
                ++count;
                continue;
            }
            if (varArgName.isPresent()) {
                throw new IllegalStateException("Duplicate vararg: " + (String)varArgName.get() + " - > " + (String)newVarArgName.get());
            }
            varArgName = newVarArgName;
        }
        output.add(new SymbolCall("list", count, 1));
        return varArgName;
    }

    private Optional<String> tryExtractVarArgName(IExprNode<TypedValue> arg) {
        if (arg instanceof UnaryOpNode) {
            UnaryOpNode opNode = (UnaryOpNode)arg;
            if (opNode.operator == this.varArgMarker) {
                SymbolGetNode argNameNode = (SymbolGetNode)opNode.argument;
                return Optional.of((Object)argNameNode.symbol());
            }
        }
        return Optional.absent();
    }

    private void extractPatternFromNode(List<IExecutable<TypedValue>> output, IExprNode<TypedValue> arg) {
        if (arg instanceof SymbolGetNode) {
            SymbolGetNode var = (SymbolGetNode)arg;
            output.add(Value.create(Symbol.get(this.domain, var.symbol())));
        } else {
            output.add(Value.create(Code.flattenAndWrap(this.domain, arg)));
            output.add(new SymbolCall("pattern", 1, 1));
        }
    }

    private void compileClosureCall(List<IExecutable<TypedValue>> output, IExprNode<TypedValue> lambdaBody) {
        this.flattenClosureCode(output, lambdaBody);
        output.add(new SymbolCall("closure", 2, 1));
    }

    private void compileClosureVarCall(List<IExecutable<TypedValue>> output, IExprNode<TypedValue> lambdaBody, String varArgName) {
        output.add(Value.create(this.domain.create(String.class, varArgName)));
        this.flattenClosureCode(output, lambdaBody);
        output.add(new SymbolCall("closurevar", 3, 1));
    }

    private void flattenClosureCode(List<IExecutable<TypedValue>> output, IExprNode<TypedValue> lambdaBody) {
        if (lambdaBody instanceof RawCodeExprNode) {
            lambdaBody.flatten(output);
        } else {
            output.add(Value.create(Code.flattenAndWrap(this.domain, lambdaBody)));
        }
    }
}

