/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import openmods.calc.parsing.StringEscaper;
import openmods.calc.parsing.Token;
import openmods.calc.parsing.TokenType;
import openmods.calc.parsing.TokenUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TokenIterator
extends AbstractIterator<Token>
implements PeekingIterator<Token> {
    private static final Pattern DEC_NUMBER = Pattern.compile("^([0-9](?:_*[0-9]+)*(?:\\.[0-9](?:_*[0-9]+)*)?)");
    private static final Pattern HEX_NUMBER = Pattern.compile("^0x([0-9A-Fa-f](?:_*[0-9A-Fa-f]+)*(?:\\.[0-9A-Fa-f](?:_*[0-9A-Fa-f]+)*)?)");
    private static final Pattern OCT_NUMBER = Pattern.compile("^0((?:_*[0-7]+)+(?:\\.[0-7](?:_*[0-7]+)*)?)");
    private static final Pattern BIN_NUMBER = Pattern.compile("^0b([01](?:_*[01]+)*(?:\\.[01](?:_*[01]+)*)?)");
    private static final Pattern QUOTED_NUMBER = Pattern.compile("^([0-9]+#[0-9A-Za-z'\"](?:_*[0-9A-Za-z'\"]+)*(?:\\.[0-9A-Za-z'\"](?:_*[0-9A-Za-z'\"]+)*)?)");
    private static final Pattern SYMBOL = Pattern.compile("^([_A-Za-z][_0-9A-Za-z]*)");
    private static final Pattern SYMBOL_ARGS = Pattern.compile("^(\\$[0-9]*,?[0-9]*)");
    private static final Set<String> STRING_STARTERS = ImmutableSet.of((Object)"\"", (Object)"'");
    private static final Comparator<String> ORDER_BY_LENGTH = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int sizes = Ints.compare((int)o2.length(), (int)o1.length());
            if (sizes != 0) {
                return sizes;
            }
            return o1.compareTo(o2);
        }
    };
    private final Multiset<String> operators = TreeMultiset.create(ORDER_BY_LENGTH);
    private final Multiset<String> modifiers = TreeMultiset.create(ORDER_BY_LENGTH);
    private String input;

    public TokenIterator(String input, Set<String> operators, Set<String> modifiers) {
        this.input = input;
        this.modifiers.addAll(modifiers);
        this.operators.addAll(operators);
    }

    protected Token computeNext() {
        try {
            if (this.input.isEmpty()) {
                return (Token)this.endOfData();
            }
            this.skipWhitespace();
            if (this.input.isEmpty()) {
                return (Token)this.endOfData();
            }
            String nextCh = this.input.substring(0, 1);
            if (STRING_STARTERS.contains(nextCh)) {
                return this.consumeStringLiteral();
            }
            if (TokenUtils.isOpeningBracket(nextCh)) {
                return this.rawToken(1, TokenType.LEFT_BRACKET);
            }
            if (TokenUtils.isClosingBracket(nextCh)) {
                return this.rawToken(1, TokenType.RIGHT_BRACKET);
            }
            if (nextCh.equals(",")) {
                return this.rawToken(1, TokenType.SEPARATOR);
            }
            Matcher symbolMatcher = SYMBOL.matcher(this.input);
            if (symbolMatcher.find()) {
                String symbol = symbolMatcher.group(1);
                String modifier = this.findPrefix(this.modifiers);
                if (modifier != null && modifier.length() >= symbol.length()) {
                    this.discardInput(modifier.length());
                    return new Token(TokenType.MODIFIER, modifier);
                }
                String operator = this.findPrefix(this.operators);
                if (operator != null && operator.length() >= symbol.length()) {
                    this.discardInput(operator.length());
                    return new Token(TokenType.OPERATOR, operator);
                }
                this.discardInput(symbolMatcher.end());
                Matcher argMatcher = SYMBOL_ARGS.matcher(this.input);
                if (argMatcher.find()) {
                    this.discardInput(argMatcher.end());
                    String symbolArgs = argMatcher.group(1);
                    return new Token(TokenType.SYMBOL_WITH_ARGS, symbol + symbolArgs);
                }
                return new Token(TokenType.SYMBOL, symbol);
            }
            String modifier = this.findPrefix(this.modifiers);
            if (modifier != null) {
                this.discardInput(modifier.length());
                return new Token(TokenType.MODIFIER, modifier);
            }
            String operator = this.findPrefix(this.operators);
            if (operator != null) {
                this.discardInput(operator.length());
                return new Token(TokenType.OPERATOR, operator);
            }
            Token result = this.tryPattern(QUOTED_NUMBER, TokenType.QUOTED_NUMBER);
            if (result != null) {
                return result;
            }
            result = this.tryPattern(HEX_NUMBER, TokenType.HEX_NUMBER);
            if (result != null) {
                return result;
            }
            result = this.tryPattern(OCT_NUMBER, TokenType.OCT_NUMBER);
            if (result != null) {
                return result;
            }
            result = this.tryPattern(BIN_NUMBER, TokenType.BIN_NUMBER);
            if (result != null) {
                return result;
            }
            result = this.tryPattern(DEC_NUMBER, TokenType.DEC_NUMBER);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unknown token type: '" + this.input + "'");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse: '" + this.input + "'", e);
        }
    }

    private Token consumeStringLiteral() {
        Pair<String, Integer> result = StringEscaper.unescapeDelimitedString(this.input, 0);
        this.discardInput((Integer)result.getRight());
        return new Token(TokenType.STRING, (String)result.getLeft());
    }

    private void discardInput(int length) {
        this.input = this.input.substring(length);
    }

    private Token rawToken(int charCount, TokenType type) {
        String value = this.input.substring(0, charCount);
        this.discardInput(charCount);
        return new Token(type, value);
    }

    private String tryPattern(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.input);
        if (matcher.find()) {
            String matched = matcher.group(1);
            this.discardInput(matcher.end());
            return matched;
        }
        return null;
    }

    private Token tryPattern(Pattern pattern, TokenType type) {
        String matched = this.tryPattern(pattern);
        return matched != null ? new Token(type, matched) : null;
    }

    private String findPrefix(Multiset<String> prefixes) {
        for (String operator : prefixes.elementSet()) {
            if (!this.input.startsWith(operator)) continue;
            return operator;
        }
        return null;
    }

    private void skipWhitespace() {
        int i;
        for (i = 0; i < this.input.length() && Character.isWhitespace(this.input.charAt(i)); ++i) {
        }
        if (i > 0) {
            this.discardInput(i);
        }
    }

    public void addModifier(String modifier) {
        this.modifiers.add((Object)modifier);
    }

    public void removeModifier(String modifier) {
        this.modifiers.add((Object)modifier);
    }

    public void addOperator(String operator) {
        this.operators.add((Object)operator);
    }

    public void removeOperator(String operator) {
        this.operators.add((Object)operator);
    }
}

