/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ItemModTypeFilter;

public class ModPiston
extends ItemModTypeFilter {
    String tooltipName = "\u00a77Knockback";
    int max = 10;

    public ModPiston(int effect, ItemStack[] items, int[] values) {
        super(effect, "Piston", items, values);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        if (tool.func_77973_b() instanceof ToolCore) {
            ToolCore toolItem = (ToolCore)tool.func_77973_b();
            if (!this.validType(toolItem)) {
                return false;
            }
            if (this.matchingAmount(input) > this.max) {
                return false;
            }
            NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
            if (!tags.func_74764_b(this.key)) {
                return tags.func_74762_e("Modifiers") > 0 && this.matchingAmount(input) <= this.max;
            }
            int[] keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] + this.matchingAmount(input) <= keyPair[1]) {
                return true;
            }
            if (keyPair[0] == keyPair[1]) {
                return tags.func_74762_e("Modifiers") > 0;
            }
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int increase = this.matchingAmount(input);
        if (tags.func_74764_b(this.key)) {
            int[] keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.func_74783_a(this.key, keyPair);
                int modifiers = tags.func_74762_e("Modifiers");
                tags.func_74768_a("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.func_74783_a(this.key, keyPair);
            }
            this.updateModTag(tool, keyPair);
        } else {
            int modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --modifiers);
            String modName = "\u00a74Knockback (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            int[] keyPair = new int[]{increase, this.max, tooltipIndex};
            tags.func_74783_a(this.key, keyPair);
        }
        float knockback = tags.func_74760_g("Knockback");
        knockback = (float)((double)knockback + 0.1 * (double)increase);
        tags.func_74776_a("Knockback", knockback);
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a77Knockback (" + keys[0] + "/" + keys[1] + ")";
        tags.func_74778_a(tip, modName);
    }

    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.getTraits());
        return list.contains("weapon") || list.contains("ammo");
    }
}

