/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.util.FakePlayer;
import openblocks.Config;
import openmods.api.IActivateAwareTile;
import openmods.api.IAddAwareTile;
import openmods.api.INeighbourAwareTile;
import openmods.api.IPlacerAwareTile;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableString;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntityGrave
extends SyncedTileEntity
implements IPlacerAwareTile,
IInventoryProvider,
INeighbourAwareTile,
IActivateAwareTile,
IAddAwareTile {
    private static final String TAG_MESSAGE = "Message";
    private SyncableString perishedUsername;
    public SyncableBoolean onSoil;
    private IChatComponent deathMessage;
    private GenericInventory inventory = this.registerInventoryCallback(new GenericInventory("grave", false, 1));

    protected void createSyncedFields() {
        this.perishedUsername = new SyncableString();
        this.onSoil = new SyncableBoolean(true);
    }

    public void func_145845_h() {
        List mobs;
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && Config.spawnSkeletons && this.field_145850_b.field_73013_u != EnumDifficulty.PEACEFUL && this.field_145850_b.field_73012_v.nextDouble() < Config.skeletonSpawnRate && (mobs = this.field_145850_b.func_72872_a(IMob.class, this.getBB().func_72314_b(7.0, 7.0, 7.0))).size() < 5) {
            double chance = this.field_145850_b.field_73012_v.nextDouble();
            EntitySkeleton living = chance < 0.5 ? new EntitySkeleton(this.field_145850_b) : new EntityBat(this.field_145850_b);
            living.func_70080_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (living.func_70601_bi()) {
                this.field_145850_b.func_72838_d((Entity)living);
            }
        }
    }

    public String getUsername() {
        return this.perishedUsername.getValue();
    }

    public void setDeathMessage(IChatComponent msg) {
        this.deathMessage = msg.func_150259_f();
    }

    public void setUsername(String username) {
        this.perishedUsername.setValue(username);
    }

    public void setLoot(IInventory invent) {
        this.inventory.clearAndSetSlotCount(invent.func_70302_i_());
        this.inventory.copyFrom(invent);
    }

    public boolean isOnSoil() {
        return this.onSoil.get();
    }

    public void onBlockPlacedBy(EntityLivingBase placer, ItemStack stack) {
        if (!this.field_145850_b.field_72995_K && placer instanceof EntityPlayer && !(placer instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)placer;
            if (stack.func_82837_s()) {
                this.setUsername(stack.func_82833_r());
            } else {
                this.setUsername(player.func_146103_bH().getName());
            }
            if (player.field_71075_bZ.field_75098_d) {
                this.setLoot((IInventory)player.field_71071_by);
            }
            this.updateBlockBelow();
            this.sync();
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
        if (this.deathMessage != null) {
            String serialized = IChatComponent.Serializer.func_150696_a((IChatComponent)this.deathMessage);
            tag.func_74778_a(TAG_MESSAGE, serialized);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
        String serializedMsg = tag.func_74779_i(TAG_MESSAGE);
        if (!Strings.isNullOrEmpty((String)serializedMsg)) {
            this.deathMessage = IChatComponent.Serializer.func_150699_a((String)serializedMsg);
        }
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    protected void updateBlockBelow() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        this.onSoil.set(block == Blocks.field_150346_d || block == Blocks.field_150349_c);
    }

    public void onAdded() {
        this.updateBlockBelow();
    }

    public void onNeighbourChanged(Block block) {
        this.updateBlockBelow();
        this.sync();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack held = player.func_70694_bm();
        if (held != null && held.func_77973_b().getToolClasses(held).contains("shovel")) {
            this.robGrave(player, held);
            return true;
        }
        if (this.deathMessage != null) {
            player.func_145747_a(this.deathMessage);
        }
        return true;
    }

    protected void robGrave(EntityPlayer player, ItemStack held) {
        boolean dropped = false;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null) continue;
            dropped = true;
            BlockUtils.dropItemStackInWorld((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (ItemStack)stack);
        }
        this.inventory.clearAndSetSlotCount(0);
        if (dropped) {
            this.field_145850_b.func_72889_a(null, 2001, this.field_145851_c, this.field_145848_d, this.field_145849_e, Block.func_149682_b((Block)Blocks.field_150346_d));
            if (this.field_145850_b.field_73012_v.nextDouble() < Config.graveSpecialAction) {
                this.ohNoes(player);
            }
            held.func_77972_a(2, (EntityLivingBase)player);
        }
    }

    private void ohNoes(EntityPlayer player) {
        this.field_145850_b.func_72956_a((Entity)player, "openblocks:grave.rob", 1.0f, 1.0f);
        WorldInfo worldInfo = this.field_145850_b.func_72912_H();
        worldInfo.func_76090_f(700);
        worldInfo.func_76080_g(700);
        worldInfo.func_76069_a(true);
        worldInfo.func_76084_b(true);
    }
}

