/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.sync;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.common.Stencil;
import openmods.sync.SyncableObjectBase;

public class SyncableBlockLayers
extends SyncableObjectBase {
    public final LinkedList<Layer> layers = Lists.newLinkedList();

    public void readFromStream(DataInputStream stream) throws IOException {
        byte size = stream.readByte();
        this.layers.clear();
        for (byte i = 0; i < size; i = (byte)(i + 1)) {
            this.layers.add(Layer.createFromStream(stream));
        }
    }

    public void writeToStream(DataOutputStream stream) throws IOException {
        stream.writeByte(this.layers.size());
        for (Layer layer : this.layers) {
            stream.writeInt(layer.getColor());
            stream.writeByte(layer.getRotation());
            if (layer.getStencil() != null) {
                stream.writeByte(layer.getStencil().ordinal());
            } else {
                stream.writeByte(-1);
            }
            stream.writeBoolean(layer.hasStencilCover());
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74768_a("size", this.layers.size());
        int i = 0;
        for (Layer layer : this.layers) {
            subTag.func_74782_a("layer_" + i, (NBTBase)layer.getNBT());
            ++i;
        }
        nbt.func_74782_a(name, (NBTBase)subTag);
    }

    public void readFromNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound subTag = nbt.func_74775_l(name);
        int size = subTag.func_74762_e("size");
        this.layers.clear();
        for (int i = 0; i < size; ++i) {
            this.layers.add(Layer.createFromNBT(subTag.func_74775_l("layer_" + i)));
        }
    }

    public List<Layer> getAllLayers() {
        return this.layers;
    }

    public boolean isLastLayerStencil() {
        Layer last = this.layers.peekLast();
        return last != null && last.hasStencilCover && last.stencil != null;
    }

    public void setLastLayerColor(int color) {
        Layer last = this.getOrCreateLastLayer();
        boolean hasChanged = last.setColor(color);
        if (hasChanged) {
            this.markDirty();
        }
    }

    public void setLastLayerStencil(Stencil stencil) {
        Layer last = this.getOrCreateLastLayer();
        last.hasStencilCover = true;
        last.stencil = stencil;
        this.markDirty();
    }

    private Layer getOrCreateLastLayer() {
        Layer last = this.layers.peekLast();
        if (last == null) {
            last = new Layer();
            this.layers.addLast(last);
        }
        return last;
    }

    public void moveStencilToNextLayer() {
        Layer prevTop = this.layers.getLast();
        prevTop.setHasStencilCover(false);
        Layer newLayer = new Layer();
        newLayer.setStencil(prevTop.getStencil());
        newLayer.setHasStencilCover(true);
        newLayer.setRotation(prevTop.getRotation());
        this.layers.addLast(newLayer);
        this.markDirty();
    }

    public void pushNewStencil(Stencil stencil) {
        Layer newLayer = new Layer();
        newLayer.setStencil(stencil);
        newLayer.setHasStencilCover(true);
        this.layers.addLast(newLayer);
        this.markDirty();
    }

    public Layer getLayer(int i) {
        if (i < this.layers.size()) {
            return this.layers.get(i);
        }
        return null;
    }

    public void removeCover() {
        Layer last = this.layers.peekLast();
        if (last != null && last.hasStencilCover()) {
            this.layers.removeLast();
            this.markDirty();
        }
    }

    public Stencil getTopStencil() {
        Layer top = this.layers.peekLast();
        return top != null ? top.stencil : null;
    }

    public void rotateCover() {
        Layer lastLayer = this.layers.peekLast();
        if (lastLayer != null && lastLayer.hasStencilCover()) {
            lastLayer.rotate();
            this.markDirty();
        }
    }

    public void clear() {
        if (!this.layers.isEmpty()) {
            this.layers.clear();
            this.markDirty();
        }
    }

    public boolean isEmpty() {
        return this.layers.isEmpty();
    }

    public static class Layer {
        private int color;
        private Stencil stencil;
        private byte rotation;
        private boolean hasStencilCover = false;

        public Layer() {
        }

        public Layer(int col) {
            this.color = col;
        }

        public int getColor() {
            return this.color;
        }

        public int getColorForRender() {
            return this.hasStencilCover() ? 0xFFFFFF : this.getColor();
        }

        public Stencil getStencil() {
            return this.stencil;
        }

        public byte getRotation() {
            return this.rotation;
        }

        public boolean hasStencilCover() {
            return this.hasStencilCover;
        }

        public void setHasStencilCover(boolean cover) {
            this.hasStencilCover = cover;
        }

        public void setRotation(byte rotation) {
            this.rotation = rotation;
        }

        public void setStencil(Stencil st) {
            this.stencil = st;
        }

        public boolean setColor(int color) {
            if (this.color != color) {
                this.color = color;
                return true;
            }
            return false;
        }

        public static Layer createFromStream(DataInput stream) {
            Layer layer = new Layer();
            try {
                layer.setColor(stream.readInt());
                layer.setRotation(stream.readByte());
                byte b = stream.readByte();
                if (b > -1) {
                    layer.setStencil(Stencil.values()[b]);
                }
                layer.setHasStencilCover(stream.readBoolean());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return layer;
        }

        public void rotate() {
            this.rotation = (byte)(this.rotation + 1);
            if (this.rotation > 3) {
                this.rotation = 0;
            }
        }

        public NBTTagCompound getNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("rotation", this.rotation);
            nbt.func_74778_a("stencil", this.stencil.name());
            nbt.func_74757_a("hasStencilCover", this.hasStencilCover);
            nbt.func_74768_a("color", this.color);
            return nbt;
        }

        public static Layer createFromNBT(NBTTagCompound compoundTag) {
            Layer layer = new Layer();
            layer.setColor(compoundTag.func_74762_e("color"));
            layer.setHasStencilCover(compoundTag.func_74767_n("hasStencilCover"));
            layer.setRotation(compoundTag.func_74771_c("rotation"));
            layer.setStencil(Stencil.valueOf(compoundTag.func_74779_i("stencil")));
            return layer;
        }
    }
}

