/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.Net.Packet;

import com.advGenetics.Net.ClientPacketHandler;
import com.advGenetics.Net.CommonPacketHandler;
import com.advGenetics.Net.Packet.AbstractPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

public class Packet2Custom
extends AbstractPacket {
    public int packetID;
    public int idata;
    public int packetType;
    public String sdata;

    public Packet2Custom() {
    }

    public Packet2Custom(int packetID, int data) {
        this.packetID = packetID;
        this.idata = data;
        this.packetType = 0;
    }

    public Packet2Custom(int packetID, String data) {
        this.packetID = packetID;
        this.sdata = data;
        this.packetType = 1;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.packetID);
        buffer.writeInt(this.packetType);
        if (this.packetType == 0) {
            buffer.writeInt(this.idata);
        } else {
            buffer.writeInt(this.sdata.getBytes().length);
            buffer.writeBytes(this.sdata.getBytes());
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.packetID = buffer.readInt();
        this.packetType = buffer.readInt();
        if (this.packetType == 0) {
            this.idata = buffer.readInt();
        } else {
            int size = buffer.readInt();
            this.sdata = new String(buffer.readBytes(size).array());
        }
    }

    @Override
    public void handleClientSide(ByteBuf stream, AbstractPacket packet, EntityPlayer player) {
        ClientPacketHandler.onPacketData(stream, packet, player);
    }

    @Override
    public void handleServerSide(ByteBuf stream, AbstractPacket packet, EntityPlayer player) {
        CommonPacketHandler.onPacketData(stream, packet, player);
    }
}

