/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.DNA.Abilities;

import com.advGenetics.API.Ability;
import com.advGenetics.API.IAddRemove;
import com.advGenetics.API.ILivingDeath;
import com.advGenetics.API.ILivingJoin;
import com.advGenetics.AdvGenetics;
import com.advGenetics.DNA.DNA;
import com.advGenetics.Lib.AdvGenUtil;
import com.advGenetics.Renderer.AbilityRenderer;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class AbilityMoreHearts
extends Ability
implements ILivingJoin,
IAddRemove,
ILivingDeath {
    @Override
    public String getUnlocalizedName() {
        return "morehearts";
    }

    @Override
    public String getName() {
        return "More hearts";
    }

    @Override
    public int getRarity() {
        return 28;
    }

    @Override
    public int getBreedingState() {
        return 14;
    }

    @Override
    public boolean isAllowed() {
        return AdvGenetics.allow_MORE_HEARTS;
    }

    @Override
    public void onLivingDeath(LivingDeathEvent event) {
        this.removeFromDNA(event.entity);
    }

    @Override
    public void removeFromDNA(Entity target) {
        EntityLivingBase entity = (EntityLivingBase)target;
        HashMap attrMap = Maps.newHashMap();
        attrMap.put(SharedMonsterAttributes.field_111267_a, new AttributeModifier(UUID.fromString("5D6F0BA2-1186-46AC-B896-C61C5CEE99CC"), "potion.healthBoost", 6.5, 0));
        this.removeAttributesModifiersFromEntity(entity, attrMap);
        if (entity.func_110143_aJ() > 0.0f) {
            entity.func_70606_j(entity.func_110138_aP());
        }
    }

    @Override
    public void addToDNA(Entity target) {
        EntityLivingBase entity = (EntityLivingBase)target;
        HashMap attrMap = Maps.newHashMap();
        attrMap.put(SharedMonsterAttributes.field_111267_a, new AttributeModifier(UUID.fromString("5D6F0BA2-1186-46AC-B896-C61C5CEE99CC"), "potion.healthBoost", 6.5, 0));
        this.applyAttributesModifiersToEntity(entity, attrMap, 2);
        entity.func_70606_j(entity.func_110138_aP());
    }

    private void applyAttributesModifiersToEntity(EntityLivingBase entity, Map map, int i) {
        for (Map.Entry entry : map.entrySet()) {
            IAttributeInstance instance = entity.func_110140_aT().func_111151_a((IAttribute)entry.getKey());
            if (instance == null) continue;
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            instance.func_111124_b(modifier);
            instance.func_111121_a(new AttributeModifier(modifier.func_111167_a(), ((IAttribute)entry.getKey()).func_111108_a(), modifier.func_111164_d() * (double)(i + 1), modifier.func_111169_c()));
        }
    }

    private void removeAttributesModifiersFromEntity(EntityLivingBase entity, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            IAttributeInstance instance = entity.func_110140_aT().func_111151_a((IAttribute)entry.getKey());
            if (instance == null) continue;
            instance.func_111124_b((AttributeModifier)entry.getValue());
        }
    }

    @Override
    public void onLivingJoin(EntityJoinWorldEvent event) {
        AdvGenUtil.updatePlayerCapatilities(new DNA(event.entity.getEntityData()), event.entity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onEntityRender(EntityLivingBase entity, RendererLivingEntity renderer) {
        super.onEntityRender(entity, renderer);
        AbilityRenderer.renderIronGolemMutation(entity, renderer);
    }
}

