/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.TileEntities;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import lumien.randomthings.Blocks.ModBlocks;
import lumien.randomthings.Library.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class TileEntityOnlineDetector
extends TileEntity
implements SimpleComponent,
IPeripheral {
    String username = "";
    int tickRate = 20;
    int tickCounter = 0;

    public void func_145845_h() {
        int metadata;
        int playerOnline;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L && (playerOnline = WorldUtils.isPlayerOnline(this.username) ? 1 : 0) != (metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, playerOnline, 3);
            WorldUtils.notifyStrong(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)ModBlocks.onlineDetector);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("username", this.username);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.username = nbt.func_74779_i("username");
    }

    public void setUsername(String username) {
        this.username = username;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public String getPlayerName() {
        return this.username;
    }

    public String getComponentName() {
        return "onlinedetector";
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isPlayerOnline(Context context, Arguments args) {
        return new Object[]{WorldUtils.isPlayerOnline(args.checkString(0))};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getPlayerList(Context context, Arguments args) {
        List playerEntityList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        String[] playerNameList = new String[playerEntityList.size()];
        for (int i = 0; i < playerNameList.length; ++i) {
            playerNameList[i] = ((EntityPlayer)playerEntityList.get(i)).func_70005_c_();
        }
        return new Object[]{playerNameList};
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "onlinedetector";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"isPlayerOnline", "getPlayerList"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    return null;
                }
                return new Object[]{WorldUtils.isPlayerOnline(arguments[0] + "")};
            }
            case 1: {
                return new Object[]{this.generatePlayerMap()};
            }
        }
        return null;
    }

    private Map<Integer, String> generatePlayerMap() {
        List playerEntityList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        String[] playerNameList = new String[playerEntityList.size()];
        for (int i = 0; i < playerNameList.length; ++i) {
            playerNameList[i] = ((EntityPlayer)playerEntityList.get(i)).func_70005_c_();
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int index = 0; index < playerNameList.length; ++index) {
            map.put(index, playerNameList[index]);
        }
        return map;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return false;
    }
}

