/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.TileEntities.EnergyDistributors;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import java.util.HashSet;
import lumien.randomthings.Configuration.Settings;
import lumien.randomthings.Library.Interfaces.IValidator;
import lumien.randomthings.Library.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergyDistributor
extends TileEntity
implements IEnergyReceiver {
    protected HashSet<TileEntity> receiverCache;
    public ForgeDirection facing;
    EnergyStorage buffer;
    int energyDistributedLastTick = 0;
    int machinesConnected = 0;
    IValidator validator = new IValidator(){

        @Override
        public boolean matches(Object o) {
            return o instanceof TileEntity & !(o instanceof TileEntityEnergyDistributor) && o instanceof IEnergyReceiver;
        }
    };

    public TileEntityEnergyDistributor() {
        this.receiverCache = new HashSet();
        this.facing = ForgeDirection.UP;
        this.buffer = new EnergyStorage(Settings.ENERGY_DISTRIBUTOR_BUFFERSIZE);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("facing", this.facing.ordinal());
        this.buffer.writeToNBT(nbt);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.facing = ForgeDirection.getOrientation((int)nbt.func_74762_e("facing"));
        this.buffer.readFromNBT(nbt);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 100L == 0L) {
                this.fillReceiverCache();
            }
            int limit = Settings.ENERGY_DISTRIBUTOR_PERTICK;
            this.energyDistributedLastTick = 0;
            for (TileEntity te : this.receiverCache) {
                if (te.func_145837_r()) continue;
                IEnergyReceiver er = (IEnergyReceiver)te;
                int consumed = er.receiveEnergy(ForgeDirection.UP, Math.min(limit, Math.min(this.buffer.getEnergyStored(), Settings.ENERGY_DISTRIBUTOR_PERMACHINE)), false);
                this.buffer.setEnergyStored(this.buffer.getEnergyStored() - consumed);
                this.energyDistributedLastTick += consumed;
                if (this.buffer.getEnergyStored() != 0 && (limit -= consumed) != 0) continue;
                break;
            }
        }
    }

    protected void fillReceiverCache() {
        this.receiverCache = WorldUtils.getConnectedTEs(this.field_145850_b, this.field_145851_c + this.facing.offsetX, this.field_145848_d + this.facing.offsetY, this.field_145849_e + this.facing.offsetZ, this.validator);
        this.machinesConnected = this.receiverCache.size();
        while (this.receiverCache.size() > Settings.ENERGY_DISTRIBUTOR_MAXMACHINES) {
            this.receiverCache.remove(this.receiverCache.toArray()[0]);
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != this.facing;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.buffer.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.buffer.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.buffer.getMaxEnergyStored();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int getEnergyDistributedLastTick() {
        return this.energyDistributedLastTick;
    }

    public int getMachinesConnected() {
        return this.machinesConnected;
    }
}

