/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.TileEntities.EnergyDistributors;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import java.util.HashSet;
import lumien.randomthings.Configuration.Settings;
import lumien.randomthings.Items.ItemFilter;
import lumien.randomthings.Library.DimensionCoordinate;
import lumien.randomthings.Library.Interfaces.IValidator;
import lumien.randomthings.Library.InventoryUtils;
import lumien.randomthings.Library.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnderEnergyDistributor
extends TileEntity
implements IEnergyReceiver {
    InventoryBasic targetSlots = new InventoryBasic("Targets", false, 8);
    protected HashSet<TileEntity> receiverCache;
    EnergyStorage buffer;
    int energyDistributedLastTick;
    int machinesConnected = 0;
    IValidator validator = new IValidator(){

        @Override
        public boolean matches(Object o) {
            return o instanceof TileEntity & !(o instanceof TileEntityEnderEnergyDistributor) && o instanceof IEnergyReceiver;
        }
    };

    public TileEntityEnderEnergyDistributor() {
        this.buffer = new EnergyStorage(Settings.ENDER_ENERGY_DISTRIBUTOR_BUFFERSIZE);
        this.receiverCache = new HashSet();
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        InventoryUtils.writeInventoryToNBT((IInventory)this.targetSlots, nbt);
        this.buffer.writeToNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.buffer.readFromNBT(nbt);
        InventoryUtils.readInventoryFromNBT((IInventory)this.targetSlots, nbt);
    }

    public IInventory getInventory() {
        return this.targetSlots;
    }

    public int getMachinesConnected() {
        return this.machinesConnected;
    }

    private void fillReceiverCache() {
        this.receiverCache = new HashSet();
        for (int i = 0; i < this.targetSlots.func_70302_i_(); ++i) {
            ItemStack is = this.targetSlots.func_70301_a(i);
            if (is == null) continue;
            DimensionCoordinate dc = ItemFilter.getPosition(is);
            if (dc.dimension != this.field_145850_b.field_73011_w.field_76574_g || !(dc.getDistanceSqrd(this.field_145851_c, this.field_145848_d, this.field_145849_e) <= (double)Settings.ENDER_ENERGY_DISTRIBUTOR_RANGE_SQRD)) continue;
            WorldUtils.recConnectedTEs(this.receiverCache, this.field_145850_b, dc.posX, dc.posY, dc.posZ, this.validator);
            TileEntity te = this.field_145850_b.func_147438_o(dc.posX, dc.posY, dc.posZ);
            if (te == null || te.func_145837_r() || !(te instanceof IEnergyReceiver) || te instanceof TileEntityEnderEnergyDistributor) continue;
            this.receiverCache.add(te);
        }
        this.machinesConnected = this.receiverCache.size();
        while (this.receiverCache.size() > Settings.ENDER_ENERGY_DISTRIBUTOR_MAXMACHINES) {
            this.receiverCache.remove(this.receiverCache.toArray()[0]);
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 100L == 0L) {
                this.fillReceiverCache();
            }
            int limit = Settings.ENDER_ENERGY_DISTRIBUTOR_PERTICK;
            this.energyDistributedLastTick = 0;
            for (TileEntity te : this.receiverCache) {
                if (te.func_145837_r()) continue;
                IEnergyReceiver er = (IEnergyReceiver)te;
                int consumed = er.receiveEnergy(ForgeDirection.UP, Math.min(limit, Math.min(this.buffer.getEnergyStored(), Settings.ENDER_ENERGY_DISTRIBUTOR_PERMACHINE)), false);
                this.buffer.setEnergyStored(this.buffer.getEnergyStored() - consumed);
                this.energyDistributedLastTick += consumed;
                if (this.buffer.getEnergyStored() != 0 && (limit -= consumed) != 0) continue;
                break;
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.buffer.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.buffer.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.buffer.getMaxEnergyStored();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int getEnergyDistributedLastTick() {
        return this.energyDistributedLastTick;
    }

    public void dropItems() {
        for (int slot = 0; slot < this.targetSlots.func_70302_i_(); ++slot) {
            if (this.targetSlots.func_70301_a(slot) == null) continue;
            WorldUtils.dropItemStack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.targetSlots.func_70301_a(slot));
        }
    }
}

