/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Items;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import lumien.randomthings.Configuration.Settings;
import lumien.randomthings.Items.ItemBase;
import lumien.randomthings.RandomThings;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ItemBiomeCapsule
extends ItemBase {
    public static HashMap<Integer, Integer> biomeColors;
    static Random rng;
    static final float modColor = 0.003921569f;

    public ItemBiomeCapsule() {
        super("biomeCapsule");
        this.func_77625_d(1);
        biomeColors = new HashMap();
        biomeColors.put(0, 1452177);
        biomeColors.put(7, 4303848);
        biomeColors.put(8, 0x5C0000);
        biomeColors.put(9, 8223332);
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldObj, Entity entity, int slot, boolean p_77663_5_) {
        int biomeID;
        BiomeGenBase biome;
        if (!worldObj.field_72995_K && worldObj.func_82737_E() % 20L == 0L && stack.func_77960_j() != 0 && (biome = BiomeGenBase.func_150568_d((int)(biomeID = stack.func_77960_j() - 1))) == null && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71071_by.func_70299_a(slot, null);
            ((EntityPlayer)entity).field_71069_bz.func_75142_b();
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (stack.func_77960_j() != 0) {
            NBTTagCompound nbt = stack.field_77990_d;
            if (nbt == null) {
                nbt = stack.field_77990_d = new NBTTagCompound();
                nbt.func_74768_a("charges", 0);
            }
            par3List.add("Charges: " + nbt.func_74762_e("charges") + " / " + this.getMaxDamage(stack));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return 256;
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.func_77960_j() != 0) {
            NBTTagCompound nbt = stack.field_77990_d;
            if (nbt == null) {
                nbt = stack.field_77990_d = new NBTTagCompound();
                nbt.func_74768_a("charges", 0);
            }
            return 256 - nbt.func_74762_e("charges");
        }
        return 0;
    }

    @Override
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("RandomThings:biomeCapsule");
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70170_p.field_72995_K) {
            ItemStack is = entityItem.func_92059_d();
            BiomeGenBase biome = entityItem.field_70170_p.func_72807_a((int)Math.floor(entityItem.field_70165_t), (int)Math.floor(entityItem.field_70161_v));
            NBTTagCompound nbt = is.field_77990_d;
            if (nbt == null) {
                nbt = is.field_77990_d = new NBTTagCompound();
                nbt.func_74768_a("charges", 0);
            }
            int charges = is.field_77990_d.func_74762_e("charges");
            int biomeID = is.func_77960_j() - 1;
            if (charges < 256 && biomeID != -1 && biome.field_76756_M == biomeID) {
                int intColor = ItemBiomeCapsule.getColorForBiome(BiomeGenBase.func_150568_d((int)biomeID));
                Color c = new Color(intColor);
                RandomThings.proxy.spawnColoredDust(entityItem.field_70165_t, entityItem.field_70163_u + 0.1, entityItem.field_70161_v, 0.0, 0.0, 0.0, 0.003921569f * (float)c.getRed(), 0.003921569f * (float)c.getGreen(), 0.003921569f * (float)c.getBlue());
            }
        } else if (entityItem.func_92059_d().func_77960_j() == 0) {
            NBTTagCompound nbt = entityItem.getEntityData();
            if (nbt.func_74762_e("selectingTimer") == 0) {
                nbt.func_74768_a("selectingTimer", 200);
            } else {
                int currentTime = nbt.func_74762_e("selectingTimer");
                if (currentTime == 1) {
                    BiomeGenBase biome = entityItem.field_70170_p.func_72807_a((int)Math.floor(entityItem.field_70165_t), (int)Math.floor(entityItem.field_70161_v));
                    ItemStack is = entityItem.func_92059_d();
                    is.func_77964_b(biome.field_76756_M + 1);
                    entityItem.func_92058_a(is);
                } else {
                    nbt.func_74768_a("selectingTimer", --currentTime);
                }
            }
        } else {
            entityItem.field_70292_b = 0;
            ItemStack is = entityItem.func_92059_d();
            NBTTagCompound nbt = is.field_77990_d;
            if (nbt == null) {
                nbt = is.field_77990_d = new NBTTagCompound();
                nbt.func_74768_a("charges", 0);
            }
            int charges = is.field_77990_d.func_74762_e("charges");
            int biomeID = is.func_77960_j() - 1;
            if (charges < 256 && entityItem.field_70170_p.func_82737_E() % (long)Settings.BIOME_CHARGE_TIME == 0L) {
                int itemPosX = (int)Math.floor(entityItem.field_70165_t);
                int itemPosY = (int)Math.floor(entityItem.field_70163_u);
                int itemPosZ = (int)Math.floor(entityItem.field_70161_v);
                int foundBiomeID = entityItem.field_70170_p.func_72807_a((int)itemPosX, (int)itemPosZ).field_76756_M;
                if (foundBiomeID == biomeID) {
                    is.field_77990_d.func_74768_a("charges", ++charges);
                }
            }
        }
        return false;
    }

    public static int getColorForBiome(BiomeGenBase b) {
        if (biomeColors.containsKey(b.field_76756_M)) {
            return biomeColors.get(b.field_76756_M);
        }
        return b.func_150571_c(0, 0, 0);
    }

    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        if (par1ItemStack.func_77960_j() == 0) {
            return 0xFFFFFF;
        }
        int biomeID = par1ItemStack.func_77960_j() - 1;
        BiomeGenBase biome = BiomeGenBase.func_150568_d((int)biomeID);
        if (biome != null) {
            return ItemBiomeCapsule.getColorForBiome(biome);
        }
        return BiomeGenBase.field_76771_b.func_150571_c(0, 0, 0);
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        String biomeName = "";
        if (par1ItemStack.func_77960_j() == 0) {
            return ("" + StatCollector.func_74838_a((String)"item.biomeCapsule.name")).trim();
        }
        int biomeID = par1ItemStack.func_77960_j() - 1;
        BiomeGenBase biome = BiomeGenBase.func_150568_d((int)biomeID);
        biomeName = biome != null ? biome.field_76791_y : "Invalid";
        return biomeName + " Capsule";
    }

    static {
        rng = new Random();
    }
}

