/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Blocks;

import java.util.Random;
import lumien.randomthings.Blocks.BlockBase;
import lumien.randomthings.Blocks.ModBlocks;
import lumien.randomthings.Configuration.Settings;
import lumien.randomthings.RandomThings;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFertilizedDirt
extends BlockBase {
    boolean tilled;

    protected BlockFertilizedDirt(boolean tilled) {
        super("fertilizedDirt" + (tilled ? "_tilled" : ""), Material.field_151578_c);
        this.tilled = tilled;
        this.func_149675_a(true);
        this.func_149711_c(0.6f);
        this.func_149672_a(field_149767_g);
        if (tilled) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
            this.func_149713_g(255);
        }
        if (!tilled) {
            this.func_149647_a(RandomThings.creativeTab);
        } else {
            this.func_149647_a(null);
        }
        this.func_149658_d("RandomThings:fertilizedDirt");
    }

    public boolean func_149686_d() {
        return !this.tilled;
    }

    public String func_149739_a() {
        return "tile.fertilizedDirt";
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return AxisAlignedBB.func_72330_a((double)(p_149668_2_ + 0), (double)(p_149668_3_ + 0), (double)(p_149668_4_ + 0), (double)(p_149668_2_ + 1), (double)(p_149668_3_ + 1), (double)(p_149668_4_ + 1));
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.func_150898_a((Block)ModBlocks.fertilizedDirt);
    }

    public boolean func_149662_c() {
        return !this.tilled;
    }

    public boolean isFertile(World world, int x, int y, int z) {
        return true;
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        Block plant = plantable.getPlant(world, x, y + 1, z);
        EnumPlantType plantType = plantable.getPlantType(world, x, y + 1, z);
        switch (plantType) {
            case Desert: {
                return !this.tilled;
            }
            case Nether: {
                return false;
            }
            case Crop: {
                return this.tilled;
            }
            case Cave: {
                return !this.tilled;
            }
            case Plains: {
                return !this.tilled;
            }
            case Water: {
                return false;
            }
            case Beach: {
                return !this.tilled;
            }
        }
        return false;
    }

    public void func_149674_a(World par1World, int posX, int posY, int posZ, Random rng) {
        if (!par1World.field_72995_K) {
            Block toBoost = par1World.func_147439_a(posX, posY + 1, posZ);
            if (toBoost != null && toBoost != Blocks.field_150350_a && toBoost instanceof IPlantable && Settings.FERTILIZEDDIRT_GROWTHINDICATOR) {
                par1World.func_72926_e(2005, posX, posY + 1, posZ, 0);
            }
            for (int i = 0; i < Settings.FERTILIZED_DIRT_GROWTH; ++i) {
                toBoost = par1World.func_147439_a(posX, posY + 1, posZ);
                if (toBoost == null || toBoost == Blocks.field_150350_a || !(toBoost instanceof IPlantable)) continue;
                toBoost.func_149674_a(par1World, posX, posY + 1, posZ, rng);
            }
        }
    }
}

