/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;

public class PngChunkTEXT
extends PngChunkTextVar {
    public static final String ID = "tEXt";

    public PngChunkTEXT(ImageInfo info) {
        super(ID, info);
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (this.key.isEmpty()) {
            throw new PngjException("Text chunk key must be non empty");
        }
        byte[] b = (this.key + "\u0000" + this.val).getBytes(PngHelperInternal.charsetLatin1);
        ChunkRaw chunk = this.createEmptyChunk(b.length, false);
        chunk.data = b;
        return chunk;
    }

    @Override
    public void parseFromRaw(ChunkRaw c) {
        int i;
        for (i = 0; i < c.data.length && c.data[i] != 0; ++i) {
        }
        this.key = new String(c.data, 0, i, PngHelperInternal.charsetLatin1);
        this.val = ++i < c.data.length ? new String(c.data, i, c.data.length - i, PngHelperInternal.charsetLatin1) : "";
    }

    @Override
    public void cloneDataFromRead(PngChunk other) {
        PngChunkTEXT otherx = (PngChunkTEXT)other;
        this.key = otherx.key;
        this.val = otherx.val;
    }
}

