/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PngChunkITXT
extends PngChunkTextVar {
    public static final String ID = "iTXt";
    private boolean compressed = false;
    private String langTag = "";
    private String translatedTag = "";

    public PngChunkITXT(ImageInfo info) {
        super(ID, info);
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (this.key.isEmpty()) {
            throw new PngjException("Text chunk key must be non empty");
        }
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ba.write(ChunkHelper.toBytes(this.key));
            ba.write(0);
            ba.write(this.compressed ? 1 : 0);
            ba.write(0);
            ba.write(ChunkHelper.toBytes(this.langTag));
            ba.write(0);
            ba.write(ChunkHelper.toBytesUTF8(this.translatedTag));
            ba.write(0);
            byte[] textbytes = ChunkHelper.toBytesUTF8(this.val);
            if (this.compressed) {
                textbytes = ChunkHelper.compressBytes(textbytes, true);
            }
            ba.write(textbytes);
            byte[] b = ba.toByteArray();
            ChunkRaw chunk = this.createEmptyChunk(b.length, false);
            chunk.data = b;
            return chunk;
        }
        catch (IOException e) {
            throw new PngjException(e);
        }
    }

    @Override
    public void parseFromRaw(ChunkRaw c) {
        int i;
        int nullsFound = 0;
        int[] nullsIdx = new int[3];
        for (i = 0; i < c.data.length; ++i) {
            if (c.data[i] != 0) continue;
            nullsIdx[nullsFound] = i;
            if (++nullsFound == 1) {
                i += 2;
            }
            if (nullsFound == 3) break;
        }
        if (nullsFound != 3) {
            throw new PngjException("Bad formed PngChunkITXT chunk");
        }
        this.key = ChunkHelper.toString(c.data, 0, nullsIdx[0]);
        i = nullsIdx[0] + 1;
        this.compressed = c.data[i] != 0;
        if (this.compressed && c.data[++i] != 0) {
            throw new PngjException("Bad formed PngChunkITXT chunk - bad compression method ");
        }
        this.langTag = new String(c.data, i, nullsIdx[1] - i, PngHelperInternal.charsetLatin1);
        this.translatedTag = new String(c.data, nullsIdx[1] + 1, nullsIdx[2] - nullsIdx[1] - 1, PngHelperInternal.charsetUTF8);
        i = nullsIdx[2] + 1;
        if (this.compressed) {
            byte[] bytes = ChunkHelper.compressBytes(c.data, i, c.data.length - i, false);
            this.val = ChunkHelper.toStringUTF8(bytes);
        } else {
            this.val = ChunkHelper.toStringUTF8(c.data, i, c.data.length - i);
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk other) {
        PngChunkITXT otherx = (PngChunkITXT)other;
        this.key = otherx.key;
        this.val = otherx.val;
        this.compressed = otherx.compressed;
        this.langTag = otherx.langTag;
        this.translatedTag = otherx.translatedTag;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public String getLangtag() {
        return this.langTag;
    }

    public void setLangtag(String langtag) {
        this.langTag = langtag;
    }

    public String getTranslatedTag() {
        return this.translatedTag;
    }

    public void setTranslatedTag(String translatedTag) {
        this.translatedTag = translatedTag;
    }
}

