/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.api;

import com.mrcrayfish.furniture.api.IRecipeRegistry;
import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeConditions;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.api.RecipeVariables;

public class RecipeRegistryComm
extends RecipeAPI
implements IRecipeRegistry {
    private static RecipeRegistryComm furnitureRegister = null;
    private String modName;

    public static RecipeRegistryComm getInstance(String modName) {
        if (furnitureRegister == null) {
            furnitureRegister = new RecipeRegistryComm();
        }
        RecipeRegistryComm.furnitureRegister.modName = modName;
        return furnitureRegister;
    }

    @Override
    public void registerRecipe(String type, RecipeVariables params) {
        if (type.equalsIgnoreCase("minebay")) {
            if (RecipeConditions.hasMineBayArgs(params)) {
                RecipeRegistryComm.addMineBayRecipe(RecipeData.convertFrom(params), 2);
            } else {
                System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a custom minebay item but does not have the required variables.");
            }
        } else if (type.equalsIgnoreCase("oven")) {
            if (RecipeConditions.hasOvenArgs(params)) {
                RecipeRegistryComm.addOvenRecipe(RecipeData.convertFrom(params), 2);
            } else {
                System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a custom oven recipe but does not have the required variables.");
            }
        } else if (type.equalsIgnoreCase("freezer")) {
            if (RecipeConditions.hasFreezerArgs(params)) {
                RecipeRegistryComm.addFreezerRecipe(RecipeData.convertFrom(params), 2);
            } else {
                System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a custom freezer recipe but does not have the required variables.");
            }
        } else if (type.equalsIgnoreCase("printer")) {
            if (RecipeConditions.hasPrinterArgs(params)) {
                RecipeRegistryComm.addPrinterRecipe(RecipeData.convertFrom(params), 2);
            } else {
                System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a custom printer recipe but does not have the required variables.");
            }
        } else if (type.equalsIgnoreCase("toaster")) {
            if (RecipeConditions.hasToasterArgs(params)) {
                System.err.println("Adding toaster recipe!");
                RecipeRegistryComm.addToasterRecipe(RecipeData.convertFrom(params), 2);
            } else {
                System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a custom toaster recipe but does not have the required variables.");
            }
        } else if (type.equalsIgnoreCase("choppingboard")) {
            if (RecipeConditions.hasChoppingBoardArgs(params)) {
                RecipeRegistryComm.addChoppingBoardRecipe(RecipeData.convertFrom(params), 2);
            } else {
                System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a custom chopping board recipe but does not have the required variables.");
            }
        } else if (type.equalsIgnoreCase("blender")) {
            if (RecipeConditions.hasBlenderArgs(params)) {
                RecipeRegistryComm.addBlenderRecipe(RecipeData.convertFrom(params), 2);
            } else {
                System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a custom blender recipe but does not have the required variables.");
            }
        } else if (type.equalsIgnoreCase("microwave")) {
            if (RecipeConditions.hasMicrowaveArgs(params)) {
                RecipeRegistryComm.addMicrowaveRecipe(RecipeData.convertFrom(params), 2);
            } else {
                System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a custom microwave recipe but does not have the required variables.");
            }
        } else if (type.equalsIgnoreCase("washingmachine")) {
            if (RecipeConditions.hasWashingMachineArgs(params)) {
                RecipeRegistryComm.addWashingMachineRecipe(RecipeData.convertFrom(params), 2);
            } else {
                System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a custom washing machine recipe but does not have the required variables.");
            }
        } else if (type.equalsIgnoreCase("dishwasher")) {
            if (RecipeConditions.hasDishwasherArgs(params)) {
                RecipeRegistryComm.addDishwasherRecipe(RecipeData.convertFrom(params), 2);
            } else {
                System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a custom dishwasher recipe but does not have the required variables.");
            }
        } else {
            System.err.println("RecipeAPI Error: The mod '" + this.modName + "' is trying to add a non existing recipe type '" + type + "'. This is most likely due to a mistake by the author or MrCrayfish's Furniture Mod not being the latest version installed.");
        }
        params.clear();
    }
}

