/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.api;

import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.api.Parser;
import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.handler.ConfigurationHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;

public class RecipeRegistry
extends RecipeAPI {
    private static RecipeRegistry furnitureRegister = null;

    public static RecipeRegistry getInstance() {
        if (furnitureRegister == null) {
            furnitureRegister = new RecipeRegistry();
        }
        return furnitureRegister;
    }

    public void registerMineBayItem(ItemStack item, ItemStack currency, int price) {
        RecipeRegistry.addMineBayRecipe(new RecipeData().setInput(item).setCurrency(currency).setPrice(price), 0);
    }

    public void registerOvenRecipe(ItemStack input, ItemStack output) {
        RecipeRegistry.addOvenRecipe(new RecipeData().setInput(input).setOutput(output), 0);
    }

    public void registerFreezerRecipe(ItemStack input, ItemStack output) {
        RecipeRegistry.addFreezerRecipe(new RecipeData().setInput(input).setOutput(output), 0);
    }

    public void registerPrinterRecipe(ItemStack input) {
        RecipeRegistry.addPrinterRecipe(new RecipeData().setInput(input), 0);
    }

    public void registerChoppingBoardRecipe(ItemStack input, ItemStack output) {
        RecipeRegistry.addChoppingBoardRecipe(new RecipeData().setInput(input).setOutput(output), 0);
    }

    public void registerToasterRecipe(ItemStack input, ItemStack output) {
        RecipeRegistry.addToasterRecipe(new RecipeData().setInput(input).setOutput(output), 0);
    }

    public void registerMicrowaveRecipe(ItemStack input, ItemStack output) {
        RecipeRegistry.addMicrowaveRecipe(new RecipeData().setInput(input).setOutput(output), 0);
    }

    public void registerWashingMachineRecipe(ItemStack input) {
        RecipeRegistry.addWashingMachineRecipe(new RecipeData().setInput(input), 0);
    }

    public void registerDishwasherRecipe(ItemStack input) {
        RecipeRegistry.addDishwasherRecipe(new RecipeData().setInput(input), 0);
    }

    public void registerBlenderRecipe(String name, int heal, ItemStack[] ingredients, int[] rgb) {
        RecipeData data = new RecipeData();
        data.setName(name);
        data.setHeal(heal);
        for (ItemStack item : ingredients) {
            data.addIngredient(item);
        }
        data.setColour(rgb[0], rgb[1], rgb[2]);
        RecipeRegistry.addBlenderRecipe(data, 0);
    }

    public static void registerPrinterRecipe(Parser parser) {
        String input_item = parser.getValue("input-item", null);
        String input_metadata = parser.getValue("input-metadata", "0");
        if (input_item != null) {
            Item input = (Item)Item.field_150901_e.func_82594_a(input_item);
            if (input != null) {
                int i_metadata = 0;
                try {
                    i_metadata = Integer.parseInt(input_metadata);
                }
                catch (NumberFormatException e) {
                    System.err.println("RecipeAPI Error: Could not parse the value '" + input_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                }
                RecipeRegistry.getInstance().registerPrinterRecipe(new ItemStack(input, 1, i_metadata));
            } else {
                System.err.println("RecipeAPI Error: The input-item '" + input_item + "' does not exist. Please fix this in the config (cfm.cfg).");
            }
        } else {
            System.err.println("RecipeAPI Error: An input-item is required for the printer. Please fix this in the config (cfm.cfg).");
        }
    }

    public static void registerOvenRecipe(Parser parser) {
        String input_item = parser.getValue("input-item", null);
        String input_metadata = parser.getValue("input-metadata", "0");
        String output_item = parser.getValue("output-item", null);
        String output_metadata = parser.getValue("output-metadata", "0");
        String output_amount = parser.getValue("output-amount", "1");
        if (input_item != null) {
            if (output_item != null) {
                Item input = (Item)Item.field_150901_e.func_82594_a(input_item);
                Item output = (Item)Item.field_150901_e.func_82594_a(output_item);
                if (input != null) {
                    if (output != null) {
                        int i_metadata = 0;
                        try {
                            i_metadata = Integer.parseInt(input_metadata);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + input_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        int o_amount = 1;
                        try {
                            o_amount = Integer.parseInt(output_amount);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + output_amount + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        int o_metadata = 0;
                        try {
                            o_metadata = Integer.parseInt(output_metadata);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + output_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        RecipeRegistry.getInstance().registerOvenRecipe(new ItemStack(input, 1, i_metadata), new ItemStack(output, o_amount, o_metadata));
                    } else {
                        System.err.println("RecipeAPI Error: The output-item '" + output_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                    }
                } else {
                    System.err.println("RecipeAPI Error: The input-item '" + input_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                }
            } else {
                System.err.println("RecipeAPI Error: An output-item is required for the oven. Please fix this in the config (cfm.cfg).");
            }
        } else {
            System.err.println("RecipeAPI Error: An input-item is required for the oven. Please fix this in the config (cfm.cfg).");
        }
    }

    public static void registerFreezerRecipe(Parser parser) {
        String input_item = parser.getValue("input-item", null);
        String input_metadata = parser.getValue("input-metadata", "0");
        String output_item = parser.getValue("output-item", null);
        String output_metadata = parser.getValue("output-metadata", "0");
        String output_amount = parser.getValue("output-amount", "1");
        if (input_item != null) {
            if (output_item != null) {
                Item input = (Item)Item.field_150901_e.func_82594_a(input_item);
                Item output = (Item)Item.field_150901_e.func_82594_a(output_item);
                if (input != null) {
                    if (output != null) {
                        int i_metadata = 0;
                        try {
                            i_metadata = Integer.parseInt(input_metadata);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + input_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        int o_amount = 1;
                        try {
                            o_amount = Integer.parseInt(output_amount);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + output_amount + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        int o_metadata = 0;
                        try {
                            o_metadata = Integer.parseInt(output_metadata);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + output_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        RecipeRegistry.getInstance().registerFreezerRecipe(new ItemStack(input, 1, i_metadata), new ItemStack(output, o_amount, o_metadata));
                    } else {
                        System.err.println("RecipeAPI Error: The output-item '" + output_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                    }
                } else {
                    System.err.println("RecipeAPI Error: The input-item '" + input_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                }
            } else {
                System.err.println("RecipeAPI Error: An output-item is required for the freezer. Please fix this in the config (cfm.cfg).");
            }
        } else {
            System.err.println("RecipeAPI Error: An input-item is required for the freezer. Please fix this in the config (cfm.cfg).");
        }
    }

    public static void registerMineBayRecipe(Parser parser) {
        String input_item = parser.getValue("input-item", null);
        String input_metadata = parser.getValue("input-metadata", "0");
        String input_amount = parser.getValue("input-amount", "1");
        String payment_item = parser.getValue("payment-item", "minecraft:emerald");
        String payment_item_metadata = parser.getValue("payment-item-metadata", "0");
        String price = parser.getValue("payment-price", "1");
        if (input_item != null) {
            Item input = (Item)Item.field_150901_e.func_82594_a(input_item);
            Item payment = (Item)Item.field_150901_e.func_82594_a(payment_item);
            if (input != null) {
                if (payment != null) {
                    int i_metadata = 0;
                    try {
                        i_metadata = Integer.parseInt(input_metadata);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("RecipeAPI Error: Could not parse the value '" + input_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                    }
                    int i_amount = 0;
                    try {
                        i_amount = Integer.parseInt(input_amount);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("RecipeAPI Error: Could not parse the value '" + input_amount + "' to an integer. Please fix this in the config (cfm.cfg).");
                    }
                    int p_metadata = 0;
                    try {
                        p_metadata = Integer.parseInt(payment_item_metadata);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("RecipeAPI Error: Could not parse the value '" + p_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                    }
                    int p_price = 1;
                    try {
                        p_price = Integer.parseInt(price);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("RecipeAPI Error: Could not parse the value '" + p_price + "' to an integer. Please fix this in the config (cfm.cfg).");
                    }
                    RecipeRegistry.getInstance().registerMineBayItem(new ItemStack(input, i_amount, i_metadata), new ItemStack(payment, 1, p_metadata), p_price);
                } else {
                    System.err.println("RecipeAPI Error: The payment-item '" + payment_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                }
            } else {
                System.err.println("RecipeAPI Error: The input-item '" + input_item + "' does not exist. Please fix this in the config (cfm.cfg).");
            }
        } else {
            System.err.println("RecipeAPI Error: An input-item is required for minebay. Please fix this in the config (cfm.cfg).");
        }
    }

    public static void registerToasterRecipe(Parser parser) {
        String input_item = parser.getValue("input-item", null);
        String input_metadata = parser.getValue("input-metadata", "0");
        String output_item = parser.getValue("output-item", null);
        String output_metadata = parser.getValue("output-metadata", "0");
        String output_amount = parser.getValue("output-amount", "1");
        if (input_item != null) {
            if (output_item != null) {
                Item input = (Item)Item.field_150901_e.func_82594_a(input_item);
                Item output = (Item)Item.field_150901_e.func_82594_a(output_item);
                if (input != null) {
                    if (output != null) {
                        int i_metadata = 0;
                        try {
                            i_metadata = Integer.parseInt(input_metadata);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + input_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        int o_amount = 1;
                        try {
                            o_amount = Integer.parseInt(output_amount);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + output_amount + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        int o_metadata = 0;
                        try {
                            o_metadata = Integer.parseInt(output_metadata);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + output_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        RecipeRegistry.getInstance().registerToasterRecipe(new ItemStack(input, 1, i_metadata), new ItemStack(output, o_amount, o_metadata));
                    } else {
                        System.err.println("RecipeAPI Error: The output-item '" + output_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                    }
                } else {
                    System.err.println("RecipeAPI Error: The input-item '" + input_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                }
            } else {
                System.err.println("RecipeAPI Error: An output-item is required for the toaster. Please fix this in the config (cfm.cfg).");
            }
        } else {
            System.err.println("RecipeAPI Error: An input-item is required for the toaster. Please fix this in the config (cfm.cfg).");
        }
    }

    public static void registerChoppingBoardRecipe(Parser parser) {
        String input_item = parser.getValue("input-item", null);
        String input_metadata = parser.getValue("input-metadata", "0");
        String output_item = parser.getValue("output-item", null);
        String output_metadata = parser.getValue("output-metadata", "0");
        String output_amount = parser.getValue("output-amount", "1");
        if (input_item != null) {
            if (output_item != null) {
                Item input = (Item)Item.field_150901_e.func_82594_a(input_item);
                Item output = (Item)Item.field_150901_e.func_82594_a(output_item);
                if (input != null) {
                    if (output != null) {
                        int i_metadata = 0;
                        try {
                            i_metadata = Integer.parseInt(input_metadata);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + input_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        int o_amount = 1;
                        try {
                            o_amount = Integer.parseInt(output_amount);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + output_amount + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        int o_metadata = 0;
                        try {
                            o_metadata = Integer.parseInt(output_metadata);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + output_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        RecipeRegistry.getInstance().registerChoppingBoardRecipe(new ItemStack(input, 1, i_metadata), new ItemStack(output, o_amount, o_metadata));
                    } else {
                        System.err.println("RecipeAPI Error: The output-item '" + output_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                    }
                } else {
                    System.err.println("RecipeAPI Error: The input-item '" + input_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                }
            } else {
                System.err.println("RecipeAPI Error: An output-item is required for the chopping board. Please fix this in the config (cfm.cfg).");
            }
        } else {
            System.err.println("RecipeAPI Error: An input-item is required for the chopping board. Please fix this in the config (cfm.cfg).");
        }
    }

    public static void registerBlenderRecipe(Parser parser) {
        String name = parser.getValue("name", null);
        String heal_amount = parser.getValue("heal", null);
        String ingredients = parser.getValue("ingredients", null);
        String colour = parser.getValue("colour", null);
        if (name != null && heal_amount != null && ingredients != null && colour != null) {
            int h_amount = 0;
            try {
                h_amount = Integer.parseInt(heal_amount);
            }
            catch (NumberFormatException e) {
                System.err.println("RecipeAPI Error: Could not parse the value '" + heal_amount + "' to an integer. Please fix this in the config (cfm.cfg).");
            }
            ItemStack[] in = RecipeRegistry.parseIngredients(ingredients);
            int[] rgb = RecipeRegistry.parseColour(colour);
            RecipeRegistry.getInstance().registerBlenderRecipe(name, h_amount, in, rgb);
        }
    }

    public static ItemStack[] parseIngredients(String ingredients) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        String[] ingredientData = ingredients.split("/");
        if (ingredientData.length == 0) {
            return null;
        }
        int length = ingredientData.length > 4 ? 4 : ingredientData.length;
        for (int i = 0; i < length; ++i) {
            String[] itemData = ingredientData[i].split(":");
            String itemName = itemData[0] + ":" + itemData[1];
            String itemAmount = "1";
            String itemMetadata = "0";
            if (itemData.length > 2) {
                itemAmount = itemData[2];
                if (itemData.length > 3) {
                    itemMetadata = itemData[3];
                }
            }
            Item item = (Item)Item.field_150901_e.func_82594_a(itemName);
            int i_amount = 1;
            try {
                i_amount = Integer.parseInt(itemAmount);
            }
            catch (NumberFormatException e) {
                System.err.println("RecipeAPI Error: Could not parse the value '" + itemAmount + "' to an integer. Please fix this in the config (cfm.cfg).");
            }
            int i_metadata = 0;
            try {
                i_metadata = Integer.parseInt(itemMetadata);
            }
            catch (NumberFormatException e) {
                System.err.println("RecipeAPI Error: Could not parse the value '" + itemMetadata + "' to an integer. Please fix this in the config (cfm.cfg).");
            }
            list.add(new ItemStack(item, i_amount, i_metadata));
        }
        return list.toArray(new ItemStack[0]);
    }

    public static int[] parseColour(String colour) {
        String[] rgb = colour.split(":");
        if (rgb.length == 3) {
            String r = rgb[0];
            String g = rgb[1];
            String b = rgb[2];
            int red = 0;
            try {
                red = Integer.parseInt(r);
            }
            catch (NumberFormatException e) {
                System.err.println("RecipeAPI Error: Could not parse the value '" + r + "' to an integer. Please fix this in the config (cfm.cfg).");
            }
            int green = 0;
            try {
                green = Integer.parseInt(g);
            }
            catch (NumberFormatException e) {
                System.err.println("RecipeAPI Error: Could not parse the value '" + g + "' to an integer. Please fix this in the config (cfm.cfg).");
            }
            int blue = 0;
            try {
                blue = Integer.parseInt(b);
            }
            catch (NumberFormatException e) {
                System.err.println("RecipeAPI Error: Could not parse the value '" + b + "' to an integer. Please fix this in the config (cfm.cfg).");
            }
            return new int[]{red, blue, green};
        }
        System.err.println("RecipeAPI Error: The colour variable doesn't have all three rgb values set, it needs to be colour=r-g-b. Please fix this in the config (cfm.cfg).");
        return null;
    }

    public static void registerMicrowaveRecipe(Parser parser) {
        String input_item = parser.getValue("input-item", null);
        String input_metadata = parser.getValue("input-metadata", "0");
        String output_item = parser.getValue("output-item", null);
        String output_metadata = parser.getValue("output-metadata", "0");
        if (input_item != null) {
            if (output_item != null) {
                Item input = (Item)Item.field_150901_e.func_82594_a(input_item);
                Item output = (Item)Item.field_150901_e.func_82594_a(output_item);
                if (input != null) {
                    if (output != null) {
                        int i_metadata = 0;
                        try {
                            i_metadata = Integer.parseInt(input_metadata);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + input_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        int o_metadata = 0;
                        try {
                            o_metadata = Integer.parseInt(output_metadata);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("RecipeAPI Error: Could not parse the value '" + output_metadata + "' to an integer. Please fix this in the config (cfm.cfg).");
                        }
                        RecipeRegistry.getInstance().registerMicrowaveRecipe(new ItemStack(input, 1, i_metadata), new ItemStack(output, 1, o_metadata));
                    } else {
                        System.err.println("RecipeAPI Error: The output-item '" + output_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                    }
                } else {
                    System.err.println("RecipeAPI Error: The input-item '" + input_item + "' does not exist. Please fix this in the config (cfm.cfg).");
                }
            } else {
                System.err.println("RecipeAPI Error: An output-item is required for the microwave. Please fix this in the config (cfm.cfg).");
            }
        } else {
            System.err.println("RecipeAPI Error: An input-item is required for the microwave. Please fix this in the config (cfm.cfg).");
        }
    }

    public static void registerWashingMachineRecipe(Parser parser) {
        String input_item = parser.getValue("input-item", null);
        if (input_item != null) {
            Item input = (Item)Item.field_150901_e.func_82594_a(input_item);
            if (input != null) {
                RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack(input));
            } else {
                System.err.println("RecipeAPI Error: The input-item '" + input_item + "' does not exist. Please fix this in the config (cfm.cfg).");
            }
        } else {
            System.err.println("RecipeAPI Error: An input-item is required for the washing machine. Please fix this in the config (cfm.cfg).");
        }
    }

    public static void registerDishwasherRecipe(Parser parser) {
        String input_item = parser.getValue("input-item", null);
        if (input_item != null) {
            Item input = (Item)Item.field_150901_e.func_82594_a(input_item);
            if (input != null) {
                RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(input));
            } else {
                System.err.println("RecipeAPI Error: The input-item '" + input_item + "' does not exist. Please fix this in the config (cfm.cfg).");
            }
        } else {
            System.err.println("RecipeAPI Error: An input-item is required for the dishwasher. Please fix this in the config (cfm.cfg).");
        }
    }

    public static void registerConfigRecipes() {
        Parser parser = Parser.getInstance();
        for (String line : ConfigurationHandler.items) {
            parser.parseLine(line);
            String type = parser.getValue("type", null);
            if (type == null) continue;
            if (type.equalsIgnoreCase("printer")) {
                RecipeRegistry.registerPrinterRecipe(parser);
                continue;
            }
            if (type.equalsIgnoreCase("oven")) {
                RecipeRegistry.registerOvenRecipe(parser);
                continue;
            }
            if (type.equalsIgnoreCase("freezer")) {
                RecipeRegistry.registerFreezerRecipe(parser);
                continue;
            }
            if (type.equalsIgnoreCase("minebay")) {
                RecipeRegistry.registerMineBayRecipe(parser);
                continue;
            }
            if (type.equalsIgnoreCase("choppingboard")) {
                RecipeRegistry.registerChoppingBoardRecipe(parser);
                continue;
            }
            if (type.equalsIgnoreCase("toaster")) {
                RecipeRegistry.registerToasterRecipe(parser);
                continue;
            }
            if (type.equalsIgnoreCase("microwave")) {
                RecipeRegistry.registerMicrowaveRecipe(parser);
                continue;
            }
            if (type.equalsIgnoreCase("blender")) {
                RecipeRegistry.registerBlenderRecipe(parser);
                continue;
            }
            if (type.equalsIgnoreCase("washingmachine")) {
                RecipeRegistry.registerWashingMachineRecipe(parser);
                continue;
            }
            if (type.equalsIgnoreCase("dishwasher")) {
                RecipeRegistry.registerDishwasherRecipe(parser);
                continue;
            }
            System.err.println("RecipeAPI Error: Unknown type '" + type + "'. Please fix this in the config (cfm.cfg).");
        }
    }

    public static void registerDefaultRecipes() {
        NBTTagCompound master;
        ItemStack stack;
        if (ConfigurationHandler.printer_1) {
            RecipeRegistry.getInstance().registerPrinterRecipe(new ItemStack((Item)Items.field_151134_bR));
        }
        if (ConfigurationHandler.printer_2) {
            RecipeRegistry.getInstance().registerPrinterRecipe(new ItemStack(Items.field_151164_bB));
        }
        if (ConfigurationHandler.oven_1) {
            RecipeRegistry.getInstance().registerOvenRecipe(new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151083_be));
        }
        if (ConfigurationHandler.oven_2) {
            RecipeRegistry.getInstance().registerOvenRecipe(new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151157_am));
        }
        if (ConfigurationHandler.oven_3) {
            RecipeRegistry.getInstance().registerOvenRecipe(new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151168_bH));
        }
        if (ConfigurationHandler.oven_4) {
            RecipeRegistry.getInstance().registerOvenRecipe(new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151077_bg));
        }
        if (ConfigurationHandler.oven_5) {
            RecipeRegistry.getInstance().registerOvenRecipe(new ItemStack(Items.field_151115_aP, 1, 0), new ItemStack(Items.field_151101_aQ, 1, 0));
        }
        if (ConfigurationHandler.oven_6) {
            RecipeRegistry.getInstance().registerOvenRecipe(new ItemStack(Items.field_151115_aP, 1, 1), new ItemStack(Items.field_151101_aQ, 1, 1));
        }
        if (ConfigurationHandler.oven_7) {
            RecipeRegistry.getInstance().registerOvenRecipe(new ItemStack(MrCrayfishFurnitureMod.itemFlesh), new ItemStack(MrCrayfishFurnitureMod.itemCookedFlesh));
        }
        if (ConfigurationHandler.frez_1) {
            RecipeRegistry.getInstance().registerFreezerRecipe(new ItemStack(Items.field_151131_as), new ItemStack(Blocks.field_150432_aD));
        }
        if (ConfigurationHandler.frez_2) {
            RecipeRegistry.getInstance().registerFreezerRecipe(new ItemStack(Blocks.field_150432_aD), new ItemStack(Blocks.field_150403_cj));
        }
        if (ConfigurationHandler.frez_3) {
            RecipeRegistry.getInstance().registerFreezerRecipe(new ItemStack(Items.field_151129_at), new ItemStack(Blocks.field_150343_Z));
        }
        if (ConfigurationHandler.frez_4) {
            RecipeRegistry.getInstance().registerFreezerRecipe(new ItemStack(Items.field_151123_aH), new ItemStack(Items.field_151126_ay));
        }
        if (ConfigurationHandler.frez_5) {
            RecipeRegistry.getInstance().registerFreezerRecipe(new ItemStack(Items.field_151170_bI), new ItemStack(Items.field_151174_bG));
        }
        if (ConfigurationHandler.frez_6) {
            RecipeRegistry.getInstance().registerFreezerRecipe(new ItemStack(Items.field_151078_bh), new ItemStack(MrCrayfishFurnitureMod.itemFlesh));
        }
        if (ConfigurationHandler.mine_1) {
            RecipeRegistry.getInstance().registerMineBayItem(new ItemStack(Blocks.field_150405_ch, 16), new ItemStack(Items.field_151166_bC), 1);
        }
        if (ConfigurationHandler.mine_2) {
            RecipeRegistry.getInstance().registerMineBayItem(new ItemStack(Items.field_151144_bL), new ItemStack(Items.field_151166_bC), 8);
        }
        if (ConfigurationHandler.mine_3) {
            RecipeRegistry.getInstance().registerMineBayItem(new ItemStack(Items.field_151141_av), new ItemStack(Items.field_151166_bC), 4);
        }
        if (ConfigurationHandler.mine_4) {
            RecipeRegistry.getInstance().registerMineBayItem(new ItemStack(Items.field_151063_bx, 1, 100), new ItemStack(Items.field_151166_bC), 8);
        }
        if (ConfigurationHandler.mine_5) {
            RecipeRegistry.getInstance().registerMineBayItem(new ItemStack(Items.field_151125_bZ), new ItemStack(Items.field_151045_i), 8);
        }
        if (ConfigurationHandler.mine_6) {
            RecipeRegistry.getInstance().registerMineBayItem(new ItemStack(Items.field_151062_by), new ItemStack(Items.field_151042_j), 1);
        }
        if (ConfigurationHandler.mine_7) {
            stack = new ItemStack(Items.field_151152_bP, 4);
            master = new NBTTagCompound();
            NBTTagCompound firework = new NBTTagCompound();
            firework.func_74774_a("Flight", (byte)1);
            NBTTagList list = new NBTTagList();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Trail", (byte)1);
            data.func_74774_a("Type", (byte)0);
            data.func_74783_a("Colors", new int[]{11743532, 3887386});
            list.func_74742_a((NBTBase)data);
            firework.func_74782_a("Explosions", (NBTBase)list);
            master.func_74782_a("Fireworks", (NBTBase)firework);
            stack.func_77982_d(master);
            stack.func_151001_c(EnumChatFormatting.RED + "Christmas" + EnumChatFormatting.GREEN + " Firework");
            RecipeRegistry.getInstance().registerMineBayItem(stack, new ItemStack(Items.field_151042_j), 1);
        }
        if (ConfigurationHandler.mine_8) {
            stack = new ItemStack((Item)Items.field_151134_bR);
            master = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("id", (short)33);
            data.func_74777_a("lvl", (short)1);
            list.func_74742_a((NBTBase)data);
            master.func_74782_a("StoredEnchantments", (NBTBase)list);
            stack.func_77982_d(master);
            RecipeRegistry.getInstance().registerMineBayItem(stack, new ItemStack(Items.field_151166_bC), 8);
        }
        if (ConfigurationHandler.mine_9) {
            RecipeRegistry.getInstance().registerMineBayItem(new ItemStack((Item)Items.field_151068_bn, 2, 8270), new ItemStack(Items.field_151166_bC), 1);
        }
        if (ConfigurationHandler.mine_10) {
            System.out.println(GameRegistry.findUniqueIdentifierFor((Item)MrCrayfishFurnitureMod.itemRecipeBook));
            RecipeRegistry.getInstance().registerMineBayItem(new ItemStack(MrCrayfishFurnitureMod.itemRecipeBook), new ItemStack(Items.field_151166_bC), 1);
        }
        if (ConfigurationHandler.blen_1) {
            RecipeRegistry.getInstance().registerBlenderRecipe("Fruit Crush", 4, new ItemStack[]{new ItemStack(Items.field_151034_e, 2), new ItemStack(Items.field_151127_ba, 4)}, new int[]{255, 58, 37});
        }
        if (ConfigurationHandler.blen_2) {
            RecipeRegistry.getInstance().registerBlenderRecipe("Veggie Juice", 6, new ItemStack[]{new ItemStack(Items.field_151172_bF, 4), new ItemStack(Items.field_151174_bG, 1), new ItemStack(Items.field_151158_bO, 2)}, new int[]{247, 139, 122});
        }
        if (ConfigurationHandler.blen_3) {
            RecipeRegistry.getInstance().registerBlenderRecipe("Cookies and Cream Milkshake", 4, new ItemStack[]{new ItemStack(Items.field_151106_aX, 2), new ItemStack(Items.field_151117_aB)}, new int[]{255, 214, 164});
        }
        if (ConfigurationHandler.blen_4) {
            RecipeRegistry.getInstance().registerBlenderRecipe("Energy Drink", 8, new ItemStack[]{new ItemStack(Items.field_151137_ax, 8), new ItemStack(Items.field_151059_bz, 1), new ItemStack(Items.field_151102_aT, 16)}, new int[]{92, 23, 8});
        }
        if (ConfigurationHandler.chop_1) {
            RecipeRegistry.getInstance().registerChoppingBoardRecipe(new ItemStack(Items.field_151025_P), new ItemStack(MrCrayfishFurnitureMod.itemBreadSlice, 6));
        }
        if (ConfigurationHandler.dish_1) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack((Item)Items.field_151031_f));
        }
        if (ConfigurationHandler.dish_2) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151039_o));
        }
        if (ConfigurationHandler.dish_3) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151053_p));
        }
        if (ConfigurationHandler.dish_4) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151038_n));
        }
        if (ConfigurationHandler.dish_5) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151017_I));
        }
        if (ConfigurationHandler.dish_6) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151041_m));
        }
        if (ConfigurationHandler.dish_7) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151050_s));
        }
        if (ConfigurationHandler.dish_8) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151049_t));
        }
        if (ConfigurationHandler.dish_9) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151051_r));
        }
        if (ConfigurationHandler.dish_10) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151018_J));
        }
        if (ConfigurationHandler.dish_11) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151052_q));
        }
        if (ConfigurationHandler.dish_12) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151005_D));
        }
        if (ConfigurationHandler.dish_13) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151006_E));
        }
        if (ConfigurationHandler.dish_14) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151011_C));
        }
        if (ConfigurationHandler.dish_15) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151013_M));
        }
        if (ConfigurationHandler.dish_16) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151010_B));
        }
        if (ConfigurationHandler.dish_17) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151046_w));
        }
        if (ConfigurationHandler.dish_18) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151056_x));
        }
        if (ConfigurationHandler.dish_19) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151047_v));
        }
        if (ConfigurationHandler.dish_20) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151012_L));
        }
        if (ConfigurationHandler.dish_21) {
            RecipeRegistry.getInstance().registerDishwasherRecipe(new ItemStack(Items.field_151048_u));
        }
        if (ConfigurationHandler.micr_1) {
            RecipeRegistry.getInstance().registerMicrowaveRecipe(new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151083_be));
        }
        if (ConfigurationHandler.micr_2) {
            RecipeRegistry.getInstance().registerMicrowaveRecipe(new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151168_bH));
        }
        if (ConfigurationHandler.toast_1) {
            RecipeRegistry.getInstance().registerToasterRecipe(new ItemStack(MrCrayfishFurnitureMod.itemBreadSlice), new ItemStack(MrCrayfishFurnitureMod.itemToast));
        }
        if (ConfigurationHandler.wash_1) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151024_Q));
        }
        if (ConfigurationHandler.wash_2) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151027_R));
        }
        if (ConfigurationHandler.wash_3) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151026_S));
        }
        if (ConfigurationHandler.wash_4) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151021_T));
        }
        if (ConfigurationHandler.wash_5) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151020_U));
        }
        if (ConfigurationHandler.wash_6) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151023_V));
        }
        if (ConfigurationHandler.wash_7) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151022_W));
        }
        if (ConfigurationHandler.wash_8) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151029_X));
        }
        if (ConfigurationHandler.wash_9) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151028_Y));
        }
        if (ConfigurationHandler.wash_10) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151030_Z));
        }
        if (ConfigurationHandler.wash_11) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151165_aa));
        }
        if (ConfigurationHandler.wash_12) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151167_ab));
        }
        if (ConfigurationHandler.wash_13) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151169_ag));
        }
        if (ConfigurationHandler.wash_14) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151171_ah));
        }
        if (ConfigurationHandler.wash_15) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151149_ai));
        }
        if (ConfigurationHandler.wash_16) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151151_aj));
        }
        if (ConfigurationHandler.wash_17) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151161_ac));
        }
        if (ConfigurationHandler.wash_18) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151163_ad));
        }
        if (ConfigurationHandler.wash_19) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151173_ae));
        }
        if (ConfigurationHandler.wash_20) {
            RecipeRegistry.getInstance().registerWashingMachineRecipe(new ItemStack((Item)Items.field_151175_af));
        }
    }
}

