/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.statues;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import info.jbcs.minecraft.statues.BlockShowcase;
import info.jbcs.minecraft.statues.BlockStatue;
import info.jbcs.minecraft.statues.ContainerShowcase;
import info.jbcs.minecraft.statues.ContainerStatue;
import info.jbcs.minecraft.statues.GuiSculpt;
import info.jbcs.minecraft.statues.GuiShowcase;
import info.jbcs.minecraft.statues.GuiStatue;
import info.jbcs.minecraft.statues.ItemMarteau;
import info.jbcs.minecraft.statues.ItemPalette;
import info.jbcs.minecraft.statues.ItemShowcase;
import info.jbcs.minecraft.statues.Packets;
import info.jbcs.minecraft.statues.Proxy;
import info.jbcs.minecraft.statues.TileEntityShowcase;
import info.jbcs.minecraft.statues.TileEntityStatue;
import info.jbcs.minecraft.utilities.DummyContainer;
import info.jbcs.minecraft.utilities.GuiHandler;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import pl.asie.lib.network.MessageHandlerBase;
import pl.asie.lib.network.PacketHandler;

@Mod(modid="statues", name="Statues", version="2.1.4", dependencies="required-after:asielib")
public class Statues {
    static Configuration config;
    @Mod.Instance(value="Statues")
    public static Statues instance;
    @SidedProxy(clientSide="info.jbcs.minecraft.statues.ProxyClient", serverSide="info.jbcs.minecraft.statues.Proxy")
    public static Proxy proxy;
    public static PacketHandler packet;
    public static Block statue;
    public static Block showcase;
    public static Item hammer;
    public static Item itemPalette;
    public static Item itemStatue;
    public static Item itemShowcase;
    public static IIcon slotHand;
    public static GuiHandler guiShowcase;
    public static GuiHandler guiStatue;
    public static GuiHandler guiSculpt;
    public static String skinServerLocation;
    public static boolean debugImages;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        config = new Configuration(configFile);
        config.load();
        statue = new BlockStatue(Material.field_151576_e).func_149711_c(1.0f).func_149752_b(1.0f).func_149663_c("statues.statue").func_149672_a(Block.field_149769_e);
        showcase = new BlockShowcase(Material.field_151575_d).func_149711_c(1.0f).func_149752_b(1.0f).func_149663_c("statues.showcase").func_149672_a(Block.field_149766_f);
        hammer = new ItemMarteau().func_111206_d("statues:marteau").func_77655_b("statues.marteau");
        itemShowcase = new ItemShowcase(showcase).func_111206_d("statues:itemshowcase").func_77655_b("statues.showcase");
        itemPalette = new ItemPalette().func_111206_d("statues:palette").func_77655_b("statues.palette");
        GameRegistry.registerBlock((Block)statue, (String)"statues.statue");
        GameRegistry.registerBlock((Block)showcase, (String)"statues.showcase");
        GameRegistry.registerItem((Item)hammer, (String)"statues.marteau");
        GameRegistry.registerItem((Item)itemShowcase, (String)"statues.item.showcase");
        GameRegistry.registerItem((Item)itemPalette, (String)"statues.item.palette");
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        skinServerLocation = config.get("general", "skin server location", "http://skins.minecraft.net/MinecraftSkins/", "Download skins from this path.").getString();
        debugImages = config.get("general", "debug skins", false, "Save generated skins to files.").getBoolean(false);
        packet = new PacketHandler("statues", (MessageHandlerBase)new Packets(), (MessageHandlerBase)new Packets());
        GameRegistry.registerTileEntity(TileEntityStatue.class, (String)"TileEntityStatue");
        GameRegistry.registerTileEntity(TileEntityShowcase.class, (String)"TileEntityShowcase");
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(hammer, 1), (Object[])new Object[]{" I ", " SI", "S  ", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('I'), Items.field_151042_j});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(itemShowcase, 1), (Object[])new Object[]{"GGG", "W W", "S S", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('W'), Blocks.field_150344_f, Character.valueOf('G'), Blocks.field_150410_aZ});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(itemPalette, 1), (Object[])new Object[]{"GB", "RW", Character.valueOf('W'), Blocks.field_150344_f, Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('G'), new ItemStack(Items.field_151100_aR, 1, 2), Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 4)});
        guiShowcase = new GuiHandler("showcase"){

            @Override
            public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityShowcase)) {
                    return null;
                }
                TileEntityShowcase e = (TileEntityShowcase)tileEntity;
                return new ContainerShowcase(player.field_71071_by, e);
            }

            @Override
            public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityShowcase)) {
                    return null;
                }
                TileEntityShowcase e = (TileEntityShowcase)tileEntity;
                return new GuiShowcase(player.field_71071_by, e, world, x, y, z);
            }
        };
        guiStatue = new GuiHandler("statue"){

            @Override
            public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityStatue)) {
                    return null;
                }
                TileEntityStatue e = (TileEntityStatue)tileEntity;
                return new ContainerStatue(player.field_71071_by, e);
            }

            @Override
            public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityStatue)) {
                    return null;
                }
                TileEntityStatue e = (TileEntityStatue)tileEntity;
                return new GuiStatue(player.field_71071_by, e, world, x, y, z);
            }
        };
        guiSculpt = new GuiHandler("sculpt"){

            @Override
            public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                return new DummyContainer();
            }

            @Override
            public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                int face = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                return new GuiSculpt(world, x, y, z, player, face);
            }
        };
        GuiHandler.register(this);
        proxy.init();
        config.save();
    }

    public static boolean canSculpt(Block block, World world, int x, int y, int z) {
        if (block == null) {
            return false;
        }
        if (block.equals(Blocks.field_150357_h)) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151594_q) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151581_o) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151587_i) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151586_h) {
            return false;
        }
        return world.func_147438_o(x, y, z) == null;
    }
}

