/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.tile.TileEntityScreen;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockScreen
extends BlockAdvanced
implements ItemBlockDesc.IBlockShiftDesc,
IPartialSealableBlock {
    private IIcon iconFront;
    private IIcon iconSide;

    protected BlockScreen(String assetName) {
        super(Material.field_151594_q);
        this.func_149711_c(0.1f);
        this.func_149672_a(Block.field_149778_k);
        this.func_149658_d("glass");
        this.func_149663_c(assetName);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection direction) {
        return direction.ordinal() != world.func_72805_g(x, y, z);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return GalacticraftCore.proxy.getBlockRender((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconFront = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "screenFront");
        this.iconSide = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "screenSide");
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == (metadata & 7)) {
            return this.iconSide;
        }
        return this.iconFront;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        boolean metadata = false;
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 4;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 5;
            }
        }
        world.func_72921_c(x, y, z, change, 3);
    }

    @Override
    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.func_72805_g(x, y, z);
        int facing = metadata & 7;
        int change = 0;
        switch (facing) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 3;
                break;
            }
            case 2: {
                change = 5;
                break;
            }
            case 3: {
                change = 4;
                break;
            }
            case 4: {
                change = 2;
                break;
            }
            case 5: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, change += 8 & metadata, 2);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityScreen) {
            ((TileEntityScreen)tile).breakScreen(facing);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityScreen();
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityScreen) {
            ((TileEntityScreen)tile).changeChannel();
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityScreen) {
            ((TileEntityScreen)tile).refreshConnections(true);
        }
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    @Override
    public boolean isSealed(World world, int x, int y, int z, ForgeDirection direction) {
        return true;
    }

    public MovingObjectPosition func_149731_a(World par1World, int x, int y, int z, Vec3 par5Vec3, Vec3 par6Vec3) {
        int metadata = par1World.func_72805_g(x, y, z) & 7;
        float boundsFront = 0.094f;
        float boundsBack = 1.0f - boundsFront;
        switch (metadata) {
            case 0: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, boundsBack, 1.0f);
                break;
            }
            case 1: {
                this.func_149676_a(0.0f, boundsFront, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, boundsBack);
                break;
            }
            case 3: {
                this.func_149676_a(0.0f, 0.0f, boundsFront, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 4: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, boundsBack, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(boundsFront, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        return super.func_149731_a(par1World, x, y, z, par5Vec3, par6Vec3);
    }
}

