/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.network;

import com.github.abrarsyed.secretroomsmod.api.BlockHolder;
import com.github.abrarsyed.secretroomsmod.api.ITileEntityCamo;
import com.github.abrarsyed.secretroomsmod.blocks.TileEntityCamo;
import com.github.abrarsyed.secretroomsmod.network.PacketBase;
import com.github.abrarsyed.secretroomsmod.network.PacketManager;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PacketCamo
extends PacketBase {
    public int x;
    public int y;
    public int z;
    public BlockHolder holder;
    public boolean[] sides = new boolean[6];
    public UUID owner;

    public PacketCamo() {
    }

    public PacketCamo(ITileEntityCamo entity) {
        this.holder = entity.getBlockHolder();
        this.x = entity.getXCoord();
        this.y = entity.getYCoord();
        this.z = entity.getZCoord();
        this.sides = (boolean[])entity.getIsCamo().clone();
        this.owner = entity.getOwner();
        if (this.holder == null) {
            throw new IllegalArgumentException("TileEntity data is NULL!");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        if (world == null) {
            return;
        }
        ITileEntityCamo entity = (ITileEntityCamo)world.func_147438_o(this.x, this.y, this.z);
        if (entity == null || this.holder == null) {
            return;
        }
        entity.setBlockHolder(this.holder);
        entity.setIsCamo(this.sides);
        entity.setOwner(this.owner);
        world.func_147471_g(this.x, this.y, this.z);
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
        if (world == null) {
            return;
        }
        TileEntityCamo entity = (TileEntityCamo)world.func_147438_o(this.x, this.y, this.z);
        if (entity == null || this.holder == null) {
            return;
        }
        entity.setBlockHolder(this.holder);
        entity.setIsCamo(this.sides);
        entity.setOwner(this.owner);
        PacketManager.sendToDimension(this, world.field_73011_w.field_76574_g);
    }

    @Override
    public void encode(ByteArrayDataOutput output) {
        output.writeInt(this.x);
        output.writeInt(this.y);
        output.writeInt(this.z);
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            this.holder.writeToNBT(nbt);
            CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)output);
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int i = 0; i < 6; ++i) {
            output.writeBoolean(this.sides[i]);
        }
        output.writeBoolean(this.owner != null);
        if (this.owner != null) {
            output.writeLong(this.owner.getMostSignificantBits());
            output.writeLong(this.owner.getLeastSignificantBits());
        }
    }

    @Override
    public void decode(ByteArrayDataInput input) {
        this.x = input.readInt();
        this.y = input.readInt();
        this.z = input.readInt();
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_152456_a((DataInput)input, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            this.holder = BlockHolder.buildFromNBT(nbt);
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int i = 0; i < 6; ++i) {
            this.sides[i] = input.readBoolean();
        }
        if (input.readBoolean()) {
            this.owner = new UUID(input.readLong(), input.readLong());
        }
    }
}

