/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.CoFHCore;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.position.BlockPosition;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.entity.SoundWoosh;
import cofh.thermaldynamics.duct.entity.TileTransportDuctBase;
import cofh.thermaldynamics.duct.entity.TileTransportDuctBaseRoute;
import cofh.thermaldynamics.duct.entity.TileTransportDuctCrossover;
import cofh.thermaldynamics.multiblock.Route;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityTransport
extends Entity {
    public static final byte DATAWATCHER_DIRECTIONS = 16;
    public static final byte DATAWATCHER_PROGRESS = 17;
    public static final byte DATAWATCHER_POSX = 18;
    public static final byte DATAWATCHER_POSY = 19;
    public static final byte DATAWATCHER_POSZ = 20;
    public static final byte DATAWATCHER_STEP = 21;
    public static final byte DATAWATCHER_PAUSE = 22;
    public static final int PIPE_LENGTH = 100;
    public static final int PIPE_LENGTH2 = 50;
    public byte progress;
    public byte direction = (byte)7;
    public byte oldDirection;
    public byte step = 0;
    public boolean reRoute = false;
    public byte pause = 0;
    public float originalWidth = 0.0f;
    public float originalHeight = 0.0f;
    public float originalYOffset = 0.0f;
    public float originalEyeHeight = 0.0f;
    public Entity rider = null;
    Route myPath;
    BlockPosition pos;
    boolean initSound;
    public static final float DEFAULT_WIDTH = 0.05f;
    public static final float DEFAULT_HEIGHT = 0.05f;
    public static final float DEFAULT_YOFFSET = 0.0f;

    public boolean func_85032_ar() {
        return true;
    }

    public double func_70033_W() {
        return super.func_70033_W();
    }

    public double func_70042_X() {
        Entity entity = this.field_70153_n;
        if (entity == null) {
            return super.func_70042_X();
        }
        return -entity.func_70033_W();
    }

    public EntityTransport(World world) {
        super(world);
        this.field_70131_O = 0.1f;
        this.field_70130_N = 0.1f;
        this.field_70145_X = true;
        this.field_70178_ae = true;
    }

    public EntityTransport(TileTransportDuctBase tileTransportDuctBase, Route route, byte by, byte by2) {
        this(tileTransportDuctBase.world());
        this.step = by2;
        this.pos = new BlockPosition((TileEntity)tileTransportDuctBase);
        this.myPath = route;
        this.progress = 0;
        this.direction = route.getNextDirection();
        this.oldDirection = by;
        this.setPosition(0.0);
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public void start(Entity entity) {
        this.loadRider(entity);
        this.field_70170_p.func_72838_d((Entity)this);
        entity.func_70078_a((Entity)this);
    }

    public void loadRider(Entity entity) {
        this.rider = entity;
        this.originalWidth = entity.field_70130_N;
        this.originalHeight = entity.field_70131_O;
        this.originalYOffset = entity.field_70129_M;
        if (this.rider instanceof EntityPlayer) {
            this.originalEyeHeight = ((EntityPlayer)this.rider).eyeHeight;
        }
    }

    public boolean func_82150_aj() {
        return true;
    }

    public boolean func_98034_c(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_70071_h_() {
        boolean bl;
        if (!this.field_70170_p.field_72995_K || this.rider != null) {
            if (this.field_70153_n == null || this.field_70153_n.field_70128_L) {
                this.func_70106_y();
                return;
            }
        } else if (this.field_70153_n == null) {
            return;
        }
        if (this.rider == null) {
            if (!(this.field_70153_n instanceof EntityLivingBase)) {
                this.field_70153_n.func_70078_a(null);
                this.func_70106_y();
                return;
            }
            this.loadRider(this.field_70153_n);
        } else {
            this.updateRider(this.rider);
        }
        boolean bl2 = bl = this.pause > 0;
        if (this.field_70170_p.field_72995_K) {
            if (!this.initSound) {
                this.initSound = true;
                SoundHelper.playSound((ISound)this.getSound());
            }
            if (this.field_70180_af.func_75684_a()) {
                this.field_70180_af.func_111144_e();
                this.loadWatcherData();
            }
        }
        if (this.direction == 7 || this.pos == null) {
            return;
        }
        TileEntity tileEntity = this.field_70170_p.func_147438_o(this.pos.x, this.pos.y, this.pos.z);
        if (tileEntity == null || !(tileEntity instanceof TileTransportDuctBase)) {
            if (this.field_70170_p.field_72995_K) {
                this.pos = null;
            } else {
                this.dropPassenger();
            }
            return;
        }
        TileTransportDuctBase tileTransportDuctBase = (TileTransportDuctBase)tileEntity;
        if (this.pause > 0) {
            this.pause = (byte)(this.pause - 1);
            if (!this.field_70170_p.field_72995_K) {
                this.updateWatcherData();
            } else {
                this.setPosition(0.0);
                if (this.field_70153_n == CoFHCore.proxy.getClientPlayer()) {
                    if (this.pause == 0) {
                        CoFHCore.proxy.addIndexedChatMessage(null, -515781222);
                    } else {
                        CoFHCore.proxy.addIndexedChatMessage((IChatComponent)new ChatComponentText("Charging - " + (TileTransportDuctCrossover.CHARGE_TIME - this.pause) + " / " + TileTransportDuctCrossover.CHARGE_TIME), -515781222);
                    }
                }
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_72869_a("portal", (double)this.pos.x + 0.5, (double)this.pos.y + 0.5, (double)this.pos.z + 0.5, MathHelper.RANDOM.nextGaussian() * 0.5, MathHelper.RANDOM.nextGaussian() * 0.5, MathHelper.RANDOM.nextGaussian() * 0.5);
                }
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            tileTransportDuctBase.advanceEntity(this);
            this.updateWatcherData();
        } else {
            if (bl && this.field_70153_n == CoFHCore.proxy.getClientPlayer()) {
                CoFHCore.proxy.addIndexedChatMessage(null, -515781222);
            }
            tileTransportDuctBase.advanceEntityClient(this);
        }
        this.setPosition(0.0);
        if (this.field_70153_n != null && !this.field_70153_n.field_70128_L) {
            this.func_70043_V();
        }
    }

    public void updateRider(Entity entity) {
        entity.field_70130_N = 0.05f;
        entity.field_70131_O = 0.05f;
        entity.field_70129_M = 0.0f;
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).eyeHeight = 0.0f;
        }
        entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public void func_70106_y() {
        if (this.rider != null && !this.rider.field_70128_L) {
            this.rider.field_70131_O = this.originalHeight;
            this.rider.field_70130_N = this.originalWidth;
            this.rider.field_70129_M = this.originalYOffset;
            if (this.rider instanceof EntityPlayer) {
                ((EntityPlayer)this.rider).eyeHeight = this.originalEyeHeight;
            }
            this.rider.func_70107_b(this.rider.field_70165_t, this.rider.field_70163_u, this.rider.field_70161_v);
        }
        super.func_70106_y();
    }

    public boolean trySimpleAdvance() {
        BlockPosition blockPosition = this.pos.copy().step((int)this.direction);
        TileEntity tileEntity = this.field_70170_p.func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
        if (!(tileEntity instanceof TileTransportDuctBase)) {
            this.pos = null;
            return false;
        }
        TileTDBase.NeighborTypes[] neighborTypesArray = ((TileTransportDuctBase)tileEntity).neighborTypes;
        if (neighborTypesArray[this.direction ^ 1] != TileTDBase.NeighborTypes.MULTIBLOCK) {
            this.pos = null;
            return false;
        }
        this.pos = blockPosition;
        this.oldDirection = this.direction;
        this.progress = (byte)(this.progress % 100);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ISound getSound() {
        return new SoundWoosh(this);
    }

    public void func_70030_z() {
    }

    public void setPosition(double d) {
        if (this.pos == null) {
            return;
        }
        if (this.pause > 0) {
            Vector3 vector3 = this.getPos(d);
            this.func_70107_b(vector3.x, vector3.y, vector3.z);
            this.field_70142_S = this.field_70169_q = this.field_70165_t;
            this.field_70137_T = this.field_70167_r = this.field_70163_u;
            this.field_70136_U = this.field_70166_s = this.field_70161_v;
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            return;
        }
        Vector3 vector3 = this.getPos(d - 1.0);
        this.field_70142_S = this.field_70169_q = vector3.x;
        this.field_70137_T = this.field_70167_r = vector3.y;
        this.field_70136_U = this.field_70166_s = vector3.z;
        Vector3 vector32 = this.getPos(d);
        this.func_70107_b(vector32.x, vector32.y, vector32.z);
        this.field_70159_w = vector32.x - vector3.x;
        this.field_70181_x = vector32.y - vector3.y;
        this.field_70179_y = vector32.z - vector3.z;
        this.func_70043_V();
    }

    public void dropPassenger() {
        if (!this.field_70170_p.field_72995_K) {
            this.rider.func_70078_a(null);
            if (this.direction >= 0 && this.direction < 6) {
                double d = (double)(this.pos.x + Facing.field_71586_b[this.direction]) + 0.5;
                double d2 = this.pos.y + Facing.field_71587_c[this.direction];
                double d3 = (double)(this.pos.z + Facing.field_71585_d[this.direction]) + 0.5;
                if (this.direction == 0) {
                    d2 = Math.floor((float)this.pos.y - this.originalHeight);
                }
                this.rider.func_70107_b(d, d2, d3);
                if (this.rider instanceof EntityPlayerMP) {
                    float f;
                    float f2;
                    switch (this.direction) {
                        case 0: {
                            f2 = this.rider.field_70177_z;
                            f = 0.0f;
                            break;
                        }
                        case 1: {
                            f2 = this.rider.field_70177_z;
                            f = 0.0f;
                            break;
                        }
                        case 2: {
                            f2 = 180.0f;
                            f = 0.0f;
                            break;
                        }
                        case 3: {
                            f2 = 0.0f;
                            f = 0.0f;
                            break;
                        }
                        case 4: {
                            f2 = 90.0f;
                            f = 0.0f;
                            break;
                        }
                        case 5: {
                            f2 = 270.0f;
                            f = 0.0f;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    ((EntityPlayerMP)this.rider).field_71135_a.func_147364_a(d, d2, d3, f2, f);
                }
            }
            this.func_70106_y();
        }
    }

    public boolean func_70041_e_() {
        return false;
    }

    public void advanceTile(TileTransportDuctBaseRoute tileTransportDuctBaseRoute) {
        if (tileTransportDuctBaseRoute.neighborTypes[this.direction] == TileTDBase.NeighborTypes.MULTIBLOCK && tileTransportDuctBaseRoute.connectionTypes[this.direction] == TileTDBase.ConnectionTypes.NORMAL) {
            TileTransportDuctBase tileTransportDuctBase = (TileTransportDuctBase)tileTransportDuctBaseRoute.getPhysicalConnectedSide(this.direction);
            if (tileTransportDuctBase != null && tileTransportDuctBase.neighborTypes[this.direction ^ 1] == TileTDBase.NeighborTypes.MULTIBLOCK) {
                this.pos = new BlockPosition((TileEntity)tileTransportDuctBase);
                if (this.myPath.hasNextDirection()) {
                    this.oldDirection = this.direction;
                    this.direction = this.myPath.getNextDirection();
                } else {
                    this.reRoute = true;
                }
            } else {
                this.reRoute = true;
            }
        } else if (tileTransportDuctBaseRoute.neighborTypes[this.direction] == TileTDBase.NeighborTypes.OUTPUT && tileTransportDuctBaseRoute.connectionTypes[this.direction].allowTransfer) {
            this.dropPassenger();
        } else {
            this.bouncePassenger(tileTransportDuctBaseRoute);
        }
    }

    public void bouncePassenger(TileTransportDuctBaseRoute tileTransportDuctBaseRoute) {
        if (tileTransportDuctBaseRoute.internalGrid == null) {
            return;
        }
        this.myPath = tileTransportDuctBaseRoute.getRoute(this, this.direction, this.step);
        if (this.myPath == null) {
            this.dropPassenger();
        } else {
            this.oldDirection = this.direction;
            this.direction = this.myPath.getNextDirection();
            this.reRoute = false;
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)1);
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public void updateWatcherData() {
        byte by = (byte)(this.direction | this.oldDirection << 3);
        this.field_70180_af.func_75692_b(16, (Object)by);
        this.field_70180_af.func_75692_b(17, (Object)this.progress);
        this.field_70180_af.func_75692_b(18, (Object)this.pos.x);
        this.field_70180_af.func_75692_b(19, (Object)this.pos.y);
        this.field_70180_af.func_75692_b(20, (Object)this.pos.z);
        this.field_70180_af.func_75692_b(21, (Object)this.step);
        this.field_70180_af.func_75692_b(22, (Object)this.pause);
    }

    public void loadWatcherData() {
        byte by = this.field_70180_af.func_75683_a(16);
        this.direction = (byte)(by & 7);
        this.oldDirection = (byte)(by >> 3);
        this.progress = this.field_70180_af.func_75683_a(17);
        this.pos = new BlockPosition(this.field_70180_af.func_75679_c(18), this.field_70180_af.func_75679_c(19), this.field_70180_af.func_75679_c(20));
        this.step = this.field_70180_af.func_75683_a(21);
        this.pause = this.field_70180_af.func_75683_a(22);
    }

    protected void func_70037_a(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.func_150297_b("route", 7)) {
            this.myPath = new Route(nBTTagCompound.func_74770_j("route"));
        }
        this.pos = new BlockPosition(nBTTagCompound.func_74762_e("posx"), nBTTagCompound.func_74762_e("posy"), nBTTagCompound.func_74762_e("posz"));
        this.progress = nBTTagCompound.func_74771_c("progress");
        this.direction = nBTTagCompound.func_74771_c("direction");
        this.oldDirection = nBTTagCompound.func_74771_c("oldDirection");
        this.step = nBTTagCompound.func_74771_c("step");
        this.reRoute = nBTTagCompound.func_74767_n("reRoute");
        this.originalWidth = nBTTagCompound.func_74760_g("originalWidth");
        this.originalHeight = nBTTagCompound.func_74760_g("originalHeight");
        this.originalYOffset = nBTTagCompound.func_74760_g("originalYOffset");
        this.originalEyeHeight = nBTTagCompound.func_74760_g("originalEyeHeight");
    }

    protected void func_70014_b(NBTTagCompound nBTTagCompound) {
        if (this.myPath != null) {
            nBTTagCompound.func_74773_a("route", this.myPath.toByteArray());
        }
        nBTTagCompound.func_74768_a("posx", this.pos.x);
        nBTTagCompound.func_74768_a("posy", this.pos.y);
        nBTTagCompound.func_74768_a("posz", this.pos.z);
        nBTTagCompound.func_74774_a("progress", this.progress);
        nBTTagCompound.func_74774_a("direction", this.direction);
        nBTTagCompound.func_74774_a("oldDirection", this.oldDirection);
        nBTTagCompound.func_74774_a("step", this.step);
        nBTTagCompound.func_74757_a("reRoute", this.reRoute);
        nBTTagCompound.func_74776_a("originalWidth", this.originalWidth);
        nBTTagCompound.func_74776_a("originalHeight", this.originalHeight);
        nBTTagCompound.func_74776_a("originalYOffset", this.originalYOffset);
        nBTTagCompound.func_74776_a("originalEyeHeight", this.originalEyeHeight);
    }

    public Vector3 getPos(double d) {
        return this.getPos(this.progress, d);
    }

    public Vector3 getPos(byte by, double d) {
        double d2 = ((double)by + (double)this.step * d) / 100.0 - 0.5;
        byte by2 = d2 < 0.0 ? this.oldDirection : this.direction;
        Vector3 vector3 = Vector3.center.copy();
        vector3.add(d2 * (double)Facing.field_71586_b[by2], d2 * (double)Facing.field_71587_c[by2], d2 * (double)Facing.field_71585_d[by2]);
        vector3.add((double)this.pos.x, (double)this.pos.y, (double)this.pos.z);
        return vector3;
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70058_J() {
        return false;
    }

    public void func_70091_d(double d, double d2, double d3) {
        this.setPosition(0.0);
    }

    public void func_70024_g(double d, double d2, double d3) {
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70112_a(double d) {
        return d < 4096.0;
    }

    public void teleport(TileTransportDuctBaseRoute tileTransportDuctBaseRoute) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L || this.rider == null || this.rider.field_70128_L) {
            return;
        }
        int n = tileTransportDuctBaseRoute.world().field_73011_w.field_76574_g;
        int n2 = this.field_71093_bK;
        if (n != n2) {
            MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
            WorldServer worldServer = minecraftServer.func_71218_a(n2);
            WorldServer worldServer2 = minecraftServer.func_71218_a(n);
            this.rider.func_70078_a(null);
            this.transferNormalEntity(n2, n, worldServer, worldServer2, this);
            if (this.rider instanceof EntityPlayerMP) {
                this.transferPlayer(n, this.rider);
            } else {
                this.transferNormalEntity(n2, n, worldServer, worldServer2, this.rider);
            }
            this.rider.func_70078_a((Entity)this);
            worldServer.func_82742_i();
            worldServer2.func_82742_i();
        }
        this.pos = new BlockPosition((TileEntity)tileTransportDuctBaseRoute);
        if (this.myPath.hasNextDirection()) {
            this.oldDirection = this.direction;
            this.direction = this.myPath.getNextDirection();
        } else {
            this.reRoute = true;
        }
    }

    public void transferPlayer(int n, Entity entity) {
        entity.func_71027_c(n);
    }

    public void transferNormalEntity(int n, int n2, WorldServer worldServer, WorldServer worldServer2, Entity entity) {
        entity.field_70170_p.func_72900_e(entity);
        MinecraftServer.func_71276_C().func_71203_ab().func_82448_a(entity, n, worldServer, worldServer2);
        worldServer2.func_72838_d(entity);
        entity.field_71093_bK = n2;
    }
}

