/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.retriever;

import cofh.core.render.RenderUtils;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.render.RenderDuct;
import java.util.Iterator;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class RetrieverFluid
extends ServoFluid {
    public RetrieverFluid(TileTDBase tileTDBase, byte by) {
        super(tileTDBase, by);
    }

    public RetrieverFluid(TileTDBase tileTDBase, byte by, int n) {
        super(tileTDBase, by, n);
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    public void tick(int n) {
        if (!(n == 1 && this.fluidDuct.fluidGrid != null && this.isPowered && this.isValidInput && this.tile.cachesExist())) {
            return;
        }
        int n2 = (int)Math.ceil((float)this.fluidDuct.fluidGrid.myTank.fluidThroughput * ServoFluid.throttle[this.type]);
        if (this.fluidDuct.fluidGrid.myTank.getFluid() != null && !this.fluidPassesFiltering(this.fluidDuct.fluidGrid.myTank.getFluid())) {
            return;
        }
        Iterator<IMultiBlock> iterator = this.fluidDuct.fluidGrid.nodeSet.iterator();
        while (iterator.hasNext() && n2 > 0) {
            TileFluidDuct tileFluidDuct = (TileFluidDuct)iterator.next();
            if (!tileFluidDuct.cachesExist()) continue;
            for (int i = 0; i < 6 && n2 > 0; ++i) {
                FluidStack fluidStack;
                int n3;
                int n4 = (i + tileFluidDuct.internalSideCounter) % 6;
                if (tileFluidDuct.cache[n4] == null || tileFluidDuct.neighborTypes[n4] != TileTDBase.NeighborTypes.OUTPUT && tileFluidDuct.neighborTypes[n4] != TileTDBase.NeighborTypes.INPUT || tileFluidDuct.attachments[n4] != null && tileFluidDuct.attachments[n4].getId() == this.getId() || (n3 = tileFluidDuct.fill(ForgeDirection.VALID_DIRECTIONS[n4], tileFluidDuct.cache[n4].drain(ForgeDirection.VALID_DIRECTIONS[n4 ^ 1], n2, false), false)) == 0 || (fluidStack = tileFluidDuct.cache[n4].drain(ForgeDirection.VALID_DIRECTIONS[n4 ^ 1], n3, false)) == null || fluidStack.amount <= 0 || !this.fluidPassesFiltering(fluidStack) || !tileFluidDuct.cache[n4].canDrain(ForgeDirection.VALID_DIRECTIONS[n4 ^ 1], fluidStack.getFluid())) continue;
                fluidStack = tileFluidDuct.cache[n4].drain(ForgeDirection.VALID_DIRECTIONS[n4 ^ 1], n3, true);
                n2 -= tileFluidDuct.fill(ForgeDirection.VALID_DIRECTIONS[n4], fluidStack, true);
                if (this.fluidDuct.fluidGrid.toDistribute <= 0 || this.fluidDuct.fluidGrid.myTank.getFluid() == null) continue;
                this.fluidDuct.transfer(this.side, Math.min(this.fluidDuct.fluidGrid.myTank.getFluid().amount, this.fluidDuct.fluidGrid.toDistribute), false, this.fluidDuct.fluidGrid.myTank.getFluid(), true);
            }
        }
    }

    @Override
    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalDynamics.itemRetriever, 1, this.type);
    }

    @Override
    public String getName() {
        return "item.thermaldynamics.retriever." + this.type + ".name";
    }

    @Override
    public boolean render(int n, RenderBlocks renderBlocks) {
        if (n == 1) {
            return false;
        }
        Translation translation = RenderUtils.getRenderVector((double)((double)((TileEntity)this.tile).field_145851_c + 0.5), (double)((double)((TileEntity)this.tile).field_145848_d + 0.5), (double)((double)((TileEntity)this.tile).field_145849_e + 0.5)).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)RenderDuct.retrieverTexture[this.type * 2 + (this.stuffed ? 1 : 0)])});
        return true;
    }

    @Override
    public TileTDBase.NeighborTypes getNeighborType() {
        return this.isValidInput ? TileTDBase.NeighborTypes.OUTPUT : TileTDBase.NeighborTypes.DUCT_ATTACHMENT;
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        super.writePortableData(entityPlayer, nBTTagCompound);
        nBTTagCompound.func_74778_a("DisplayType", "item.thermaldynamics.retriever.0.name");
    }
}

