/*
 * Decompiled with CFR 0.152.
 */
package mantle.books;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.List;
import mantle.books.BookData;

public class BookDataStore {
    private static HashBiMap<String, BookData> data = HashBiMap.create();
    private static HashBiMap<Integer, String> intMap = HashBiMap.create();
    private static List<String> zipBooks = Lists.newArrayList();

    public static void addBook(BookData bd) {
        int insertOrder = data.size();
        data.put((Object)bd.getFullUnlocalizedName(), (Object)bd);
        intMap.put((Object)insertOrder, (Object)bd.getFullUnlocalizedName());
        if (bd.isFromZip) {
            zipBooks.add(bd.getFullUnlocalizedName());
        }
    }

    public static BookData getBookfromName(String ModID, String unlocalizedName) {
        return BookDataStore.getBookFromName(ModID + ":" + unlocalizedName);
    }

    public static BookData getBookFromName(String fullBookName) {
        return (BookData)data.get((Object)fullBookName);
    }

    public static BookData getBookfromID(int bookIDNum) {
        return (BookData)data.get(intMap.get((Object)bookIDNum));
    }

    public static int getIDFromName(String FullUnlocalizedName) {
        return (Integer)intMap.inverse().get((Object)FullUnlocalizedName);
    }

    public static int getIDFromBook(BookData b) {
        return BookDataStore.getIDFromName((String)data.inverse().get((Object)b));
    }

    public static List<String> getZipBooks() {
        return zipBooks;
    }
}

