/*
 * Decompiled with CFR 0.152.
 */
package mantle.blocks.abstracts;

import mantle.blocks.BlockUtils;
import mantle.blocks.iface.IMasterLogic;
import mantle.blocks.iface.IServantLogic;
import mantle.debug.DebugData;
import mantle.debug.IDebuggable;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MultiServantLogic
extends TileEntity
implements IServantLogic,
IDebuggable {
    boolean hasMaster;
    CoordTuple master;
    Block masterBlock;
    byte masterMeat;

    public boolean canUpdate() {
        return false;
    }

    public boolean getHasMaster() {
        return this.hasMaster;
    }

    public boolean hasValidMaster() {
        if (!this.hasMaster) {
            return false;
        }
        if (this.field_145850_b.func_147439_a(this.master.x, this.master.y, this.master.z) == this.masterBlock && this.field_145850_b.func_72805_g(this.master.x, this.master.y, this.master.z) == this.masterMeat) {
            return true;
        }
        this.hasMaster = false;
        this.master = null;
        return false;
    }

    @Override
    public CoordTuple getMasterPosition() {
        return this.master;
    }

    public void overrideMaster(int x, int y, int z) {
        this.hasMaster = true;
        this.master = new CoordTuple(x, y, z);
        this.masterBlock = this.field_145850_b.func_147439_a(x, y, z);
        this.masterMeat = (byte)this.field_145850_b.func_72805_g(x, y, z);
    }

    public void removeMaster() {
        this.hasMaster = false;
        this.master = null;
        this.masterBlock = null;
        this.masterMeat = 0;
    }

    @Override
    public boolean setPotentialMaster(IMasterLogic master, World w, int x, int y, int z) {
        return !this.hasMaster;
    }

    @Deprecated
    public boolean verifyMaster(IMasterLogic logic, int x, int y, int z) {
        return this.master.equalCoords(x, y, z) && this.field_145850_b.func_147439_a(x, y, z) == this.masterBlock && this.field_145850_b.func_72805_g(x, y, z) == this.masterMeat;
    }

    @Override
    public boolean verifyMaster(IMasterLogic logic, World world, int x, int y, int z) {
        if (this.hasMaster) {
            return this.hasValidMaster();
        }
        this.overrideMaster(x, y, z);
        return true;
    }

    @Override
    public void invalidateMaster(IMasterLogic master, World w, int x, int y, int z) {
        this.hasMaster = false;
        master = null;
    }

    @Override
    public void notifyMasterOfChange() {
        if (this.hasValidMaster()) {
            IMasterLogic logic = (IMasterLogic)this.field_145850_b.func_147438_o(this.master.x, this.master.y, this.master.z);
            logic.notifyChange(this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.hasMaster = tags.func_74767_n("TiedToMaster");
        if (this.hasMaster) {
            int xCenter = tags.func_74762_e("xCenter");
            int yCenter = tags.func_74762_e("yCenter");
            int zCenter = tags.func_74762_e("zCenter");
            this.master = new CoordTuple(xCenter, yCenter, zCenter);
            this.masterBlock = BlockUtils.getBlockFromUniqueName(tags.func_74779_i("MasterBlockName"));
            this.masterMeat = tags.func_74771_c("masterMeat");
        }
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74757_a("TiedToMaster", this.hasMaster);
        if (this.hasMaster) {
            tags.func_74768_a("xCenter", this.master.x);
            tags.func_74768_a("yCenter", this.master.y);
            tags.func_74768_a("zCenter", this.master.z);
            tags.func_74778_a("MasterBlockName", BlockUtils.getUniqueName(this.masterBlock));
            tags.func_74774_a("masterMeat", this.masterMeat);
        }
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readCustomNBT(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.writeCustomNBT(tags);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public DebugData getDebugInfo(EntityPlayer player) {
        String[] strs = new String[]{"Location: x" + this.field_145851_c + ", y" + this.field_145848_d + ", z" + this.field_145849_e, this.hasMaster ? "masterBlock: " + this.masterBlock.toString() + ", masterMeat: " + this.masterMeat : "No active master."};
        return new DebugData(player, this.getClass(), strs);
    }

    public World getWorld() {
        return this.func_145831_w();
    }

    @Deprecated
    public boolean setMaster(int x, int y, int z) {
        if (!this.hasMaster || this.field_145850_b.func_147439_a(this.master.x, this.master.y, this.master.z) != this.masterBlock || this.field_145850_b.func_72805_g(this.master.x, this.master.y, this.master.z) != this.masterMeat) {
            this.overrideMaster(x, y, z);
            return true;
        }
        return false;
    }
}

