/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.position;

import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.position.IRotateableTile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPosition
implements Comparable<BlockPosition>,
Serializable {
    private static final long serialVersionUID = 8671402745765780610L;
    public int x;
    public int y;
    public int z;
    public ForgeDirection orientation;

    public BlockPosition(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPosition(int n, int n2, int n3, ForgeDirection forgeDirection) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.orientation = forgeDirection;
    }

    public BlockPosition(BlockPosition blockPosition) {
        this.x = blockPosition.x;
        this.y = blockPosition.y;
        this.z = blockPosition.z;
        this.orientation = blockPosition.orientation;
    }

    public BlockPosition(NBTTagCompound nBTTagCompound) {
        this.x = nBTTagCompound.func_74762_e("bp_i");
        this.y = nBTTagCompound.func_74762_e("bp_j");
        this.z = nBTTagCompound.func_74762_e("bp_k");
        this.orientation = !nBTTagCompound.func_74764_b("bp_dir") ? ForgeDirection.UNKNOWN : ForgeDirection.getOrientation((int)nBTTagCompound.func_74771_c("bp_dir"));
    }

    public BlockPosition(TileEntity tileEntity) {
        this.x = tileEntity.field_145851_c;
        this.y = tileEntity.field_145848_d;
        this.z = tileEntity.field_145849_e;
        this.orientation = tileEntity instanceof IRotateableTile ? ((IRotateableTile)tileEntity).getDirectionFacing() : ForgeDirection.UNKNOWN;
    }

    public static <T extends TileEntity> BlockPosition fromRotateableTile(T t) {
        return new BlockPosition(t);
    }

    public BlockPosition copy() {
        return new BlockPosition(this.x, this.y, this.z, this.orientation);
    }

    public BlockPosition copy(ForgeDirection forgeDirection) {
        return new BlockPosition(this.x, this.y, this.z, forgeDirection);
    }

    public BlockPosition setOrientation(ForgeDirection forgeDirection) {
        this.orientation = forgeDirection;
        return this;
    }

    public BlockPosition step(int n) {
        int[] nArray = BlockHelper.SIDE_COORD_MOD[n];
        this.x += nArray[0];
        this.y += nArray[1];
        this.z += nArray[2];
        return this;
    }

    public BlockPosition step(int n, int n2) {
        int[] nArray = BlockHelper.SIDE_COORD_MOD[n];
        this.x += nArray[0] * n2;
        this.y += nArray[1] * n2;
        this.z += nArray[2] * n2;
        return this;
    }

    public BlockPosition step(ForgeDirection forgeDirection) {
        this.x += forgeDirection.offsetX;
        this.y += forgeDirection.offsetY;
        this.z += forgeDirection.offsetZ;
        return this;
    }

    public BlockPosition step(ForgeDirection forgeDirection, int n) {
        this.x += forgeDirection.offsetX * n;
        this.y += forgeDirection.offsetY * n;
        this.z += forgeDirection.offsetZ * n;
        return this;
    }

    public BlockPosition moveForwards(int n) {
        switch (this.orientation) {
            case UP: {
                this.y += n;
                break;
            }
            case DOWN: {
                this.y -= n;
                break;
            }
            case SOUTH: {
                this.z += n;
                break;
            }
            case NORTH: {
                this.z -= n;
                break;
            }
            case EAST: {
                this.x += n;
                break;
            }
            case WEST: {
                this.x -= n;
                break;
            }
        }
        return this;
    }

    public BlockPosition moveBackwards(int n) {
        return this.moveForwards(-n);
    }

    public BlockPosition moveRight(int n) {
        switch (this.orientation) {
            case UP: 
            case SOUTH: {
                this.x -= n;
                break;
            }
            case DOWN: 
            case NORTH: {
                this.x += n;
                break;
            }
            case EAST: {
                this.z += n;
                break;
            }
            case WEST: {
                this.z -= n;
                break;
            }
        }
        return this;
    }

    public BlockPosition moveLeft(int n) {
        return this.moveRight(-n);
    }

    public BlockPosition moveUp(int n) {
        switch (this.orientation) {
            case SOUTH: 
            case NORTH: 
            case EAST: 
            case WEST: {
                this.y += n;
                break;
            }
            case UP: {
                this.z -= n;
                break;
            }
            case DOWN: {
                this.z += n;
            }
        }
        return this;
    }

    public BlockPosition moveDown(int n) {
        return this.moveUp(-n);
    }

    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("bp_i", this.x);
        nBTTagCompound.func_74768_a("bp_j", this.y);
        nBTTagCompound.func_74768_a("bp_k", this.z);
        nBTTagCompound.func_74774_a("bp_dir", (byte)this.orientation.ordinal());
    }

    public String toString() {
        if (this.orientation == null) {
            return "{" + this.x + ", " + this.y + ", " + this.z + "}";
        }
        return "{" + this.x + ", " + this.y + ", " + this.z + ";" + this.orientation.toString() + "}";
    }

    public boolean equals(Object object) {
        if (!(object instanceof BlockPosition)) {
            return false;
        }
        BlockPosition blockPosition = (BlockPosition)object;
        return blockPosition.x == this.x & blockPosition.y == this.y & blockPosition.z == this.z & blockPosition.orientation == this.orientation;
    }

    public boolean equals(BlockPosition blockPosition) {
        return blockPosition != null && blockPosition.x == this.x & blockPosition.y == this.y & blockPosition.z == this.z & blockPosition.orientation == this.orientation;
    }

    public int hashCode() {
        return this.x & 0xFFF | this.y & 0xFF00 | this.z & 0xFFF000;
    }

    public BlockPosition min(BlockPosition blockPosition) {
        return new BlockPosition(blockPosition.x > this.x ? this.x : blockPosition.x, blockPosition.y > this.y ? this.y : blockPosition.y, blockPosition.z > this.z ? this.z : blockPosition.z);
    }

    public BlockPosition max(BlockPosition blockPosition) {
        return new BlockPosition(blockPosition.x < this.x ? this.x : blockPosition.x, blockPosition.y < this.y ? this.y : blockPosition.y, blockPosition.z < this.z ? this.z : blockPosition.z);
    }

    public List<BlockPosition> getAdjacent(boolean bl) {
        ArrayList<BlockPosition> arrayList = new ArrayList<BlockPosition>(4 + (bl ? 2 : 0));
        arrayList.add(this.copy(ForgeDirection.EAST).moveForwards(1));
        arrayList.add(this.copy(ForgeDirection.WEST).moveForwards(1));
        arrayList.add(this.copy(ForgeDirection.SOUTH).moveForwards(1));
        arrayList.add(this.copy(ForgeDirection.NORTH).moveForwards(1));
        if (bl) {
            arrayList.add(this.copy(ForgeDirection.UP).moveForwards(1));
            arrayList.add(this.copy(ForgeDirection.DOWN).moveForwards(1));
        }
        return arrayList;
    }

    public boolean blockExists(World world) {
        return world.func_72899_e(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public <T> T getTileEntity(World world, Class<T> clazz) {
        TileEntity tileEntity = world.func_147438_o(this.x, this.y, this.z);
        if (clazz.isInstance(tileEntity)) {
            return (T)tileEntity;
        }
        return null;
    }

    public static ForgeDirection getDirection(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        if (n5 < n2) {
            n7 |= 1;
        } else if (n5 != n2) {
            n7 |= 2;
        }
        if (n6 < n3) {
            n7 |= 4;
        } else if (n6 != n3) {
            n7 |= 8;
        }
        if (n4 < n) {
            n7 |= 0x10;
        } else if (n4 != n) {
            n7 |= 0x20;
        }
        switch (n7) {
            case 2: {
                return ForgeDirection.UP;
            }
            case 1: {
                return ForgeDirection.DOWN;
            }
            case 4: {
                return ForgeDirection.WEST;
            }
            case 8: {
                return ForgeDirection.EAST;
            }
            case 16: {
                return ForgeDirection.NORTH;
            }
            case 32: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static TileEntity getTileEntityRaw(World world, int n, int n2, int n3) {
        if (!world.func_72899_e(n, n2, n3)) {
            return null;
        }
        ChunkPosition chunkPosition = new ChunkPosition(n & 0xF, n2, n3 & 0xF);
        Chunk chunk = world.func_72938_d(n, n3);
        TileEntity tileEntity = (TileEntity)chunk.field_150816_i.get(chunkPosition);
        return tileEntity == null || tileEntity.func_145837_r() ? null : tileEntity;
    }

    public static <T> T getTileEntityRaw(World world, int n, int n2, int n3, Class<T> clazz) {
        TileEntity tileEntity = BlockPosition.getTileEntityRaw(world, n, n2, n3);
        if (clazz.isInstance(tileEntity)) {
            return (T)tileEntity;
        }
        return null;
    }

    public static boolean blockExists(TileEntity tileEntity, ForgeDirection forgeDirection) {
        int n = tileEntity.field_145851_c + forgeDirection.offsetX;
        int n2 = tileEntity.field_145848_d + forgeDirection.offsetY;
        int n3 = tileEntity.field_145849_e + forgeDirection.offsetZ;
        return tileEntity.func_145831_w().func_72899_e(n, n2, n3);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tileEntity, ForgeDirection forgeDirection) {
        int n = tileEntity.field_145851_c + forgeDirection.offsetX;
        int n2 = tileEntity.field_145848_d + forgeDirection.offsetY;
        int n3 = tileEntity.field_145849_e + forgeDirection.offsetZ;
        return BlockPosition.getTileEntityRaw(tileEntity.func_145831_w(), n, n2, n3);
    }

    public static <T> T getAdjacentTileEntity(TileEntity tileEntity, ForgeDirection forgeDirection, Class<T> clazz) {
        TileEntity tileEntity2 = BlockPosition.getAdjacentTileEntity(tileEntity, forgeDirection);
        if (clazz.isInstance(tileEntity2)) {
            return (T)tileEntity2;
        }
        return null;
    }

    @Override
    public int compareTo(BlockPosition blockPosition) {
        return this.x == blockPosition.x ? (this.y == blockPosition.y ? this.z - blockPosition.z : this.y - blockPosition.y) : this.x - blockPosition.x;
    }
}

