/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Random;

public class DungeonHooks {
    private static ArrayList<DungeonMob> dungeonMobs = new ArrayList();

    public static float addDungeonMob(String name, int rarity) {
        if (rarity <= 0) {
            throw new IllegalArgumentException("Rarity must be greater then zero");
        }
        for (DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            return mob.a += rarity;
        }
        dungeonMobs.add(new DungeonMob(rarity, name));
        return rarity;
    }

    public static int removeDungeonMob(String name) {
        for (DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            dungeonMobs.remove((Object)mob);
            return mob.a;
        }
        return 0;
    }

    public static String getRandomDungeonMob(Random rand) {
        DungeonMob mob = (DungeonMob)qv.a((Random)rand, dungeonMobs);
        if (mob == null) {
            return "";
        }
        return mob.type;
    }

    static {
        DungeonHooks.addDungeonMob("Skeleton", 100);
        DungeonHooks.addDungeonMob("Zombie", 200);
        DungeonHooks.addDungeonMob("Spider", 100);
    }

    public static class DungeonMob
    extends qw {
        public String type;

        public DungeonMob(int weight, String type) {
            super(weight);
            this.type = type;
        }

        public boolean equals(Object target) {
            return target instanceof DungeonMob && this.type.equals(((DungeonMob)((Object)target)).type);
        }
    }
}

