/*
 * Decompiled with CFR 0.152.
 */
package modconfig.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import modconfig.ConfigEntryInfo;
import modconfig.ConfigMod;
import modconfig.ModConfigData;
import modconfig.gui.GuiBetterSlot;
import modconfig.gui.GuiConfigEditor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiConfigScrollPanel
extends GuiBetterSlot {
    private GuiConfigEditor config;
    private Minecraft mc;
    private String[] message;
    private int _mouseX;
    private int _mouseY;
    private int selected = -1;
    public ResourceLocation resGUI = new ResourceLocation("/gui/gui.png");

    public GuiConfigScrollPanel(GuiConfigEditor controls, Minecraft mc, int startX, int startY, int height, int slotSize) {
        super(mc, controls.field_146294_l + 100, controls.field_146295_m, startY + 8 + slotSize, height + slotSize - 2, slotSize);
        this.config = controls;
        this.mc = mc;
    }

    @Override
    protected int getSize() {
        ModConfigData data = this.config.getData();
        return data.configData.size();
    }

    @Override
    protected void elementClicked(int i, boolean flag) {
        if (!flag) {
            this.selected = i;
            KeyBinding.func_74508_b();
        }
    }

    protected void mouseClicked(int par1, int par2, int par3) {
        boolean anyHasFocus = false;
        for (int i = 0; i < this.config.getData().configData.size(); ++i) {
            try {
                this.config.getData().configData.get((int)i).editBox.mouseClicked(par1, par2, par3);
                if (!this.config.getData().configData.get((int)i).editBox.isFocused()) continue;
                anyHasFocus = true;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!anyHasFocus) {
            // empty if block
        }
    }

    @Override
    protected boolean isSelected(int i) {
        return false;
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void drawContainerBackground(Tessellator tess) {
    }

    @Override
    public void drawScreen(int mX, int mY, float f) {
        this._mouseX = mX;
        this._mouseY = mY;
        if (this.selected != -1 && !Mouse.isButtonDown((int)0) && Mouse.getDWheel() == 0 && Mouse.next() && Mouse.getEventButtonState()) {
            this.selected = -1;
            KeyBinding.func_74508_b();
        }
        try {
            super.drawScreen(mX, mY, f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void drawSlot(int index, int xPosition, int yPosition, int l, Tessellator tessellator) {
        int width = 70;
        int height = this.slotHeight;
        boolean flag = this._mouseX >= (xPosition -= 20) && this._mouseY >= yPosition && this._mouseX < xPosition + width && this._mouseY < yPosition + height;
        int k = flag ? 2 : 1;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int stringWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.config.getData().configData.get((int)index).name);
        this.config.func_73731_b(this.mc.field_71466_p, this.config.getData().configData.get((int)index).name, xPosition - stringWidth + 15, yPosition + 3, -1);
        boolean conflict = false;
        String value = this.config.getData().configData.get((int)index).value.toString();
        int maxWidth = this.config.xSize / 2 - 45;
        value = Minecraft.func_71410_x().field_71466_p.func_78269_a(value, maxWidth);
        String str = (conflict ? EnumChatFormatting.RED : "") + value;
        str = index == this.selected ? EnumChatFormatting.WHITE + "> " + EnumChatFormatting.YELLOW + "??? " + EnumChatFormatting.WHITE + "<" : str;
        List<ConfigEntryInfo> configDataTest = this.config.getData().configData;
        if (this.config.getData().configData.get(index) == null) {
            return;
        }
        this.config.getData().configData.get((int)index).editBox.xPos = xPosition + 20;
        this.config.getData().configData.get((int)index).editBox.yPos = yPosition;
        this.config.getData().configData.get((int)index).editBox.drawTextBox();
        int hover_x_min = xPosition - stringWidth + 15;
        int hover_y_min = yPosition;
        int hover_x_max = xPosition - 15;
        int hover_y_max = yPosition + height;
        boolean hover_string = this._mouseX >= hover_x_min && this._mouseY >= hover_y_min && this._mouseX < hover_x_max && this._mouseY < hover_y_max;
        String s = ConfigMod.getComment(this.config.getData().configID, this.config.getData().configData.get((int)index).name);
        if (hover_string && s != null) {
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2929);
            int l2 = Minecraft.func_71410_x().field_71466_p.func_78256_a(s);
            int i2 = hover_x_min;
            int k2 = hover_y_min - 10;
            this.drawGradientRect(i2 - 3, k2 - 3, i2 + l2 + 3, k2 + 8 + 3, -1073741824, -1073741824);
            Minecraft.func_71410_x().field_71466_p.func_78261_a(s, i2, k2, -1);
            GL11.glEnable((int)2929);
        }
    }

    protected void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)par3, (double)par2, 0.0);
        tessellator.func_78377_a((double)par1, (double)par2, 0.0);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)par1, (double)par4, 0.0);
        tessellator.func_78377_a((double)par3, (double)par4, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public boolean keyTyped(char c, int i) {
        if (this.selected != -1 && this.config.getData().configData.get((int)this.selected).editBox.isFocused()) {
            this.config.getData().configData.get((int)this.selected).editBox.textboxKeyTyped(c, i);
            if (i == 28) {
                this.selected = -1;
                return true;
            }
            return false;
        }
        return true;
    }
}

