/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.economy;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.mutable.MutableInt;

public class Resources {
    public MutableInt resWood = new MutableInt();
    public MutableInt resStone = new MutableInt();
    public MutableInt resFood = new MutableInt();
    public MutableInt resCoal = new MutableInt();
    public MutableInt resIron = new MutableInt();
    public List<MutableInt> listResources = new ArrayList<MutableInt>();
    public MutableInt resWoodRate = new MutableInt();

    public Resources(Resources cloneSource) {
        this();
        for (int i = 0; i < this.listResources.size(); ++i) {
            this.listResources.get(i).setValue((Number)cloneSource.listResources.get(i));
        }
    }

    public Resources(int ... parResources) {
        this();
        for (int i = 0; i < parResources.length; ++i) {
            this.listResources.get(i).setValue(parResources[i]);
        }
    }

    public Resources() {
        this.listResources.add(this.resWood);
        this.listResources.add(this.resStone);
        this.listResources.add(this.resFood);
        this.listResources.add(this.resCoal);
        this.listResources.add(this.resIron);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.resWood.setValue(data.func_74762_e("resWood"));
        this.resStone.setValue(data.func_74762_e("resStone"));
        this.resFood.setValue(data.func_74762_e("resFood"));
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("resWood", this.resWood.getValue().intValue());
        data.func_74768_a("resStone", this.resStone.getValue().intValue());
        data.func_74768_a("resFood", this.resFood.getValue().intValue());
        return data;
    }

    public int getTotalResourceCount() {
        int val = 0;
        for (int i = 0; i < this.listResources.size(); ++i) {
            val += this.listResources.get(i).getValue().intValue();
        }
        return val;
    }

    public void transferResourcesFrom(Resources source) {
        this.transferResourcesFrom(source, false);
    }

    public void transferResourcesFrom(Resources source, boolean drainSourceOnly) {
        for (int i = 0; i < this.listResources.size(); ++i) {
            if (!drainSourceOnly) {
                this.listResources.get(i).add((Number)source.listResources.get(i).getValue());
            }
            source.listResources.get(i).setValue(0);
        }
    }

    public void sub(Resources source) {
        for (int i = 0; i < this.listResources.size(); ++i) {
            this.listResources.get(i).setValue(this.listResources.get(i).getValue() - source.listResources.get(i).getValue());
        }
    }

    public void mul(float mul) {
        for (int i = 0; i < this.listResources.size(); ++i) {
            this.listResources.get(i).setValue((Number)Float.valueOf((float)this.listResources.get(i).getValue().intValue() * mul));
        }
    }

    public boolean canAfford(Resources source) {
        for (int i = 0; i < this.listResources.size(); ++i) {
            if (this.listResources.get(i).getValue() >= source.listResources.get(i).getValue()) continue;
            return false;
        }
        return true;
    }
}

