/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.ability.abilities;

import CoroUtil.ability.Ability;
import CoroUtil.bt.IBTAgent;
import CoroUtil.entity.projectile.EntityArrow;
import CoroUtil.entity.projectile.EntityProjectileBase;
import CoroUtil.inventory.AIInventory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class AbilityShootArrow
extends Ability {
    public EntityLivingBase target;
    public int projectileType = 0;
    public boolean switchToRangedSlot = true;

    public AbilityShootArrow() {
        this.name = "ShootArrow";
        this.ticksToCharge = 40;
        this.ticksToPerform = 1;
        this.ticksToCooldown = 1;
        this.bestDist = 25.0f;
        this.bestDistRange = 30.0f;
    }

    @Override
    public void nbtLoad(NBTTagCompound nbt) {
        super.nbtLoad(nbt);
        this.projectileType = nbt.func_74762_e("projectileType");
    }

    @Override
    public NBTTagCompound nbtSave() {
        NBTTagCompound nbt = super.nbtSave();
        nbt.func_74768_a("projectileType", this.projectileType);
        return nbt;
    }

    @Override
    public void setTarget(Entity parTarget) {
        if (parTarget instanceof EntityLivingBase) {
            this.target = (EntityLivingBase)parTarget;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void tickRender(Render parRender) {
        super.tickRender(parRender);
        int curTick = this.curTickPerform;
        float amp = 1.0f;
        double offset = -1.1780972450961724;
        double range = Math.PI * 2;
        float swap = this.usageCount % 2 == 0 ? 1.0f : -1.0f;
    }

    @Override
    public void tickChargeUp() {
        super.tickChargeUp();
        if (this.owner.field_70170_p.field_72995_K) {
            Random rand = new Random();
            if (this.curTickCharge > 0) {
                int amount = 1 + (int)(10.0 * ((double)this.curTickCharge / (double)this.ticksToCharge) / (double)(Minecraft.func_71410_x().field_71474_y.field_74362_aa + 1));
                for (int i = 0; i < amount; ++i) {
                    double speed = 0.15;
                    double speedInheritFactor = 0.5;
                    EntityRotFX entityfx = this.particleBehavior.spawnNewParticleIconFX((World)Minecraft.func_71410_x().field_71441_e, ParticleRegistry.squareGrey, this.owner.field_70165_t + rand.nextDouble(), this.owner.field_70121_D.field_72338_b + 0.8, this.owner.field_70161_v + rand.nextDouble(), (rand.nextDouble() - rand.nextDouble()) * speed, 0.03, (rand.nextDouble() - rand.nextDouble()) * speed);
                    this.particleBehavior.initParticle(entityfx);
                    float f = 0.0f + rand.nextFloat() * 0.4f;
                    entityfx.func_70538_b(f, f, f);
                    entityfx.callUpdatePB = false;
                    ExtendedRenderer.rotEffRenderer.addEffect(entityfx);
                    this.particleBehavior.particles.add(entityfx);
                }
            }
        } else {
            if (this.switchToRangedSlot && this.owner instanceof IBTAgent) {
                ((IBTAgent)this.owner).getAIBTAgent().entInv.setSlotActive(AIInventory.slot_Ranged);
            }
            this.owner.field_70159_w *= (double)0.3f;
            this.owner.field_70181_x *= (double)0.3f;
            this.owner.field_70179_y *= (double)0.3f;
        }
    }

    @Override
    public void tickCooldown() {
        super.tickCooldown();
    }

    @Override
    public void tickPerform() {
        if (this.target == null) {
            this.setFinishedPerform();
            return;
        }
        if (this.owner.field_70170_p.field_72995_K) {
            this.particleBehavior.particles.clear();
            Random random = new Random();
        } else if (!(this.target != null && (this.target.field_70128_L || this.target instanceof EntityLivingBase && this.target.field_70725_aQ > 0) || this.hasAppliedDamage)) {
            this.hasAppliedDamage = true;
            if (this.owner instanceof EntityLiving) {
                ((EntityLiving)this.owner).func_70625_a((Entity)this.target, 180.0f, 180.0f);
            }
            if (this.target instanceof EntityLivingBase) {
                EntityArrow prj = null;
                if (this.projectileType == EntityProjectileBase.PRJTYPE_FIREBALL) {
                    prj = new EntityArrow(this.owner.field_70170_p, this.owner, this.target, 1.7);
                } else if (this.projectileType == EntityProjectileBase.PRJTYPE_ICEBALL) {
                    // empty if block
                }
                if (prj != null) {
                    this.owner.field_70170_p.func_72838_d(prj);
                }
            }
        }
        super.tickPerform();
    }
}

