/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.model.ModelPlane;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.ItemPlane;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.Propeller;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderPlane
extends Render
implements IItemRenderer {
    public RenderPlane() {
        this.field_76989_e = 0.5f;
    }

    public void render(EntityPlane entityPlane, double d, double d1, double d2, float f, float f1) {
        float dRoll;
        float dPitch;
        float dYaw;
        this.func_110777_b(entityPlane);
        PlaneType type = entityPlane.getPlaneType();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        for (dYaw = entityPlane.axes.getYaw() - entityPlane.field_70126_B; dYaw > 180.0f; dYaw -= 360.0f) {
        }
        while (dYaw <= -180.0f) {
            dYaw += 360.0f;
        }
        for (dPitch = entityPlane.axes.getPitch() - entityPlane.field_70127_C; dPitch > 180.0f; dPitch -= 360.0f) {
        }
        while (dPitch <= -180.0f) {
            dPitch += 360.0f;
        }
        for (dRoll = entityPlane.axes.getRoll() - entityPlane.prevRotationRoll; dRoll > 180.0f; dRoll -= 360.0f) {
        }
        while (dRoll <= -180.0f) {
            dRoll += 360.0f;
        }
        GL11.glRotatef((float)(180.0f - entityPlane.field_70126_B - dYaw * f1), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(entityPlane.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(entityPlane.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
        float modelScale = type.modelScale;
        GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
        ModelPlane model = (ModelPlane)type.model;
        if (model != null) {
            int i;
            model.render(entityPlane, f1);
            for (i = 0; i < model.heliMainRotorModels.length; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)model.heliMainRotorOrigins[i].x, (float)model.heliMainRotorOrigins[i].y, (float)model.heliMainRotorOrigins[i].z);
                GL11.glRotatef((float)((entityPlane.propAngle + f1 * entityPlane.throttle / 7.0f) * model.heliRotorSpeeds[i] * 1440.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)(-model.heliMainRotorOrigins[i].x), (float)(-model.heliMainRotorOrigins[i].y), (float)(-model.heliMainRotorOrigins[i].z));
                model.renderRotor(entityPlane, 0.0625f, i);
                GL11.glPopMatrix();
            }
            for (i = 0; i < model.heliTailRotorModels.length; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)model.heliTailRotorOrigins[i].x, (float)model.heliTailRotorOrigins[i].y, (float)model.heliTailRotorOrigins[i].z);
                GL11.glRotatef((float)((entityPlane.propAngle + f1 * entityPlane.throttle / 7.0f) * 1440.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-model.heliTailRotorOrigins[i].x), (float)(-model.heliTailRotorOrigins[i].y), (float)(-model.heliTailRotorOrigins[i].z));
                model.renderTailRotor(entityPlane, 0.0625f, i);
                GL11.glPopMatrix();
            }
        }
        if (FlansMod.DEBUG) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)-1.0f);
            for (DriveablePart part : entityPlane.getDriveableData().parts.values()) {
                if (part.box == null) continue;
                GL11.glColor4f((float)1.0f, (float)(entityPlane.isPartIntact(part.type) ? 1.0f : 0.0f), (float)0.0f, (float)0.3f);
                RenderPlane.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)part.box.x, (double)part.box.y, (double)part.box.z, (double)(part.box.x + part.box.w), (double)(part.box.y + part.box.h), (double)(part.box.z + part.box.d)));
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)0.3f);
            for (Propeller prop : type.propellers) {
                RenderPlane.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)((float)prop.x / 16.0f - 0.25f), (double)((float)prop.y / 16.0f - 0.25f), (double)((float)prop.z / 16.0f - 0.25f), (double)((float)prop.x / 16.0f + 0.25f), (double)((float)prop.y / 16.0f + 0.25f), (double)((float)prop.z / 16.0f + 0.25f)));
            }
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)1.0f, (float)0.3f);
            for (DriveablePosition point : type.shootPointsPrimary) {
                RenderPlane.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)(point.position.x - 0.25f), (double)(point.position.y - 0.25f), (double)(point.position.z - 0.25f), (double)(point.position.x + 0.25f), (double)(point.position.y + 0.25f), (double)(point.position.z + 0.25f)));
            }
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3f);
            for (DriveablePosition point : type.shootPointsSecondary) {
                RenderPlane.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)(point.position.x - 0.25f), (double)(point.position.y - 0.25f), (double)(point.position.z - 0.25f), (double)(point.position.x + 0.25f), (double)(point.position.y + 0.25f), (double)(point.position.z + 0.25f)));
            }
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
    }

    public void func_76986_a(Entity entity, double d, double d1, double d2, float f, float f1) {
        this.render((EntityPlane)entity, d, d1, d2, f, f1);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return FlansModResourceHandler.getTexture(((EntityPlane)entity).getPlaneType());
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case ENTITY: {
                return Minecraft.func_71410_x().field_71474_y.field_74347_j && item != null && item.func_77973_b() instanceof ItemPlane && ((ItemPlane)item.func_77973_b()).type.model != null;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        if (item != null && item.func_77973_b() instanceof ItemPlane) {
            PlaneType planeType = ((ItemPlane)item.func_77973_b()).type;
            if (planeType.model != null) {
                float scale = 0.5f;
                switch (type) {
                    case ENTITY: {
                        scale = 1.5f;
                        GL11.glRotatef((float)((EntityItem)data[1]).field_70173_aa, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case EQUIPPED: {
                        GL11.glRotatef((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.4f);
                        scale = 1.0f;
                        break;
                    }
                    case EQUIPPED_FIRST_PERSON: {
                        GL11.glRotatef((float)25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)-5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.15f, (float)0.45f, (float)-0.6f);
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                }
                GL11.glScalef((float)(scale / planeType.cameraDistance), (float)(scale / planeType.cameraDistance), (float)(scale / planeType.cameraDistance));
                Minecraft.func_71410_x().field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(planeType));
                ModelDriveable model = planeType.model;
                model.render(planeType);
            }
        }
        GL11.glPopMatrix();
    }
}

