/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import enhancedportals.block.BlockFrame;
import enhancedportals.item.ItemNanobrush;
import enhancedportals.network.GuiHandler;
import enhancedportals.portal.GlyphElement;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileDialingDevice;
import enhancedportals.tile.TileFrame;
import enhancedportals.utility.GeneralUtils;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class TileRedstoneInterface
extends TileFrame {
    public boolean isOutput = false;
    public byte state = 0;
    public byte previousRedstoneState = 0;
    byte timeUntilOff = 0;
    static int TPS = 20;
    public static byte MAX_INPUT_STATE = (byte)8;
    public static byte MAX_OUTPUT_STATE = (byte)8;

    @Override
    public boolean activate(EntityPlayer player, ItemStack stack) {
        if (player.func_70093_af()) {
            return false;
        }
        TileController controller = this.getPortalController();
        if (stack != null && controller != null && controller.isFinalized()) {
            if (GeneralUtils.isWrench(stack) && !player.func_70093_af()) {
                GuiHandler.openGui(player, this, 17);
                return true;
            }
            if (stack.func_77973_b() == ItemNanobrush.instance) {
                GuiHandler.openGui(player, controller, 8);
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDataToPacket(NBTTagCompound tag) {
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    int getHighestPowerState() {
        byte highest = 0;
        for (int i = 0; i < 6; ++i) {
            ChunkCoordinates c = GeneralUtils.offset(this.getChunkCoordinates(), ForgeDirection.getOrientation((int)i));
            byte power = (byte)this.func_145831_w().func_72878_l(c.field_71574_a, c.field_71572_b, c.field_71573_c, i);
            if (power <= highest) continue;
            highest = power;
        }
        return highest;
    }

    public int isProvidingPower(int side) {
        if (this.timeUntilOff != 0) {
            return 15;
        }
        return 0;
    }

    private void notifyNeighbors() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)BlockFrame.instance);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            this.field_145850_b.func_147459_d(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ, (Block)BlockFrame.instance);
        }
    }

    @Override
    public void onDataPacket(NBTTagCompound tag) {
    }

    public void onEntityTeleport(Entity entity) {
        if (this.isOutput) {
            if (this.state == 4 || this.state == 5 && entity instanceof EntityPlayer || this.state == 6 && entity instanceof EntityAnimal || this.state == 7 && entity instanceof EntityMob) {
                this.timeUntilOff = (byte)TPS;
            }
            this.notifyNeighbors();
        }
    }

    public void onNeighborBlockChange(Block b) {
        if (!this.isOutput && !this.field_145850_b.field_72995_K) {
            TileController controller = this.getPortalController();
            if (controller == null) {
                return;
            }
            boolean hasDialler = controller.getDiallingDevices().size() > 0;
            int redstoneInputState = this.getHighestPowerState();
            if (this.state == 1) {
                if (redstoneInputState > 0 && controller.isPortalActive()) {
                    controller.connectionTerminate();
                } else if (redstoneInputState == 0 && !controller.isPortalActive()) {
                    controller.connectionDial();
                }
            } else if (this.state == 3 && redstoneInputState > 0 && this.previousRedstoneState == 0 && controller.isPortalActive()) {
                controller.connectionTerminate();
            } else if (!hasDialler) {
                if (this.state == 0) {
                    if (redstoneInputState > 0 && !controller.isPortalActive()) {
                        controller.connectionDial();
                    } else if (redstoneInputState == 0 && controller.isPortalActive()) {
                        controller.connectionTerminate();
                    }
                } else if (this.state == 2 && redstoneInputState > 0 && this.previousRedstoneState == 0 && !controller.isPortalActive()) {
                    controller.connectionDial();
                }
            } else {
                TileDialingDevice dialler = controller.getDialDeviceRandom();
                if (dialler == null) {
                    return;
                }
                int glyphCount = dialler.glyphList.size();
                if (glyphCount == 0) {
                    return;
                }
                if (this.state == 4 && redstoneInputState > 0 && !controller.isPortalActive()) {
                    if (redstoneInputState - 1 < glyphCount) {
                        GlyphElement e = dialler.glyphList.get(redstoneInputState - 1);
                        controller.connectionDial(e.identifier, e.texture, null);
                    }
                } else if (this.state == 5) {
                    if (redstoneInputState > 0 && !controller.isPortalActive()) {
                        if (redstoneInputState - 1 < glyphCount) {
                            GlyphElement e = dialler.glyphList.get(redstoneInputState - 1);
                            controller.connectionDial(e.identifier, e.texture, null);
                        }
                    } else if (redstoneInputState == 0 && controller.isPortalActive()) {
                        controller.connectionTerminate();
                    }
                } else if (this.state == 6 && redstoneInputState > 0 && !controller.isPortalActive()) {
                    GlyphElement e = dialler.glyphList.get(new Random().nextInt(glyphCount));
                    controller.connectionDial(e.identifier, e.texture, null);
                } else if (this.state == 7) {
                    if (redstoneInputState > 0 && !controller.isPortalActive()) {
                        GlyphElement e = dialler.glyphList.get(new Random().nextInt(glyphCount));
                        controller.connectionDial(e.identifier, e.texture, null);
                    } else if (redstoneInputState == 0 && controller.isPortalActive()) {
                        controller.connectionTerminate();
                    }
                }
            }
        }
    }

    public void onPortalCreated() {
        if (this.isOutput) {
            if (this.state == 0) {
                this.timeUntilOff = (byte)TPS;
            } else if (this.state == 2) {
                this.timeUntilOff = (byte)-1;
            } else if (this.state == 3) {
                this.timeUntilOff = 0;
            }
            this.notifyNeighbors();
        }
    }

    public void onPortalRemoved() {
        if (this.isOutput) {
            if (this.state == 1) {
                this.timeUntilOff = (byte)TPS;
            } else if (this.state == 2) {
                this.timeUntilOff = 0;
            } else if (this.state == 3) {
                this.timeUntilOff = (byte)-1;
            }
            this.notifyNeighbors();
        }
    }

    @Override
    public void packetGuiFill(ByteBuf buffer) {
        buffer.writeBoolean(this.isOutput);
        buffer.writeByte((int)this.state);
    }

    @Override
    public void packetGuiUse(ByteBuf buffer) {
        this.isOutput = buffer.readBoolean();
        this.setState(buffer.readByte());
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.isOutput = tagCompound.func_74767_n("output");
        this.state = tagCompound.func_74771_c("state");
        this.previousRedstoneState = tagCompound.func_74771_c("previousRedstoneState");
        this.timeUntilOff = tagCompound.func_74771_c("timeUntilOff");
    }

    public void setState(byte newState) {
        this.state = newState;
        if (this.timeUntilOff != 0) {
            this.timeUntilOff = 0;
            this.notifyNeighbors();
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.isOutput) {
            if (this.timeUntilOff > 1) {
                this.timeUntilOff = (byte)(this.timeUntilOff - 1);
            } else if (this.timeUntilOff == 1) {
                this.timeUntilOff = (byte)(this.timeUntilOff - 1);
                this.notifyNeighbors();
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("output", this.isOutput);
        tagCompound.func_74774_a("state", this.state);
        tagCompound.func_74774_a("previousRedstoneState", this.previousRedstoneState);
        tagCompound.func_74774_a("timeUntilOff", this.timeUntilOff);
    }
}

