/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import enhancedportals.client.PortalParticleFX;
import enhancedportals.item.ItemNanobrush;
import enhancedportals.network.GuiHandler;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileFrame;
import enhancedportals.utility.GeneralUtils;
import enhancedportals.utility.IPortalModule;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TilePortalManipulator
extends TileFrame
implements IInventory {
    ItemStack[] inventory = new ItemStack[9];

    @Override
    public boolean activate(EntityPlayer player, ItemStack stack) {
        if (player.func_70093_af()) {
            return false;
        }
        TileController controller = this.getPortalController();
        if (stack != null && controller != null && controller.isFinalized()) {
            if (GeneralUtils.isWrench(stack) && !player.func_70093_af()) {
                GuiHandler.openGui(player, this, 20);
                return true;
            }
            if (stack.func_77973_b() == ItemNanobrush.instance) {
                GuiHandler.openGui(player, controller, 8);
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDataToPacket(NBTTagCompound tag) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            NBTTagCompound t = new NBTTagCompound();
            ItemStack s = this.func_70301_a(i);
            if (s != null) {
                s.func_77955_b(t);
            }
            items.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("Modules", (NBTBase)items);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this.func_70301_a(i);
        if (stack != null) {
            if (stack.field_77994_a <= j) {
                this.func_70299_a(i, null);
            } else {
                stack = stack.func_77979_a(j);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return stack;
    }

    public IPortalModule[] getInstalledUpgrades() {
        IPortalModule[] modules = new IPortalModule[this.func_70302_i_()];
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack s = this.func_70301_a(i);
            if (s == null) continue;
            modules[i] = (IPortalModule)s.func_77973_b();
        }
        return modules;
    }

    public String func_145825_b() {
        return "tile.ep3.portalFrame.upgrade.name";
    }

    public int func_70297_j_() {
        return 1;
    }

    public ItemStack getModifierItem() {
        return this.inventory[9];
    }

    public ItemStack getModule(String ID) {
        for (ItemStack i : this.getModules()) {
            if (!((IPortalModule)i.func_77973_b()).getID(i).equals(ID)) continue;
            return i;
        }
        return null;
    }

    public ArrayList<ItemStack> getModules() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack i : this.inventory) {
            if (i == null || !(i.func_77973_b() instanceof IPortalModule)) continue;
            list.add(i);
        }
        return list;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory[i];
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean hasModule(String ID) {
        return this.getModule(ID) != null;
    }

    public boolean installUpgrade(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof IPortalModule)) {
            return false;
        }
        IPortalModule pModule = (IPortalModule)stack.func_77973_b();
        if (!this.hasModule(pModule.getID(stack)) && pModule.canInstallUpgrade(this, this.getInstalledUpgrades(), stack)) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) != null) continue;
                ItemStack s = stack.func_77946_l();
                s.field_77994_a = 1;
                this.func_70299_a(i, s);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
        }
        return false;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IPortalModule && !this.hasModule(((IPortalModule)stack.func_77973_b()).getID(stack));
    }

    public boolean isPortalInvisible() {
        for (ItemStack i : this.getModules()) {
            if (!((IPortalModule)i.func_77973_b()).disablePortalRendering(this, i)) continue;
            return true;
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onDataPacket(NBTTagCompound tag) {
        NBTTagList items = tag.func_150295_c("Modules", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            this.func_70299_a(i, ItemStack.func_77949_a((NBTTagCompound)items.func_150305_b(i)));
        }
    }

    public boolean onEntityTeleport(Entity entity) {
        for (ItemStack i : this.getModules()) {
            if (!((IPortalModule)i.func_77973_b()).onEntityTeleportStart(entity, this, i)) continue;
            return true;
        }
        return false;
    }

    public void onEntityTeleported(Entity entity) {
        for (ItemStack i : this.getModules()) {
            ((IPortalModule)i.func_77973_b()).onEntityTeleportEnd(entity, this, i);
        }
    }

    public void func_70295_k_() {
    }

    public void particleCreated(PortalParticleFX portalFX) {
        for (ItemStack i : this.getModules()) {
            ((IPortalModule)i.func_77973_b()).onParticleCreated(this, i, portalFX);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList items = compound.func_150295_c("Modules", (int)compound.func_74732_a());
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
    }

    public boolean shouldKeepMomentumOnTeleport() {
        for (ItemStack i : this.getModules()) {
            if (!((IPortalModule)i.func_77973_b()).keepMomentumOnTeleport(this, i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Modules", (NBTBase)items);
    }
}

