/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import enhancedportals.EnhancedPortals;
import enhancedportals.block.BlockFrame;
import enhancedportals.network.ClientProxy;
import enhancedportals.network.CommonProxy;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TilePortalPart;
import enhancedportals.utility.GeneralUtils;
import enhancedportals.utility.ISidedBlockTexture;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public abstract class TileFrame
extends TilePortalPart
implements ISidedBlockTexture {
    protected boolean wearingGoggles = GeneralUtils.isWearingGoggles();

    @Override
    public void breakBlock(Block b, int oldMetadata) {
        if (b == this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        TileController controller = this.getPortalController();
        if (controller != null) {
            controller.onPartFrameBroken();
        }
    }

    @Override
    public IIcon getBlockTexture(int side, int pass) {
        if (pass == 0) {
            TileController controller = this.getPortalController();
            if (controller != null) {
                if (controller.activeTextureData.hasCustomFrameTexture() && ClientProxy.customFrameTextures.size() > controller.activeTextureData.getCustomFrameTexture() && ClientProxy.customFrameTextures.get(controller.activeTextureData.getCustomFrameTexture()) != null) {
                    return ClientProxy.customFrameTextures.get(controller.activeTextureData.getCustomFrameTexture());
                }
                if (controller.activeTextureData.getFrameItem() != null && controller.activeTextureData.getFrameItem().func_77973_b() instanceof ItemBlock) {
                    return Block.func_149634_a((Item)controller.activeTextureData.getFrameItem().func_77973_b()).func_149691_a(side, controller.activeTextureData.getFrameItem().func_77960_j());
                }
            } else if (this.portalController != null) {
                EnhancedPortals.proxy.waitForController(new ChunkCoordinates(this.portalController.field_71574_a, this.portalController.field_71572_b, this.portalController.field_71573_c), this.getChunkCoordinates());
            } else {
                return BlockFrame.connectedTextures.getBaseIcon();
            }
            return BlockFrame.connectedTextures.getIconForSide((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
        }
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (meta == BlockFrame.DIALLING_DEVICE) {
            return BlockFrame.overlayIcons[meta];
        }
        return this.shouldShowOverlay() ? BlockFrame.overlayIcons[meta] : BlockFrame.overlayIcons[0];
    }

    public int getColour() {
        TileController controller = this.getPortalController();
        if (controller != null) {
            return controller.activeTextureData.getFrameColour();
        }
        if (this.portalController != null) {
            EnhancedPortals.proxy.waitForController(new ChunkCoordinates(this.portalController.field_71574_a, this.portalController.field_71572_b, this.portalController.field_71573_c), this.getChunkCoordinates());
        }
        return 0xFFFFFF;
    }

    public void onBlockDismantled() {
        TileController controller = this.getPortalController();
        if (controller != null) {
            controller.deconstruct();
        }
    }

    protected boolean shouldShowOverlay() {
        return this.wearingGoggles || CommonProxy.CONFIG_FORCE_FRAME_OVERLAY;
    }

    public void func_145845_h() {
        boolean wGoggles;
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && Minecraft.func_71386_F() % 10L == 0L && (wGoggles = GeneralUtils.isWearingGoggles()) != this.wearingGoggles) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.wearingGoggles = wGoggles;
        }
    }
}

