/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal;

import enhancedportals.portal.PortalException;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileDialingDevice;
import enhancedportals.tile.TileNetworkInterface;
import enhancedportals.tile.TilePortalManipulator;
import enhancedportals.tile.TilePortalPart;
import enhancedportals.utility.GeneralUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PortalUtils {
    static final int MAXIMUM_CHANCES = 40;

    static void addNearbyBlocks(World world, ChunkCoordinates w, int portalDirection, Queue<ChunkCoordinates> q) {
        if (portalDirection == 4) {
            q.add(new ChunkCoordinates(w.field_71574_a, w.field_71572_b + 1, w.field_71573_c));
            q.add(new ChunkCoordinates(w.field_71574_a, w.field_71572_b - 1, w.field_71573_c));
            q.add(new ChunkCoordinates(w.field_71574_a + 1, w.field_71572_b, w.field_71573_c - 1));
            q.add(new ChunkCoordinates(w.field_71574_a - 1, w.field_71572_b, w.field_71573_c + 1));
        } else if (portalDirection == 5) {
            q.add(new ChunkCoordinates(w.field_71574_a, w.field_71572_b + 1, w.field_71573_c));
            q.add(new ChunkCoordinates(w.field_71574_a, w.field_71572_b - 1, w.field_71573_c));
            q.add(new ChunkCoordinates(w.field_71574_a - 1, w.field_71572_b, w.field_71573_c - 1));
            q.add(new ChunkCoordinates(w.field_71574_a + 1, w.field_71572_b, w.field_71573_c + 1));
        } else {
            for (int i = 0; i < 6; ++i) {
                if (portalDirection == 1 && (i == 2 || i == 3) || portalDirection == 2 && (i == 4 || i == 5) || portalDirection == 3 && (i == 0 || i == 1)) continue;
                ForgeDirection d = ForgeDirection.getOrientation((int)i);
                q.add(new ChunkCoordinates(w.field_71574_a + d.offsetX, w.field_71572_b + d.offsetY, w.field_71573_c + d.offsetZ));
            }
        }
    }

    public static ArrayList<ChunkCoordinates> getAllPortalComponents(TileController controller) throws PortalException {
        ArrayList<ChunkCoordinates> portalComponents = new ArrayList<ChunkCoordinates>();
        LinkedList<ChunkCoordinates> toProcess = new LinkedList<ChunkCoordinates>();
        Queue<ChunkCoordinates> portalBlocks = PortalUtils.getGhostedPortalBlocks(controller);
        toProcess.add(controller.getChunkCoordinates());
        if (portalBlocks.isEmpty()) {
            throw new PortalException("couldNotCreatePortalHere");
        }
        boolean program = false;
        boolean mod = false;
        boolean dialler = false;
        boolean network = false;
        while (!toProcess.isEmpty()) {
            ChunkCoordinates c = (ChunkCoordinates)toProcess.remove();
            if (portalComponents.contains(c)) continue;
            TileEntity t = controller.func_145831_w().func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (!portalBlocks.contains(c) && !(t instanceof TilePortalPart)) continue;
            if (t instanceof TileNetworkInterface) {
                if (dialler) {
                    throw new PortalException("dialAndNetwork");
                }
                network = true;
            } else if (t instanceof TileDialingDevice) {
                if (network) {
                    throw new PortalException("dialAndNetwork");
                }
                dialler = true;
            } else if (t instanceof TilePortalManipulator) {
                if (!mod) {
                    mod = true;
                } else {
                    throw new PortalException("multipleMod");
                }
            }
            portalComponents.add(c);
            PortalUtils.addNearbyBlocks(controller.func_145831_w(), c, 0, toProcess);
            if (controller.portalType < 4) continue;
            PortalUtils.addNearbyBlocks(controller.func_145831_w(), c, controller.portalType, toProcess);
        }
        if (portalComponents.isEmpty()) {
            throw new PortalException("unknown");
        }
        return portalComponents;
    }

    static Queue<ChunkCoordinates> getGhostedPortalBlocks(TileController controller) {
        for (int j = 0; j < 6; ++j) {
            for (int i = 1; i < 6; ++i) {
                ChunkCoordinates c = GeneralUtils.offset(controller.getChunkCoordinates(), ForgeDirection.getOrientation((int)j));
                Queue<ChunkCoordinates> portalBlocks = PortalUtils.getGhostedPortalBlocks(controller.func_145831_w(), c, i);
                if (portalBlocks.isEmpty()) continue;
                controller.portalType = i;
                return portalBlocks;
            }
        }
        return new LinkedList<ChunkCoordinates>();
    }

    static Queue<ChunkCoordinates> getGhostedPortalBlocks(World world, ChunkCoordinates start, int portalType) {
        LinkedList<ChunkCoordinates> portalBlocks = new LinkedList<ChunkCoordinates>();
        LinkedList<ChunkCoordinates> toProcess = new LinkedList<ChunkCoordinates>();
        int chances = 0;
        toProcess.add(start);
        while (!toProcess.isEmpty()) {
            ChunkCoordinates c = (ChunkCoordinates)toProcess.remove();
            if (portalBlocks.contains(c)) continue;
            if (world.func_147437_c(c.field_71574_a, c.field_71572_b, c.field_71573_c)) {
                int sides = PortalUtils.getGhostedSides(world, c, portalBlocks, portalType);
                if (sides < 2) {
                    if (chances < 40) {
                        ++chances;
                        sides += 2;
                    } else {
                        return new LinkedList<ChunkCoordinates>();
                    }
                }
                if (sides < 2) continue;
                portalBlocks.add(c);
                PortalUtils.addNearbyBlocks(world, c, portalType, toProcess);
                continue;
            }
            if (PortalUtils.isPortalPart(world, c)) continue;
            return new LinkedList<ChunkCoordinates>();
        }
        return portalBlocks;
    }

    static int getGhostedSides(World world, ChunkCoordinates block, Queue<ChunkCoordinates> portalBlocks, int portalType) {
        int sides = 0;
        LinkedList<ChunkCoordinates> neighbors = new LinkedList<ChunkCoordinates>();
        PortalUtils.addNearbyBlocks(world, block, portalType, neighbors);
        for (ChunkCoordinates c : neighbors) {
            if (!portalBlocks.contains(c) && !PortalUtils.isPortalPart(world, c)) continue;
            ++sides;
        }
        return sides;
    }

    static boolean isPortalPart(World world, ChunkCoordinates c) {
        TileEntity tile = world.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
        return tile != null && tile instanceof TilePortalPart;
    }

    public static boolean netherCreatePortal(World world, ChunkCoordinates w, int portalDirection) {
        LinkedList<ChunkCoordinates> processed = new LinkedList<ChunkCoordinates>();
        LinkedList<ChunkCoordinates> toProcess = new LinkedList<ChunkCoordinates>();
        int chances = 0;
        toProcess.add(w);
        while (!toProcess.isEmpty()) {
            ChunkCoordinates c = (ChunkCoordinates)toProcess.remove();
            if (processed.contains(c)) continue;
            if (world.func_147437_c(c.field_71574_a, c.field_71572_b, c.field_71573_c)) {
                int sides = PortalUtils.netherGetSides(world, c, portalDirection);
                if (sides < 2) {
                    if (chances < 40) {
                        ++chances;
                        sides += 2;
                    } else {
                        PortalUtils.netherRemoveFailedPortal(world, processed);
                        return false;
                    }
                }
                if (sides < 2) continue;
                processed.add(c);
                world.func_147465_d(c.field_71574_a, c.field_71572_b, c.field_71573_c, (Block)Blocks.field_150427_aO, 0, 2);
                PortalUtils.addNearbyBlocks(world, c, portalDirection, toProcess);
                continue;
            }
            if (PortalUtils.netherIsPortalPart(world, c.field_71574_a, c.field_71572_b, c.field_71573_c)) continue;
            PortalUtils.netherRemoveFailedPortal(world, processed);
            return false;
        }
        return true;
    }

    static int netherGetSides(World world, ChunkCoordinates w, int portalDirection) {
        int sides = 0;
        LinkedList<ChunkCoordinates> neighbors = new LinkedList<ChunkCoordinates>();
        PortalUtils.addNearbyBlocks(world, w, portalDirection, neighbors);
        for (ChunkCoordinates c : neighbors) {
            if (!PortalUtils.netherIsPortalPart(world, c.field_71574_a, c.field_71572_b, c.field_71573_c)) continue;
            ++sides;
        }
        return sides;
    }

    static boolean netherIsPortalPart(Block id) {
        return id == Blocks.field_150427_aO || id == Blocks.field_150343_Z;
    }

    static boolean netherIsPortalPart(World world, int x, int y, int z) {
        return PortalUtils.netherIsPortalPart(world.func_147439_a(x, y, z));
    }

    static void netherRemoveFailedPortal(World world, Queue<ChunkCoordinates> processed) {
        while (!processed.isEmpty()) {
            ChunkCoordinates c = processed.remove();
            world.func_147468_f(c.field_71574_a, c.field_71572_b, c.field_71573_c);
        }
    }
}

