/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal;

import cpw.mods.fml.common.network.ByteBufUtils;
import enhancedportals.tile.TileController;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PortalTextureManager {
    int frameColour;
    int customFrameTexture;
    int portalColour;
    int customPortalTexture;
    int particleColour;
    int particleType;
    ItemStack[] inventory;
    TileController controller;

    public PortalTextureManager() {
        this.portalColour = 0xFFFFFF;
        this.frameColour = 0xFFFFFF;
        this.particleColour = 30680;
        this.particleType = 0;
        this.customPortalTexture = -1;
        this.customFrameTexture = -1;
        this.inventory = new ItemStack[2];
    }

    public PortalTextureManager(PortalTextureManager p) {
        this.frameColour = p.frameColour;
        this.portalColour = p.portalColour;
        this.particleColour = p.particleColour;
        this.particleType = p.particleType;
        this.customFrameTexture = p.customFrameTexture;
        this.customPortalTexture = p.customPortalTexture;
        this.inventory = p.inventory;
        this.controller = p.controller;
    }

    public PortalTextureManager(TileController controller) {
        this();
        this.controller = controller;
    }

    public boolean isDefault() {
        return this.frameColour == 0xFFFFFF && this.portalColour == 0xFFFFFF && this.particleColour == 30680 && this.particleType == 0 && this.customFrameTexture == -1 && this.customPortalTexture == -1 && this.inventory[0] == null && this.inventory[1] == null;
    }

    public int getCustomFrameTexture() {
        return this.customFrameTexture;
    }

    public int getCustomPortalTexture() {
        return this.customPortalTexture;
    }

    public int getFrameColour() {
        return this.frameColour;
    }

    public ItemStack getFrameItem() {
        return this.inventory[0];
    }

    public int getParticleColour() {
        return this.particleColour;
    }

    public int getParticleType() {
        return this.particleType;
    }

    public int getPortalColour() {
        return this.portalColour;
    }

    public ItemStack getPortalItem() {
        return this.inventory[1];
    }

    public boolean hasCustomFrameTexture() {
        return this.customFrameTexture > -1;
    }

    public boolean hasCustomPortalTexture() {
        return this.customPortalTexture > -1;
    }

    public void readFromNBT(NBTTagCompound tag, String tagName) {
        NBTTagCompound t = tag.func_74775_l(tagName);
        this.frameColour = t.func_74762_e("frameColour");
        this.portalColour = t.func_74762_e("portalColour");
        this.particleColour = t.func_74762_e("particleColour");
        this.particleType = t.func_74762_e("particleType");
        this.customFrameTexture = t.func_74762_e("customFrameTexture");
        this.customPortalTexture = t.func_74762_e("customPortalTexture");
        NBTTagList l = t.func_150295_c("Inventory", 10);
        for (int i = 0; i < this.inventory.length; ++i) {
            NBTTagCompound T = l.func_150305_b(i);
            this.inventory[i] = ItemStack.func_77949_a((NBTTagCompound)T);
        }
    }

    public void setCustomFrameTexture(int i) {
        this.customFrameTexture = i;
        if (this.controller != null) {
            this.controller.func_70296_d();
        }
    }

    public void setCustomPortalTexture(int i) {
        this.customPortalTexture = i;
        if (this.controller != null) {
            this.controller.func_70296_d();
        }
    }

    public void setFrameColour(int i) {
        this.frameColour = i;
        if (this.controller != null) {
            this.controller.func_70296_d();
        }
    }

    public void setFrameItem(ItemStack s) {
        this.inventory[0] = s;
        if (this.controller != null) {
            this.controller.func_70296_d();
        }
    }

    public void setParticleColour(int i) {
        this.particleColour = i;
        if (this.controller != null) {
            this.controller.func_70296_d();
        }
    }

    public void setParticleType(int i) {
        this.particleType = i;
        if (this.controller != null) {
            this.controller.func_70296_d();
        }
    }

    public void setPortalColour(int i) {
        this.portalColour = i;
        if (this.controller != null) {
            this.controller.func_70296_d();
        }
    }

    public void setPortalItem(ItemStack s) {
        this.inventory[1] = s;
        if (this.controller != null) {
            this.controller.func_70296_d();
        }
    }

    public void usePacket(ByteBuf buffer) {
        this.frameColour = buffer.readInt();
        this.portalColour = buffer.readInt();
        this.particleColour = buffer.readInt();
        this.particleType = buffer.readInt();
        this.customFrameTexture = buffer.readInt();
        this.customPortalTexture = buffer.readInt();
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = ByteBufUtils.readItemStack((ByteBuf)buffer);
        }
    }

    public void writeToNBT(NBTTagCompound tag, String tagName) {
        NBTTagCompound t = new NBTTagCompound();
        t.func_74768_a("frameColour", this.frameColour);
        t.func_74768_a("portalColour", this.portalColour);
        t.func_74768_a("particleColour", this.particleColour);
        t.func_74768_a("particleType", this.particleType);
        t.func_74768_a("customFrameTexture", this.customFrameTexture);
        t.func_74768_a("customPortalTexture", this.customPortalTexture);
        NBTTagList l = new NBTTagList();
        for (ItemStack element : this.inventory) {
            NBTTagCompound T = new NBTTagCompound();
            if (element != null) {
                element.func_77955_b(T);
            }
            l.func_74742_a((NBTBase)T);
        }
        t.func_74782_a("Inventory", (NBTBase)l);
        tag.func_74782_a(tagName, (NBTBase)t);
    }

    public void writeToPacket(ByteBuf buffer) {
        buffer.writeInt(this.frameColour);
        buffer.writeInt(this.portalColour);
        buffer.writeInt(this.particleColour);
        buffer.writeInt(this.particleType);
        buffer.writeInt(this.customFrameTexture);
        buffer.writeInt(this.customPortalTexture);
        for (ItemStack element : this.inventory) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)element);
        }
    }
}

