/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import enhancedportals.EnhancedPortals;
import enhancedportals.network.CommonProxy;
import enhancedportals.portal.GlyphIdentifier;
import enhancedportals.tile.TileController;
import enhancedportals.utility.DimensionCoordinates;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.io.FileUtils;

public class NetworkManager {
    HashMap<String, DimensionCoordinates> portalCoordinates = new HashMap();
    HashMap<DimensionCoordinates, String> portalCoordinatesReverse = new HashMap();
    HashMap<String, String> portalNetworks = new HashMap();
    HashMap<String, ArrayList<String>> networkedPortals = new HashMap();
    File portalFile;
    File networkFile;
    MinecraftServer server;

    public NetworkManager(FMLServerStartingEvent event) {
        this.server = event.getServer();
        this.portalFile = new File(EnhancedPortals.proxy.getWorldDir(), "EP3_PortalLocations.json");
        this.networkFile = new File(EnhancedPortals.proxy.getWorldDir(), "EP3_PortalNetworks.json");
        try {
            this.loadAllData();
        }
        catch (Exception e) {
            CommonProxy.logger.catching((Throwable)e);
            e.printStackTrace();
        }
    }

    private void addNetwork(GlyphIdentifier network) {
        if (this.networkedPortals.get(network.getGlyphString()) == null) {
            this.networkedPortals.put(network.getGlyphString(), new ArrayList());
        }
    }

    public void addPortal(GlyphIdentifier g, DimensionCoordinates w) {
        if (this.getPortalIdentifier(w) != null || this.getPortalLocation(g) != null) {
            return;
        }
        this.portalCoordinates.put(g.getGlyphString(), w);
        this.portalCoordinatesReverse.put(w, g.getGlyphString());
    }

    public void addPortalToNetwork(GlyphIdentifier portal, GlyphIdentifier network) {
        if (portal == null || network == null || this.getPortalNetwork(portal) != null) {
            return;
        }
        this.getNetwork(network).add(portal.getGlyphString());
        this.portalNetworks.put(portal.getGlyphString(), network.getGlyphString());
    }

    public GlyphIdentifier getDestination(GlyphIdentifier identifier, GlyphIdentifier portalNetwork) {
        ArrayList<String> network = this.getNetwork(portalNetwork);
        int index = network.indexOf(identifier.getGlyphString());
        if (index == network.size() - 1) {
            return new GlyphIdentifier(network.get(0));
        }
        return new GlyphIdentifier(network.get(index + 1));
    }

    private ArrayList<String> getNetwork(GlyphIdentifier network) {
        this.addNetwork(network);
        return this.networkedPortals.get(network.getGlyphString());
    }

    public int getNetworkSize(GlyphIdentifier nID) {
        ArrayList<String> list = this.getNetwork(nID);
        return list.isEmpty() ? -1 : list.size();
    }

    public TileController getPortalController(GlyphIdentifier portal) {
        DimensionCoordinates w = this.getPortalLocation(portal);
        if (w == null) {
            return null;
        }
        TileEntity tile = w.getTileEntity();
        if (tile == null || !(tile instanceof TileController)) {
            return null;
        }
        return (TileController)tile;
    }

    public GlyphIdentifier getPortalIdentifier(DimensionCoordinates w) {
        if (w == null) {
            return null;
        }
        String ID = this.portalCoordinatesReverse.get((Object)w);
        return ID == null ? null : new GlyphIdentifier(this.portalCoordinatesReverse.get((Object)w));
    }

    public DimensionCoordinates getPortalLocation(GlyphIdentifier g) {
        return g == null ? null : this.portalCoordinates.get(g.getGlyphString());
    }

    public GlyphIdentifier getPortalNetwork(GlyphIdentifier g) {
        if (g == null) {
            return null;
        }
        String ID = this.portalNetworks.get(g.getGlyphString());
        return ID == null ? null : new GlyphIdentifier(this.portalNetworks.get(g.getGlyphString()));
    }

    public boolean hasIdentifier(DimensionCoordinates w) {
        return w == null ? null : Boolean.valueOf(this.portalCoordinates.containsValue((Object)w));
    }

    public boolean hasNetwork(GlyphIdentifier g) {
        return g == null ? null : Boolean.valueOf(this.portalNetworks.containsKey(g.getGlyphString()));
    }

    public boolean hasNetwork(DimensionCoordinates w) {
        return w == null ? null : Boolean.valueOf(this.hasNetwork(this.getPortalIdentifier(w)));
    }

    public void loadAllData() throws Exception {
        if (!this.makeFiles()) {
            return;
        }
        Type type = new TypeToken<HashMap<String, DimensionCoordinates>>(){}.getType();
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
        String portalData = FileUtils.readFileToString((File)this.portalFile);
        String networkData = FileUtils.readFileToString((File)this.networkFile);
        this.portalCoordinates = (HashMap)gson.fromJson(portalData, type);
        this.portalNetworks = (HashMap)gson.fromJson(networkData, this.portalNetworks.getClass());
        if (this.portalCoordinates == null) {
            this.portalCoordinates = new HashMap();
        }
        if (this.portalNetworks == null) {
            this.portalNetworks = new HashMap();
        }
        if (!this.portalCoordinates.isEmpty()) {
            for (Map.Entry<String, DimensionCoordinates> entry : this.portalCoordinates.entrySet()) {
                this.portalCoordinatesReverse.put(entry.getValue(), entry.getKey());
            }
        }
        if (!this.portalNetworks.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.portalNetworks.entrySet()) {
                if (this.networkedPortals.containsKey(entry.getValue())) {
                    this.networkedPortals.get(entry.getValue()).add(entry.getKey());
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(entry.getKey());
                this.networkedPortals.put((String)entry.getValue(), list);
            }
        }
    }

    private boolean makeFiles() {
        try {
            if (!this.portalFile.exists()) {
                this.portalFile.createNewFile();
            }
            if (!this.networkFile.exists()) {
                this.networkFile.createNewFile();
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean portalIdentifierExists(GlyphIdentifier id) {
        return this.portalCoordinates.containsKey(id.getGlyphString());
    }

    public void removePortal(GlyphIdentifier g) {
        this.removePortal(g, this.getPortalLocation(g));
    }

    public void removePortal(GlyphIdentifier g, DimensionCoordinates w) {
        if (g == null || w == null) {
            return;
        }
        GlyphIdentifier n = this.getPortalNetwork(g);
        if (n != null) {
            this.removePortalFromNetwork(g, n);
        }
        this.portalCoordinates.remove(g.getGlyphString());
        this.portalCoordinatesReverse.remove((Object)w);
    }

    public void removePortal(DimensionCoordinates w) {
        this.removePortal(this.getPortalIdentifier(w), w);
    }

    public void removePortalFromNetwork(GlyphIdentifier portal, GlyphIdentifier network) {
        if (portal == null || network == null) {
            return;
        }
        this.getNetwork(network).remove(portal.getGlyphString());
        this.portalNetworks.remove(portal.getGlyphString());
    }

    public void saveAllData() {
        this.makeFiles();
        try {
            Gson gson = new GsonBuilder().create();
            FileWriter portalWriter = new FileWriter(this.portalFile);
            FileWriter networkWriter = new FileWriter(this.networkFile);
            gson.toJson(this.portalCoordinates, (Appendable)portalWriter);
            gson.toJson(this.portalNetworks, (Appendable)networkWriter);
            portalWriter.close();
            networkWriter.close();
        }
        catch (Exception e) {
            CommonProxy.logger.catching((Throwable)e);
        }
    }
}

