/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui.tabs;

import enhancedportals.client.gui.BaseGui;
import enhancedportals.client.gui.tabs.BaseTab;
import enhancedportals.network.CommonProxy;
import enhancedportals.tile.TileStabilizerMain;
import enhancedportals.utility.GeneralUtils;
import enhancedportals.utility.Localization;

public class TabRedstoneFlux
extends BaseTab {
    TileStabilizerMain stabilizer;

    public TabRedstoneFlux(BaseGui gui, TileStabilizerMain s) {
        super(gui);
        this.name = "tab.redstoneFlux";
        this.stabilizer = s;
        this.maxHeight = 110;
        this.titleColour = 0xDDDD00;
        this.backgroundColor = 0xDD6600;
    }

    @Override
    public void drawFullyOpened() {
        int instability = this.stabilizer.powerState == 0 ? this.stabilizer.instability : (this.stabilizer.powerState == 1 ? 20 : (this.stabilizer.powerState == 2 ? 50 : 70));
        int powerCost = (int)((double)(this.stabilizer.intActiveConnections * CommonProxy.CONFIG_REDSTONE_FLUX_COST) * GeneralUtils.getPowerMultiplier());
        powerCost -= (int)((float)powerCost * ((float)instability / 100.0f));
        this.parent.getFontRenderer().func_78261_a(Localization.get("tab.redstoneFlux.maxPower"), this.posX + 10, this.posY + 20, 0xAAAAAA);
        this.parent.getFontRenderer().func_78276_b(this.stabilizer.getEnergyStorage().getMaxEnergyStored() + " RF", this.posX + 17, this.posY + 32, 0);
        this.parent.getFontRenderer().func_78261_a(Localization.get("tab.redstoneFlux.storedPower"), this.posX + 10, this.posY + 45, 0xAAAAAA);
        this.parent.getFontRenderer().func_78276_b(this.stabilizer.getEnergyStorage().getEnergyStored() + " RF", this.posX + 17, this.posY + 57, 0);
        this.parent.getFontRenderer().func_78261_a(Localization.get("tab.redstoneFlux.powerUsage"), this.posX + 10, this.posY + 70, 0xAAAAAA);
        this.parent.getFontRenderer().func_78276_b(powerCost + " RF/s", this.posX + 17, this.posY + 83, 0);
        this.parent.getFontRenderer().func_78276_b(powerCost / 20 + " RF/t", this.posX + 17, this.posY + 94, 0);
    }

    @Override
    public void drawFullyClosed() {
    }
}

