/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui.tabs;

import enhancedportals.client.gui.BaseGui;
import enhancedportals.client.gui.tabs.TabTracker;
import enhancedportals.utility.Localization;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class BaseTab {
    static int tabExpandSpeed = 8;
    protected BaseGui parent;
    protected boolean visible = true;
    protected boolean disabled = false;
    protected ArrayList<String> hoverText;
    protected int posX;
    protected int posY;
    protected int sizeX;
    protected int sizeY;
    protected String id;
    protected ResourceLocation texture;
    public int side = 1;
    public boolean open;
    public boolean drawName = true;
    public int backgroundColor = 0xFFFFFF;
    public int minWidth = 22;
    public int maxWidth = 124;
    public int currentWidth = this.minWidth;
    public int minHeight = 22;
    public int maxHeight = 22;
    public int currentHeight = this.minHeight;
    public static final ResourceLocation DEFAULT_TEXTURE_LEFT = new ResourceLocation("enhancedportals", "textures/gui/tab_left.png");
    public static final ResourceLocation DEFAULT_TEXTURE_RIGHT = new ResourceLocation("enhancedportals", "textures/gui/tab_right.png");
    public int titleColour = 0xFFFFFF;
    public IIcon icon;
    public ItemStack stack;
    public String name;
    public int currentShiftX = 0;
    public int currentShiftY = 0;

    public BaseTab(BaseGui gui) {
        this(gui, 1);
    }

    public BaseTab(BaseGui gui, int side) {
        this.parent = gui;
        this.side = side;
        this.texture = side == 0 ? DEFAULT_TEXTURE_LEFT : DEFAULT_TEXTURE_RIGHT;
        int guiLeft = gui.getGuiLeft();
        if (guiLeft < this.maxWidth) {
            this.maxWidth = guiLeft;
        }
    }

    void drawIcon(IIcon icon, int x, int y, int spriteSheet) {
        if (spriteSheet == 0) {
            this.parent.getTextureManager().func_110577_a(TextureMap.field_110575_b);
        } else {
            this.parent.getTextureManager().func_110577_a(TextureMap.field_110576_c);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.parent.func_94065_a(x, y, icon, 16, 16);
    }

    void drawItemStack(ItemStack stack, int x, int y) {
        if (stack != null) {
            RenderHelper.func_74520_c();
            GL11.glEnable((int)32826);
            this.parent.getItemRenderer().func_82406_b(this.parent.getFontRenderer(), this.parent.getTextureManager(), stack, x, y);
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
        }
    }

    public void draw() {
        int offsetX;
        this.drawBackground();
        if (this.icon != null) {
            offsetX = this.side == 0 ? 4 - this.currentWidth : 2;
            this.drawIcon(this.icon, this.posX + offsetX, this.posY + 3, 1);
        } else if (this.stack != null) {
            offsetX = this.side == 0 ? 4 - this.currentWidth : 2;
            this.drawItemStack(this.stack, this.posX + offsetX, this.posY + 3);
        }
        if (this.isFullyOpened() && this.drawName) {
            int offset = this.icon != null || this.stack != null ? 22 : 4;
            int offsetX2 = this.side == 0 ? offset - this.currentWidth + 2 : offset;
            this.parent.getFontRenderer().func_78261_a(Localization.get(this.name), this.posX + offsetX2, this.posY + 7, this.titleColour);
        }
        if (this.isFullyOpened()) {
            this.drawFullyOpened();
        } else if (this.isFullyClosed()) {
            this.drawFullyClosed();
        }
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += tabExpandSpeed;
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= tabExpandSpeed;
        }
        if (this.currentWidth > this.maxWidth) {
            this.currentWidth = this.maxWidth;
        } else if (this.currentWidth < this.minWidth) {
            this.currentWidth = this.minWidth;
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += tabExpandSpeed;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= tabExpandSpeed;
        }
        if (this.currentHeight > this.maxHeight) {
            this.currentHeight = this.maxHeight;
        } else if (this.currentHeight < this.minHeight) {
            this.currentHeight = this.minHeight;
        }
        if (this.open && this.currentWidth == this.maxWidth && this.currentHeight == this.maxHeight) {
            this.setFullyOpen();
        }
    }

    public abstract void drawFullyOpened();

    public abstract void drawFullyClosed();

    public void draw(int x, int y) {
        this.posX = x;
        this.posY = y;
        this.draw();
    }

    protected void drawBackground() {
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.parent.getTextureManager().func_110577_a(this.texture);
        if (this.side == 0) {
            this.drawTexturedModalRect(this.posX - this.currentWidth, this.posY + 4, 0, 256 - this.currentHeight + 4, 4, this.currentHeight - 4);
            this.drawTexturedModalRect(this.posX - this.currentWidth + 4, this.posY, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.drawTexturedModalRect(this.posX - this.currentWidth, this.posY, 0, 0, 4, 4);
            this.drawTexturedModalRect(this.posX - this.currentWidth + 4, this.posY + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        } else {
            this.drawTexturedModalRect(this.posX, this.posY, 0, 256 - this.currentHeight, 4, this.currentHeight);
            this.drawTexturedModalRect(this.posX + 4, this.posY, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.drawTexturedModalRect(this.posX, this.posY, 0, 0, 4, 4);
            this.drawTexturedModalRect(this.posX + 4, this.posY + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public String getID() {
        return this.id;
    }

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        return false;
    }

    public boolean intersectsWith(int mouseX, int mouseY) {
        return (mouseX += this.parent.getGuiLeft()) >= this.posX && mouseX < this.posX + this.sizeX && (mouseY += this.parent.getGuiTop()) >= this.posY && mouseY < this.posY + this.sizeY;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public BaseTab setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public BaseTab setId(String id) {
        this.id = id;
        return this;
    }

    public BaseTab setPosition(int posX, int posY) {
        this.posX = this.parent.getGuiLeft() + posX;
        this.posY = this.parent.getGuiTop() + posY;
        return this;
    }

    public BaseTab setSize(int sizeX, int sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        return this;
    }

    public BaseTab setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
        return this.side == 0 ? mouseX <= shiftX && mouseX >= shiftX - this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight : mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight;
    }

    public boolean isFullyOpened() {
        return this.currentWidth >= this.maxWidth;
    }

    public boolean isFullyClosed() {
        return this.currentWidth <= this.minWidth;
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            if (this.side == 0) {
                TabTracker.setOpenedLeftTab(null);
            } else {
                TabTracker.setOpenedRightTab(null);
            }
        } else {
            this.open = true;
            if (this.side == 0) {
                TabTracker.setOpenedLeftTab(this.getClass());
            } else {
                TabTracker.setOpenedRightTab(this.getClass());
            }
        }
    }

    public void update() {
    }

    void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par6), 0.0, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), 0.0, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0), 0.0, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), 0.0, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78381_a();
    }

    public void addTooltip(List<String> list) {
        if (this.isFullyClosed()) {
            list.add(Localization.get(this.name));
        }
    }
}

