/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui.elements;

import enhancedportals.client.gui.GuiDialingDevice;
import enhancedportals.client.gui.elements.BaseElement;
import enhancedportals.portal.GlyphElement;
import enhancedportals.tile.TileDialingDevice;
import enhancedportals.utility.Localization;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ElementScrollDiallingDevice
extends BaseElement {
    TileDialingDevice dial;
    float currentScroll = 0.0f;
    boolean isScrolling = false;
    boolean wasClicking = false;
    int scrollAmount = 0;
    int offsetX = 5;
    int offsetY = 5;
    int sizeMButton = 196;
    int sizeSButton = 20;
    int buttonSpacing = 2;
    int entryHeight = 22;

    public ElementScrollDiallingDevice(GuiDialingDevice gui, TileDialingDevice d, int x, int y) {
        super(gui, x, y, gui.getSizeX() - 14, gui.getSizeY() - 57);
        this.dial = d;
        this.texture = gui.getTexture();
    }

    @Override
    public void addTooltip(List<String> list) {
        int x = this.parent.getMouseX() + this.parent.getGuiLeft();
        int y = this.parent.getMouseY() + this.parent.getGuiTop();
        for (int i = 0; i < 5 && this.scrollAmount + i < this.dial.glyphList.size(); ++i) {
            boolean mouseOverSmall;
            int entryOffset = i * this.entryHeight;
            boolean mouseOverEntry = y >= this.posY + this.offsetY + entryOffset && y <= this.posY + this.offsetY + entryOffset + 20;
            boolean bl = mouseOverSmall = mouseOverEntry && x >= this.posX + this.offsetX + this.sizeMButton + this.buttonSpacing && x < this.posX + this.offsetX + this.sizeMButton + this.buttonSpacing + this.sizeSButton;
            if (!mouseOverSmall) continue;
            if (GuiScreen.func_146272_n()) {
                list.add(Localization.get("gui.delete"));
                break;
            }
            list.add(Localization.get("gui.edit"));
            break;
        }
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        x += this.parent.getGuiLeft();
        y += this.parent.getGuiTop();
        for (int i = 0; i < 5 && this.scrollAmount + i < this.dial.glyphList.size(); ++i) {
            boolean mouseOverSmall;
            GlyphElement e = this.dial.glyphList.get(this.scrollAmount + i);
            int entryOffset = i * this.entryHeight;
            boolean mouseOverEntry = y >= this.posY + this.offsetY + entryOffset && y <= this.posY + this.offsetY + entryOffset + 20;
            boolean mouseOverMain = mouseOverEntry && x >= this.posX + this.offsetX && x < this.posX + this.offsetX + this.sizeMButton;
            boolean bl = mouseOverSmall = mouseOverEntry && x >= this.posX + this.offsetX + this.sizeMButton + this.buttonSpacing && x < this.posX + this.offsetX + this.sizeMButton + this.buttonSpacing + this.sizeSButton;
            if (mouseOverMain) {
                ((GuiDialingDevice)this.parent).onEntrySelected(this.scrollAmount + i);
                break;
            }
            if (!mouseOverSmall) continue;
            if (GuiScreen.func_146272_n()) {
                ((GuiDialingDevice)this.parent).onEntryDeleted(this.scrollAmount + i);
                break;
            }
            ((GuiDialingDevice)this.parent).onEntryEdited(this.scrollAmount + i);
            break;
        }
        return true;
    }

    protected void handleMouse() {
        boolean isMouseDown = Mouse.isButtonDown((int)0);
        boolean ignoreScroll = false;
        int mouseX = this.parent.getMouseX() + this.parent.getGuiLeft();
        int mouseY = this.parent.getMouseY() + this.parent.getGuiTop();
        int scrollbarX = this.posX + this.sizeX - 13;
        int scrollbarY = this.posY + 1;
        int scrollbarX2 = scrollbarX + 11;
        int scrollbarY2 = scrollbarY + this.sizeY - 3;
        if (!this.wasClicking && isMouseDown && mouseX >= scrollbarX && mouseX <= scrollbarX2 && mouseY >= scrollbarY && mouseY <= scrollbarY2) {
            this.isScrolling = true;
        }
        if (!isMouseDown) {
            this.isScrolling = false;
        }
        this.wasClicking = isMouseDown;
        if (!this.isScrolling && !isMouseDown && this.intersectsWith(mouseX - this.parent.getGuiLeft(), mouseY - this.parent.getGuiTop())) {
            int wheel = Mouse.getDWheel();
            if (wheel < 0) {
                this.currentScroll = (float)((double)this.currentScroll + 0.1);
                ignoreScroll = true;
                this.isScrolling = true;
            } else if (wheel > 0) {
                this.currentScroll = (float)((double)this.currentScroll - 0.1);
                ignoreScroll = true;
                this.isScrolling = true;
            }
        }
        if (this.isScrolling) {
            int max;
            if (!ignoreScroll) {
                this.currentScroll = ((float)(mouseY - scrollbarY) - 7.5f) / ((float)(scrollbarY2 - scrollbarY) - 15.0f);
            }
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            } else if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
            int items = this.dial.glyphList.size() - 5 + 1;
            this.scrollAmount = (int)((double)(this.currentScroll * (float)items) + 0.5);
            if (this.scrollAmount < 0) {
                this.scrollAmount = 0;
            }
            if (this.scrollAmount > (max = this.dial.glyphList.size() - 5)) {
                this.scrollAmount = max;
            }
        }
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void drawContent() {
        boolean canScroll = false;
        if (this.dial.glyphList.size() >= 6) {
            canScroll = true;
            this.handleMouse();
        }
        int l = this.posY + 1;
        int k = l + this.sizeY - 1;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.parent.getMinecraft().func_110434_K().func_110577_a(this.texture);
        this.drawTexturedModalRect(this.posX + this.sizeX - 13, this.posY + 1 + (int)((float)(k - l - 16) * this.currentScroll), 244, 226 + (canScroll ? 0 : 15), 12, 15);
        for (int i = 0; i < 5 && this.scrollAmount + i < this.dial.glyphList.size(); ++i) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GlyphElement e = this.dial.glyphList.get(this.scrollAmount + i);
            int state = 1;
            int entryOffset = i * this.entryHeight;
            int mouseX = this.parent.getMouseX() + this.parent.getGuiLeft();
            int mouseY = this.parent.getMouseY() + this.parent.getGuiTop();
            int fontColour = 0xFFFFFF;
            boolean mouseOverEntry = mouseY >= this.posY + this.offsetY + entryOffset && mouseY <= this.posY + this.offsetY + entryOffset + 20;
            boolean mouseOverMain = mouseOverEntry && mouseX >= this.posX + this.offsetX && mouseX < this.posX + this.offsetX + this.sizeMButton;
            boolean mouseOverSmall = mouseOverEntry && mouseX >= this.posX + this.offsetX + this.sizeMButton + this.buttonSpacing && mouseX < this.posX + this.offsetX + this.sizeMButton + this.buttonSpacing + this.sizeSButton;
            boolean delete = GuiScreen.func_146272_n();
            if (this.dial.getPortalController().isPortalActive()) {
                state = 0;
            }
            if (state == 1 && mouseOverMain) {
                state = 2;
            }
            this.parent.getTextureManager().func_110577_a(this.texture);
            this.parent.func_73729_b(this.posX + this.offsetX, this.posY + entryOffset + this.offsetY, 0, 196 + state * 20, this.sizeMButton, 20);
            this.parent.func_73729_b(this.posX + this.offsetX + this.sizeMButton + this.buttonSpacing, this.posY + entryOffset + this.offsetY, 196 + (delete ? 20 : 0), 216 + (mouseOverSmall ? 20 : 0), this.sizeSButton, 20);
            this.parent.getFontRenderer().func_78261_a(e.name, this.posX + this.offsetX + 5, this.posY + this.offsetY + 6 + entryOffset, fontColour);
        }
    }

    @Override
    public void update() {
    }
}

