/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui.elements;

import enhancedportals.client.gui.BaseGui;
import enhancedportals.client.gui.elements.BaseElement;
import enhancedportals.portal.GlyphIdentifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ElementGlyphSelector
extends BaseElement {
    public static final ResourceLocation glyphs = new ResourceLocation("enhancedportals", "textures/gui/glyphs.png");
    ArrayList<Integer> selectedGlyphs = new ArrayList();
    int[] glyphCount = new int[27];

    public ElementGlyphSelector(BaseGui gui, int x, int y) {
        super(gui, x, y, 162, 54);
        this.texture = new ResourceLocation("enhancedportals", "textures/gui/player_inventory.png");
    }

    @Override
    protected void drawBackground() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.parent.getMinecraft().field_71446_o.func_110577_a(this.texture);
        this.parent.func_73729_b(this.posX, this.posY, 7, 7, this.sizeX, this.sizeY);
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (this.disabled) {
            return false;
        }
        for (int i = 0; i < 27; ++i) {
            int X = this.posX - this.parent.getGuiLeft() + i % 9 * 18;
            int Y = this.posY - this.parent.getGuiTop() + i / 9 * 18;
            if (x < X || x >= X + 18 || y < Y || y >= Y + 18) continue;
            if (mouseButton == 0) {
                if (this.selectedGlyphs.size() == 9) {
                    return true;
                }
                this.addGlyph(i);
            } else {
                if (this.glyphCount[i] == 0) {
                    return true;
                }
                for (int j = this.selectedGlyphs.size() - 1; j >= 0; --j) {
                    if (this.selectedGlyphs.get(j) != i) continue;
                    this.removeGlyphAt(j);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void removeGlyphAt(int i) {
        int n = this.selectedGlyphs.get(i);
        this.glyphCount[n] = this.glyphCount[n] - 1;
        this.selectedGlyphs.remove(i);
    }

    public void reset() {
        this.selectedGlyphs.clear();
        this.glyphCount = new int[27];
    }

    public void setIdentifierTo(GlyphIdentifier identifier) {
        this.reset();
        if (identifier != null && !identifier.isEmpty()) {
            this.selectedGlyphs = new ArrayList<Integer>(identifier.getGlyphs());
            Iterator<Integer> i$ = this.selectedGlyphs.iterator();
            while (i$.hasNext()) {
                int i;
                int n = i = i$.next().intValue();
                this.glyphCount[n] = this.glyphCount[n] + 1;
            }
        }
    }

    @Override
    public void update() {
    }

    public void addGlyph(int i) {
        if (this.selectedGlyphs.size() < 9) {
            this.selectedGlyphs.add(i);
            int n = i;
            this.glyphCount[n] = this.glyphCount[n] + 1;
        }
    }

    public GlyphIdentifier getGlyphIdentifier() {
        return new GlyphIdentifier(this.selectedGlyphs);
    }

    @Override
    protected void drawContent() {
        int i;
        this.parent.getMinecraft().field_71446_o.func_110577_a(glyphs);
        for (i = 0; i < 27; ++i) {
            int X = i % 9 * 18;
            int Y = i / 9 * 18;
            if (this.parent.getMouseX() + this.parent.getGuiLeft() >= this.posX + X && this.parent.getMouseX() + this.parent.getGuiLeft() < this.posX + X + 18 && this.parent.getMouseY() + this.parent.getGuiTop() >= this.posY + Y && this.parent.getMouseY() + this.parent.getGuiTop() < this.posY + Y + 18) {
                Gui.func_73734_a((int)(this.posX + X + 1), (int)(this.posY + Y + 1), (int)(this.posX + X + 17), (int)(this.posY + Y + 17), (int)0x66FFFFFF);
            }
            if (this.glyphCount[i] > 0) {
                Gui.func_73734_a((int)(this.posX + X + 1), (int)(this.posY + Y + 1), (int)(this.posX + X + 17), (int)(this.posY + Y + 17), (int)0x3300FF00);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.drawTexturedModalRect(this.posX + X, this.posY + Y, X, Y, 18, 18);
        }
        for (i = 0; i < this.glyphCount.length; ++i) {
            String s = "" + (this.glyphCount[i] > 0 ? Integer.valueOf(this.glyphCount[i]) : "");
            this.parent.getFontRenderer().func_78261_a(s, this.posX + i % 9 * 18 + 17 - this.parent.getFontRenderer().func_78256_a(s), this.posY + i / 9 * 18 + 9, 0xFFFFFF);
        }
    }

    @Override
    public void addTooltip(List<String> list) {
    }
}

