/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui;

import enhancedportals.EnhancedPortals;
import enhancedportals.block.BlockFrame;
import enhancedportals.block.BlockPortal;
import enhancedportals.client.gui.BaseGui;
import enhancedportals.client.gui.button.GuiBetterSlider;
import enhancedportals.client.gui.button.GuiRGBSlider;
import enhancedportals.client.gui.elements.ElementScrollParticles;
import enhancedportals.client.gui.tabs.TabColour;
import enhancedportals.client.gui.tabs.TabTip;
import enhancedportals.inventory.ContainerTextureParticle;
import enhancedportals.network.ClientProxy;
import enhancedportals.network.packet.PacketGuiData;
import enhancedportals.network.packet.PacketRequestGui;
import enhancedportals.portal.PortalTextureManager;
import enhancedportals.tile.TileController;
import enhancedportals.utility.Localization;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiTextureParticle
extends BaseGui {
    public static final int CONTAINER_SIZE = 92;
    public static final int CONTAINER_WIDTH = 190;
    protected TileController controller;
    protected GuiRGBSlider sliderR;
    protected GuiRGBSlider sliderG;
    protected GuiRGBSlider sliderB;
    protected GuiButton buttonReset;
    protected GuiButton buttonSave;

    public GuiTextureParticle(TileController c, EntityPlayer p) {
        super(new ContainerTextureParticle(c, p.field_71071_by), 92);
        this.controller = c;
        this.field_146999_f = 190;
        this.name = "gui.particle";
        this.texture = new ResourceLocation("enhancedportals", "textures/gui/textures_particles.png");
        this.leftNudge = 7;
        this.hasSingleTexture = true;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.buttonSave.field_146127_k || button.field_146127_k == this.buttonReset.field_146127_k) {
            if (button.field_146127_k == this.buttonSave.field_146127_k) {
                int hex = Integer.parseInt(String.format("%02x%02x%02x", this.sliderR.getValue(), this.sliderG.getValue(), this.sliderB.getValue()), 16);
                this.getPTM().setParticleColour(hex);
            } else if (button.field_146127_k == this.buttonReset.field_146127_k) {
                int colour = 30680;
                this.getPTM().setParticleColour(colour);
                Color c = new Color(colour);
                this.sliderR.sliderValue = (float)c.getRed() / 255.0f;
                this.sliderG.sliderValue = (float)c.getGreen() / 255.0f;
                this.sliderB.sliderValue = (float)c.getBlue() / 255.0f;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("colour", Integer.parseInt(String.format("%02x%02x%02x", this.sliderR.getValue(), this.sliderG.getValue(), this.sliderB.getValue()), 16));
            EnhancedPortals.packetPipeline.sendToServer(new PacketGuiData(tag));
        } else if (button.field_146127_k == 500) {
            EnhancedPortals.packetPipeline.sendToServer(new PacketRequestGui(this.controller, 8));
        } else if (button.field_146127_k == 501) {
            EnhancedPortals.packetPipeline.sendToServer(new PacketRequestGui(this.controller, 9));
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Color c = new Color(this.getPTM().getParticleColour());
        this.sliderR = new GuiRGBSlider(100, this.field_147003_i + this.field_146999_f + 4, this.field_147009_r + 25, Localization.get("gui.red"), (float)c.getRed() / 255.0f, 105);
        this.sliderG = new GuiRGBSlider(101, this.field_147003_i + this.field_146999_f + 4, this.field_147009_r + 46, Localization.get("gui.green"), (float)c.getGreen() / 255.0f, 105);
        this.sliderB = new GuiRGBSlider(102, this.field_147003_i + this.field_146999_f + 4, this.field_147009_r + 67, Localization.get("gui.blue"), (float)c.getBlue() / 255.0f, 105);
        this.field_146292_n.add(this.sliderR);
        this.field_146292_n.add(this.sliderG);
        this.field_146292_n.add(this.sliderB);
        this.buttonSave = new GuiButton(110, this.field_147003_i + this.field_146999_f + 4, this.field_147009_r + 88, 53, 20, Localization.get("gui.save"));
        this.buttonReset = new GuiButton(111, this.field_147003_i + this.field_146999_f + 57, this.field_147009_r + 88, 53, 20, Localization.get("gui.reset"));
        this.field_146292_n.add(this.buttonSave);
        this.field_146292_n.add(this.buttonReset);
        this.field_146292_n.add(new GuiButton(500, this.field_147003_i + 7, this.field_147009_r + this.containerSize - 18, 20, 20, ""));
        this.field_146292_n.add(new GuiButton(501, this.field_147003_i + 28, this.field_147009_r + this.containerSize - 18, 20, 20, ""));
        this.addTab(new TabColour(this, this.sliderR, this.sliderG, this.sliderB, this.buttonSave, this.buttonReset));
        this.addTab(new TabTip((BaseGui)this, "colourTip"));
        this.addElement(new ElementScrollParticles(this, 7, 17, this.texture));
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        super.func_146286_b(par1, par2, par3);
        if (par3 == 0) {
            for (Object o : this.field_146292_n) {
                if (!(o instanceof GuiBetterSlider)) continue;
                GuiBetterSlider slider = (GuiBetterSlider)((Object)o);
                slider.func_146118_a(par1, par2);
            }
        }
    }

    public void particleSelected(int particle) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", particle);
        EnhancedPortals.packetPipeline.sendToServer(new PacketGuiData(tag));
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        this.itemRenderer.field_77024_a = false;
        ItemStack frame = new ItemStack((Block)BlockFrame.instance, 0, 0);
        ItemStack portal = new ItemStack((Block)BlockPortal.instance, 0, 0);
        Color frameColour = new Color(this.getPTM().getFrameColour());
        Color portalColour = new Color(this.getPTM().getPortalColour());
        boolean particleType = false;
        if (this.getPTM() != null) {
            frameColour = new Color(this.getPTM().getFrameColour());
            portalColour = new Color(this.getPTM().getPortalColour());
            if (this.getPTM().getFrameItem() != null) {
                frame = this.getPTM().getFrameItem();
            }
            if (this.getPTM().getPortalItem() != null) {
                portal = this.getPTM().getPortalItem();
            }
        }
        GL11.glColor3f((float)((float)frameColour.getRed() / 255.0f), (float)((float)frameColour.getGreen() / 255.0f), (float)((float)frameColour.getBlue() / 255.0f));
        if (this.getPTM().hasCustomFrameTexture()) {
            this.drawIconNoReset(ClientProxy.customFrameTextures.get(this.getPTM().getCustomFrameTexture()), 9, this.containerSize - 16, 0);
        } else {
            this.drawItemStack(frame, 9, this.containerSize - 16);
        }
        GL11.glColor3f((float)((float)portalColour.getRed() / 255.0f), (float)((float)portalColour.getGreen() / 255.0f), (float)((float)portalColour.getBlue() / 255.0f));
        if (this.getPTM().hasCustomPortalTexture()) {
            this.drawIconNoReset(ClientProxy.customPortalTextures.get(this.getPTM().getCustomPortalTexture()), 30, this.containerSize - 16, 0);
        } else {
            this.drawItemStack(portal, 30, this.containerSize - 16);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146979_b(par1, par2);
    }

    public PortalTextureManager getPTM() {
        return this.controller.activeTextureData;
    }
}

