/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import cofh.api.world.IFeatureGenerator;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeRegistry;
import shukaro.artifice.event.ArtificeTickHandler;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.ChunkCoord;
import shukaro.artifice.util.MiscUtils;
import shukaro.artifice.util.NameMetaPair;
import shukaro.artifice.world.IDelayedGen;
import shukaro.artifice.world.VolcanoHelper;

public class WorldGenVolcano
implements IFeatureGenerator {
    private int frequency = ArtificeConfig.volcanoFrequency;
    protected Set<NameMetaPair> replaced = new HashSet<NameMetaPair>();

    public WorldGenVolcano() {
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            if (biome.field_76752_A != null) {
                this.replaced.add(new NameMetaPair(biome.field_76752_A));
            }
            if (biome.field_76753_B == null) continue;
            this.replaced.add(new NameMetaPair(biome.field_76753_B));
        }
    }

    public String getFeatureName() {
        return "Artifice: Volcanos";
    }

    public boolean generateFeature(Random rand, int chunkX, int chunkZ, World world, boolean newGen) {
        int dim = world.field_73011_w.field_76574_g;
        if (ArtificeRegistry.getDimensionBlacklist().contains(dim)) {
            return false;
        }
        String worldType = world.field_73011_w.field_76577_b.func_77127_a();
        if (ArtificeRegistry.getWorldTypeBlacklist().contains(worldType)) {
            return false;
        }
        if (rand.nextInt(20) != 0) {
            return false;
        }
        int total = this.frequency >= 100 ? (rand.nextInt(100) < Math.abs(this.frequency % (int)Math.pow(10.0, (int)Math.log10(this.frequency))) ? this.frequency / 100 + 1 : this.frequency / 100) : (rand.nextInt(100) < this.frequency ? 0 : 1);
        for (int j = 0; j < total; ++j) {
            boolean doGen = false;
            BlockCoord b = new BlockCoord();
            int tries = rand.nextInt(8);
            for (int i = 0; i < tries; ++i) {
                int x = (chunkX << 4) + rand.nextInt(16);
                int z = (chunkZ << 4) + rand.nextInt(16);
                int y = VolcanoHelper.getHighestSolidOrFillBlock(world, x, z);
                b.set(x, y, z);
                if (!VolcanoHelper.canGenHere(world, b)) continue;
                doGen = true;
                break;
            }
            if (!doGen || rand.nextInt(10) != 0) {
                return false;
            }
            VolcanoGen volcano = new VolcanoGen(world, b, rand.nextBoolean());
            ArtificeTickHandler.queueGeneration(world.field_73011_w.field_76574_g, volcano);
        }
        return true;
    }

    private class VolcanoGen
    implements IDelayedGen {
        private World world;
        private Random rand;
        private boolean active;
        private BlockCoord start;
        private static final int CHAMBER_SIZE = 32768;
        private static final int CHAMBER_DEPTH = 32;
        private static final int CHAMBER_THICKNESS = 2;
        private static final int LAYERS = 6;
        private static final int CINDER_PASSES = 3;
        private static final int CINDERS = 64;
        private static final int FLOW_PASSES = 2;
        private static final int FLOW_SIZE = 8;
        private static final int LAVA_BITS = 64;

        public VolcanoGen(World world, BlockCoord start, boolean active) {
            this.world = world;
            this.rand = world.field_73012_v;
            this.active = active;
            this.start = start;
        }

        @Override
        public ChunkCoord getChunk() {
            return new ChunkCoord(this.start);
        }

        @Override
        public boolean doGeneration() {
            BlockCoord blobCenter = this.start.copy().offset(ForgeDirection.DOWN, MiscUtils.randWithin50(this.rand, 32));
            int blobSize = MiscUtils.randWithin50(this.rand, 32768);
            this.genBlob(blobCenter, blobSize);
            this.encaseBlob(blobCenter, 2);
            this.genTube(blobCenter);
            int numLayers = 6;
            int flowSize = MiscUtils.randWithin50(this.rand, 8);
            for (int i = 0; i < numLayers; ++i) {
                int cp = 3;
                int fp = 2;
                while (cp > 0 || fp > 0) {
                    boolean task = this.rand.nextBoolean();
                    if (task && cp > 0) {
                        --cp;
                        continue;
                    }
                    if (task || fp <= 0) continue;
                    this.genFlow(this.start, flowSize);
                    flowSize = (int)((double)flowSize * (1.0 + (0.65 * this.rand.nextDouble() + 0.1)));
                    --fp;
                }
            }
            if (this.active) {
                this.genLavaBits(this.start, MiscUtils.randWithin50(this.rand, 64));
            }
            return true;
        }

        private void genBlob(BlockCoord center, int size) {
            BlockCoord b = null;
            ArrayList<BlockCoord> workplace = new ArrayList<BlockCoord>();
            THashSet done = new THashSet();
            workplace.add(center);
            for (int filled = 0; filled < size && !workplace.isEmpty(); ++filled) {
                b = (BlockCoord)workplace.remove(this.rand.nextInt(workplace.size()));
                VolcanoHelper.setVolcanoFill(this.world, b, this.active);
                done.add((Object)b);
                for (BlockCoord t : b.getAdjacent()) {
                    if (done.contains((Object)t)) continue;
                    workplace.add(t);
                }
            }
        }

        private void encaseBlob(BlockCoord origin, int thickness) {
            ArrayList<BlockCoord> workplace = new ArrayList<BlockCoord>();
            THashSet done = new THashSet();
            workplace.add(origin);
            while (!workplace.isEmpty()) {
                BlockCoord b = (BlockCoord)workplace.remove(this.rand.nextInt(workplace.size()));
                done.add((Object)b);
                for (BlockCoord t : b.getRadiusBlocks(1 + this.rand.nextInt(thickness - 1))) {
                    Block k = t.getBlock((IBlockAccess)this.world);
                    if (b.getDistance(t) <= (float)thickness && !VolcanoHelper.isVolcanicFill(k) && !VolcanoHelper.isVolcanicBlock(k)) {
                        VolcanoHelper.setVolcanoBlock(this.world, t);
                        continue;
                    }
                    if (!VolcanoHelper.isVolcanicFill(k) || done.contains((Object)t) || workplace.contains(t)) continue;
                    workplace.add(t);
                }
            }
        }

        private List<BlockCoord> genTube(BlockCoord start) {
            BlockCoord b = start.copy();
            int height = VolcanoHelper.getHighestSolidOrFillBlock(this.world, b.x, b.z) + 1;
            int tubeSize = this.rand.nextInt(5) + 1;
            ArrayList<BlockCoord> tubeBlocks = new ArrayList<BlockCoord>();
            tubeBlocks.add(b);
            while (tubeBlocks.size() < tubeSize) {
                int side = this.rand.nextInt(4) + 2;
                if (tubeBlocks.contains(b.getAdjacent()[side])) continue;
                tubeBlocks.add(b.getAdjacent()[side]);
            }
            while (b.y < height) {
                for (BlockCoord t : tubeBlocks) {
                    if (!VolcanoHelper.isVolcanicFill(t.getBlock((IBlockAccess)this.world))) {
                        VolcanoHelper.setVolcanoFill(this.world, t, this.active);
                    }
                    for (BlockCoord n : t.getNearby()) {
                        if (n.y > t.y || VolcanoHelper.isVolcanicFill(n.getBlock((IBlockAccess)this.world))) continue;
                        VolcanoHelper.setVolcanoBlock(this.world, n);
                    }
                    ++t.y;
                }
            }
            return tubeBlocks;
        }

        private void genFlow(BlockCoord start, int flowSize) {
            int flowed = 0;
            List<BlockCoord> open = VolcanoHelper.getOpenSides(this.world, start);
            while (open.size() == 0) {
                start.offset(ForgeDirection.UP);
                open = VolcanoHelper.getOpenSides(this.world, start);
                VolcanoHelper.setVolcanoFill(this.world, start, this.active);
                for (BlockCoord n : start.getAdjacent()) {
                    if (n.y != start.y || !VolcanoHelper.isVolcanicFill(n.copy().offset(ForgeDirection.DOWN).getBlock((IBlockAccess)this.world))) continue;
                    VolcanoHelper.setVolcanoFill(this.world, n, this.active);
                }
            }
            while (flowed < flowSize && open.size() > 0) {
                BlockCoord b = open.get(0);
                BlockCoord c = b.copy();
                VolcanoHelper.setVolcanoBlock(this.world, b);
                while (VolcanoHelper.isReplaceable(this.world, c.offset(ForgeDirection.DOWN))) {
                    VolcanoHelper.setVolcanoBlock(this.world, c);
                }
                open = VolcanoHelper.getOpenSides(this.world, c);
                ++flowed;
            }
        }

        private void genTephra(BlockCoord start, int amount) {
            int dropped = 0;
            int radius = amount / 3;
            ArrayList<BlockCoord> done = new ArrayList<BlockCoord>();
            while (dropped < amount) {
                BlockCoord b = VolcanoHelper.snapToHighest(this.world, VolcanoHelper.get2dINVERSEDistributedCoord(this.world, start, MiscUtils.randWithin50(this.rand, amount)));
                if (done.contains(b) || VolcanoHelper.isVolcanicFill(b.getBlock((IBlockAccess)this.world))) continue;
                VolcanoHelper.setVolcanoTephra(this.world, b.offset(ForgeDirection.UP));
                done.add(b);
                ++dropped;
            }
        }

        private void genLavaBits(BlockCoord start, int amount) {
            BlockCoord b = start.copy();
            while (VolcanoHelper.isVolcanicFill(b.getBlock((IBlockAccess)this.world)) || VolcanoHelper.isVolcanicBlock(b.getBlock((IBlockAccess)this.world))) {
                if (b.y > 255) {
                    return;
                }
                if (!VolcanoHelper.isVolcanicFill(b.copy().offset(ForgeDirection.UP).getBlock((IBlockAccess)this.world)) && !VolcanoHelper.isVolcanicBlock(b.copy().offset(ForgeDirection.UP).getBlock((IBlockAccess)this.world))) break;
                b.offset(ForgeDirection.UP);
            }
            ArrayList<BlockCoord> toCover = new ArrayList<BlockCoord>();
            ArrayList<BlockCoord> done = new ArrayList<BlockCoord>();
            int num = 0;
            toCover.add(b);
            while (num < amount && !toCover.isEmpty()) {
                b = (BlockCoord)toCover.remove(this.rand.nextInt(toCover.size()));
                if (this.world.func_147437_c(b.x, b.y + 1, b.z) && this.rand.nextInt(16) == 0) {
                    this.world.func_147465_d(b.x, b.y, b.z, Blocks.field_150353_l, 0, 3);
                    ++num;
                }
                done.add(b);
                for (BlockCoord t : b.getNearby()) {
                    if (toCover.contains(t) || done.contains(t) || !VolcanoHelper.isVolcanicBlock(t.getBlock((IBlockAccess)this.world)) || t.copy().offset(ForgeDirection.UP).getBlock((IBlockAccess)this.world).func_149662_c()) continue;
                    toCover.add(t);
                }
            }
        }

        private void genCaldera(BlockCoord start, int amount) {
        }

        private void coverFeature(BlockCoord start) {
            BlockCoord b = start.copy();
            while (VolcanoHelper.isVolcanicFill(b.getBlock((IBlockAccess)this.world)) || VolcanoHelper.isVolcanicBlock(b.getBlock((IBlockAccess)this.world))) {
                if (b.y > 255) {
                    return;
                }
                if (!VolcanoHelper.isVolcanicFill(b.copy().offset(ForgeDirection.UP).getBlock((IBlockAccess)this.world)) && !VolcanoHelper.isVolcanicBlock(b.copy().offset(ForgeDirection.UP).getBlock((IBlockAccess)this.world))) break;
                b.offset(ForgeDirection.UP);
            }
            ArrayDeque<BlockCoord> toCover = new ArrayDeque<BlockCoord>();
            toCover.add(b);
            while (!toCover.isEmpty()) {
                b = (BlockCoord)toCover.pop();
                BiomeGenBase biome = this.world.func_72807_a(b.x, b.y);
                if (biome.field_76752_A != null && !b.copy().offset(ForgeDirection.UP).getBlock((IBlockAccess)this.world).func_149662_c() && b.copy().offset(ForgeDirection.UP).isAir((IBlockAccess)this.world)) {
                    b.setBlock(this.world, biome.field_76752_A, 0, false);
                } else if (biome.field_76753_B != null && !b.copy().offset(ForgeDirection.UP).getBlock((IBlockAccess)this.world).func_149662_c()) {
                    b.setBlock(this.world, biome.field_76753_B, 0, false);
                }
                if (this.world.func_147437_c(b.x, b.y + 1, b.z)) {
                    if (this.rand.nextInt(16) == 0) {
                        biome.func_76730_b(this.rand).func_76484_a(this.world, this.rand, b.x, b.y, b.z);
                    } else if (this.rand.nextInt(16) == 0) {
                        biome.plantFlower(this.world, this.rand, b.x, b.y + 1, b.z);
                    }
                }
                for (BlockCoord t : b.getNearby()) {
                    if (toCover.contains(t) || !VolcanoHelper.isVolcanicBlock(t.getBlock((IBlockAccess)this.world)) || t.copy().offset(ForgeDirection.UP).getBlock((IBlockAccess)this.world).func_149662_c()) continue;
                    toCover.add(t);
                }
            }
        }
    }
}

