/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import cofh.api.world.IFeatureGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeRegistry;
import shukaro.artifice.util.ChunkCoord;

public class WorldGenLily
implements IFeatureGenerator {
    private int frequency = ArtificeConfig.lotusFrequency;

    public String getFeatureName() {
        return "Artifice: Lilies";
    }

    public boolean generateFeature(Random rand, int chunkX, int chunkZ, World world, boolean newGen) {
        int dim = world.field_73011_w.field_76574_g;
        if (ArtificeRegistry.getDimensionBlacklist().contains(dim)) {
            return false;
        }
        String worldType = world.field_73011_w.field_76577_b.func_77127_a();
        if (ArtificeRegistry.getWorldTypeBlacklist().contains(worldType)) {
            return false;
        }
        int total = this.frequency >= 100 ? (rand.nextInt(100) < Math.abs(this.frequency % (int)Math.pow(10.0, (int)Math.log10(this.frequency))) ? this.frequency / 100 + 1 : this.frequency / 100) : (rand.nextInt(100) < this.frequency ? 0 : 1);
        for (int j = 0; j < total; ++j) {
            int startZ;
            int xMin = chunkX << 4;
            int zMin = chunkZ << 4;
            int startX = xMin + rand.nextInt(16);
            BiomeGenBase biome = world.func_72807_a(startX, startZ = zMin + rand.nextInt(16));
            if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                return false;
            }
            int tries = rand.nextInt(16) + 8;
            ChunkCoord c = new ChunkCoord(chunkX, chunkZ);
            for (int l = 0; l < tries; ++l) {
                int x = startX + rand.nextInt(8) - rand.nextInt(8);
                int z = startZ + rand.nextInt(8) - rand.nextInt(8);
                int y = world.func_72976_f(x, z);
                if (!c.contains(x, z) || !world.func_147437_c(x, y, z) || !ArtificeBlocks.blockLotus.func_149742_c(world, x, y, z)) continue;
                if (world.func_72820_D() > 12000L) {
                    world.func_147465_d(x, y, z, (Block)ArtificeBlocks.blockLotus, 1, 0);
                    continue;
                }
                world.func_147465_d(x, y, z, (Block)ArtificeBlocks.blockLotus, 0, 0);
            }
        }
        return true;
    }
}

