/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import cofh.api.world.IFeatureGenerator;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeRegistry;
import shukaro.artifice.event.ArtificeTickHandler;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.ChunkCoord;
import shukaro.artifice.util.NameMetaPair;
import shukaro.artifice.world.ISuspendableGen;

public class WorldGenDesert
implements IFeatureGenerator {
    protected Block block;
    protected int meta;
    private int size;
    private int frequency;
    protected Set<NameMetaPair> replaced;

    public WorldGenDesert(Block block, int meta, int size, int frequency) {
        this.block = block;
        this.meta = meta;
        this.size = size;
        this.frequency = frequency;
        this.replaced = new THashSet();
        this.replaced.add(new NameMetaPair((Block)Blocks.field_150354_m, 0));
    }

    public String getFeatureName() {
        return "Artifice: " + this.block.func_149739_a() + "@" + this.meta + " Desert Deposits";
    }

    public boolean generateFeature(Random rand, int chunkX, int chunkZ, World world, boolean newGen) {
        int dim = world.field_73011_w.field_76574_g;
        if (ArtificeRegistry.getDimensionBlacklist().contains(dim)) {
            return false;
        }
        String worldType = world.field_73011_w.field_76577_b.func_77127_a();
        if (ArtificeRegistry.getWorldTypeBlacklist().contains(worldType)) {
            return false;
        }
        int total = this.frequency >= 100 ? (rand.nextInt(100) < Math.abs(this.frequency % (int)Math.pow(10.0, (int)Math.log10(this.frequency))) ? this.frequency / 100 + 1 : this.frequency / 100) : (rand.nextInt(100) < this.frequency ? 0 : 1);
        total += rand.nextInt(4);
        for (int j = 0; j < total; ++j) {
            boolean doGen = false;
            BlockCoord b = new BlockCoord();
            int tries = rand.nextInt(16) + 10;
            for (int i = 0; i < tries; ++i) {
                int x = (chunkX << 4) + rand.nextInt(16);
                int y = rand.nextInt(128) + 1;
                int z = (chunkZ << 4) + rand.nextInt(16);
                b.set(x, y, z);
                if (!this.canGenHere(world, b)) continue;
                doGen = true;
                break;
            }
            if (!doGen) {
                return false;
            }
            int num = rand.nextInt((int)((double)this.size * 1.5) - (int)((double)this.size * 0.5) + 1) + (int)((double)this.size * 0.5);
            NiterGen niter = new NiterGen(world, rand, b, num);
            niter.doGeneration(chunkX, chunkZ);
            ArtificeTickHandler.queueGeneration(dim, niter);
        }
        return true;
    }

    protected boolean canGenHere(World world, BlockCoord b) {
        NameMetaPair pair = new NameMetaPair(b.getBlock((IBlockAccess)world), b.getMeta((IBlockAccess)world));
        return !b.isAir((IBlockAccess)world) && this.replaced.contains(pair);
    }

    private class NiterGen
    implements ISuspendableGen {
        private World world;
        private Random rand;
        private BlockCoord coord;
        private TMap<ChunkCoord, ArrayList<BlockCoord>> toGen;
        private int size;

        public NiterGen(World world, Random rand, BlockCoord start, int size) {
            this.world = world;
            this.rand = rand;
            this.coord = start;
            this.toGen = new THashMap();
            this.size = size;
        }

        @Override
        public Set<ChunkCoord> getChunksToGen() {
            return this.toGen.keySet();
        }

        @Override
        public boolean doGeneration(int chunkX, int chunkZ) {
            ChunkCoord chunk = new ChunkCoord(chunkX, chunkZ);
            int genned = 0;
            int threshold = this.size / 8;
            while (genned < this.size) {
                for (BlockCoord t : this.coord.getAdjacent()) {
                    ChunkCoord c = new ChunkCoord(t);
                    if (!this.toGen.containsKey((Object)c)) {
                        this.toGen.put((Object)c, new ArrayList());
                    }
                    if (!chunk.contains(t) && !this.world.func_72899_e(t.x, t.y, t.z)) {
                        return true;
                    }
                    if (!WorldGenDesert.this.canGenHere(this.world, t) || ((ArrayList)this.toGen.get((Object)chunk)).contains(t)) continue;
                    if (this.toGen.get((Object)chunk) == null) {
                        this.toGen.put((Object)chunk, new ArrayList());
                    }
                    ((ArrayList)this.toGen.get((Object)chunk)).add(t);
                }
                if (((ArrayList)this.toGen.get((Object)chunk)).size() == 0) break;
                this.coord.set((BlockCoord)((ArrayList)this.toGen.get((Object)chunk)).get(this.rand.nextInt(((ArrayList)this.toGen.get((Object)chunk)).size())));
                ((ArrayList)this.toGen.get((Object)chunk)).remove(this.coord);
                this.world.func_147465_d(this.coord.x, this.coord.y, this.coord.z, WorldGenDesert.this.block, WorldGenDesert.this.meta, 0);
                ++genned;
                while (((ArrayList)this.toGen.get((Object)chunk)).size() > threshold && genned < this.size && ((ArrayList)this.toGen.get((Object)chunk)).size() != 0) {
                    this.coord.set((BlockCoord)((ArrayList)this.toGen.get((Object)chunk)).get(this.rand.nextInt(((ArrayList)this.toGen.get((Object)chunk)).size())));
                    ((ArrayList)this.toGen.get((Object)chunk)).remove(this.coord);
                    this.world.func_147465_d(this.coord.x, this.coord.y, this.coord.z, WorldGenDesert.this.block, WorldGenDesert.this.meta, 0);
                    ++genned;
                }
            }
            return true;
        }
    }
}

