/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import cofh.api.world.IFeatureGenerator;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeRegistry;
import shukaro.artifice.block.world.BlockOre;
import shukaro.artifice.event.ArtificeTickHandler;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.ChunkCoord;
import shukaro.artifice.util.NameMetaPair;
import shukaro.artifice.world.ISuspendableGen;

public class WorldGenCave
implements IFeatureGenerator {
    protected Block block;
    protected int meta;
    private int minHeight;
    private int maxHeight;
    private int size;
    private int frequency;
    protected Set<NameMetaPair> replaced;

    public WorldGenCave(Block block, int meta, int minHeight, int maxHeight, int size, int frequency) {
        this.block = block;
        this.meta = meta;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.size = size;
        this.frequency = frequency;
        this.replaced = ArtificeRegistry.getStoneTypes();
    }

    public String getFeatureName() {
        return "Artifice: " + this.block.func_149739_a() + "@" + this.meta + " Caves";
    }

    protected boolean canGenHere(World world, BlockCoord c) {
        NameMetaPair pair = new NameMetaPair(c.getBlock((IBlockAccess)world), c.getMeta((IBlockAccess)world));
        if (!c.isAir((IBlockAccess)world) && (this.replaced.contains(pair) || ArtificeBlocks.oreSet.contains(pair))) {
            for (BlockCoord n : c.getNearby()) {
                if (!world.func_72899_e(n.x, n.y, n.z) || !n.isAir((IBlockAccess)world) && n.getBlock((IBlockAccess)world).func_149662_c()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean generateFeature(Random rand, int chunkX, int chunkZ, World world, boolean newGen) {
        int dim = world.field_73011_w.field_76574_g;
        if (ArtificeRegistry.getDimensionBlacklist().contains(dim)) {
            return false;
        }
        String worldType = world.field_73011_w.field_76577_b.func_77127_a();
        if (ArtificeRegistry.getWorldTypeBlacklist().contains(worldType)) {
            return false;
        }
        int total = this.frequency >= 100 ? (rand.nextInt(100) < Math.abs(this.frequency % (int)Math.pow(10.0, (int)Math.log10(this.frequency))) ? this.frequency / 100 + 1 : this.frequency / 100) : (rand.nextInt(100) < this.frequency ? 0 : 1);
        for (int j = 0; j < total; ++j) {
            boolean doGen = false;
            BlockCoord b = new BlockCoord();
            int tries = rand.nextInt(16) + 8;
            for (int i = 0; i < tries; ++i) {
                int x = (chunkX << 4) + rand.nextInt(16);
                int y = rand.nextInt(this.maxHeight - this.minHeight + 1) + this.minHeight;
                int z = (chunkZ << 4) + rand.nextInt(16);
                b.set(x, y, z);
                if (!this.canGenHere(world, b)) continue;
                doGen = true;
                break;
            }
            if (!doGen) {
                return false;
            }
            if (this.block.func_149739_a().contains("limestone")) {
                BiomeGenBase biome = world.func_72807_a(b.x, b.z);
                this.block = BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) ? (b.y > world.func_72976_f(b.x, b.z) / 2 ? ArtificeBlocks.blockLimestones[3] : ArtificeBlocks.blockLimestones[2]) : (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) ? ArtificeBlocks.blockLimestones[5] : (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) ? ArtificeBlocks.blockLimestones[6] : (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) ? ArtificeBlocks.blockLimestones[4] : (b.y > world.func_72976_f(b.x, b.z) / 2 ? ArtificeBlocks.blockLimestones[1] : ArtificeBlocks.blockLimestones[0]))));
            }
            int num = rand.nextInt((int)((double)this.size * 1.5) - (int)((double)this.size * 0.5) + 1) + (int)((double)this.size * 0.5);
            CaveGen cave = new CaveGen(world, rand, b, num);
            cave.doGeneration(chunkX, chunkZ);
            ArtificeTickHandler.queueGeneration(dim, cave);
        }
        return true;
    }

    private class CaveGen
    implements ISuspendableGen {
        private World world;
        private Random rand;
        private BlockCoord coord;
        private TMap<ChunkCoord, ArrayList<BlockCoord>> toGen;
        private int size;
        private int genned;

        public CaveGen(World world, Random rand, BlockCoord start, int size) {
            this.world = world;
            this.rand = rand;
            this.coord = start;
            this.toGen = new THashMap();
            this.size = size;
            this.genned = 0;
        }

        @Override
        public Set<ChunkCoord> getChunksToGen() {
            return this.toGen.keySet();
        }

        @Override
        public boolean doGeneration(int chunkX, int chunkZ) {
            ChunkCoord chunk = new ChunkCoord(chunkX, chunkZ);
            int threshold = this.size / 8;
            while (this.genned < this.size) {
                NameMetaPair newOre;
                for (BlockCoord t : this.coord.getAdjacent()) {
                    ChunkCoord c = new ChunkCoord(t);
                    if (!this.toGen.containsKey((Object)c)) {
                        this.toGen.put((Object)c, new ArrayList());
                    }
                    if (!chunk.contains(t) && !this.world.func_72899_e(t.x, t.y, t.z)) {
                        return true;
                    }
                    if (!WorldGenCave.this.canGenHere(this.world, t) || ((ArrayList)this.toGen.get((Object)chunk)).contains(t)) continue;
                    if (this.toGen.get((Object)chunk) == null) {
                        this.toGen.put((Object)chunk, new ArrayList());
                    }
                    ((ArrayList)this.toGen.get((Object)chunk)).add(t);
                }
                if (((ArrayList)this.toGen.get((Object)chunk)).size() == 0) break;
                this.coord.set((BlockCoord)((ArrayList)this.toGen.get((Object)chunk)).get(this.rand.nextInt(((ArrayList)this.toGen.get((Object)chunk)).size())));
                ((ArrayList)this.toGen.get((Object)chunk)).remove(this.coord);
                NameMetaPair ore = new NameMetaPair(this.coord.getBlock((IBlockAccess)this.world), this.coord.getMeta((IBlockAccess)this.world));
                if (WorldGenCave.this.replaced.contains(ore)) {
                    this.world.func_147465_d(this.coord.x, this.coord.y, this.coord.z, WorldGenCave.this.block, WorldGenCave.this.meta, 0);
                } else if (ArtificeBlocks.oreSet.contains(ore) && (newOre = BlockOre.getOre(ore, WorldGenCave.this.block)) != null) {
                    this.world.func_147465_d(this.coord.x, this.coord.y, this.coord.z, newOre.getBlock(), newOre.getMetadata(), 0);
                }
                ++this.genned;
                while (((ArrayList)this.toGen.get((Object)chunk)).size() > threshold && this.genned < this.size && ((ArrayList)this.toGen.get((Object)chunk)).size() != 0) {
                    this.coord.set((BlockCoord)((ArrayList)this.toGen.get((Object)chunk)).get(this.rand.nextInt(((ArrayList)this.toGen.get((Object)chunk)).size())));
                    ((ArrayList)this.toGen.get((Object)chunk)).remove(this.coord);
                    ore = new NameMetaPair(this.coord.getBlock((IBlockAccess)this.world), this.coord.getMeta((IBlockAccess)this.world));
                    if (WorldGenCave.this.replaced.contains(ore)) {
                        this.world.func_147465_d(this.coord.x, this.coord.y, this.coord.z, WorldGenCave.this.block, WorldGenCave.this.meta, 0);
                    } else if (ArtificeBlocks.oreSet.contains(ore) && (newOre = BlockOre.getOre(ore, WorldGenCave.this.block)) != null) {
                        this.world.func_147465_d(this.coord.x, this.coord.y, this.coord.z, newOre.getBlock(), newOre.getMetadata(), 0);
                    }
                    ++this.genned;
                }
            }
            return true;
        }
    }
}

