/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.util;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ComparableItemStack {
    public Item item;
    public int metadata = -1;
    public int stackSize = -1;
    public int oreID = -1;

    public ComparableItemStack(ItemStack stack) {
        if (stack != null) {
            this.item = stack.func_77973_b();
            this.metadata = stack.func_77960_j();
            this.stackSize = stack.field_77994_a;
            this.oreID = OreDictionary.getOreID((ItemStack)stack);
        }
    }

    public ComparableItemStack(Item item, int damage, int stackSize) {
        this.item = item;
        this.metadata = damage;
        this.stackSize = stackSize;
        this.oreID = OreDictionary.getOreID((ItemStack)this.toItemStack());
    }

    public ComparableItemStack(ComparableItemStack stack) {
        this.item = stack.getItem();
        this.metadata = stack.metadata;
        this.stackSize = stack.stackSize;
        this.oreID = stack.oreID;
    }

    public ComparableItemStack(String oreName) {
        if (!OreDictionary.getOres((String)oreName).isEmpty()) {
            ItemStack ore = (ItemStack)OreDictionary.getOres((String)oreName).get(0);
            this.item = ore.func_77973_b();
            this.metadata = ore.func_77960_j();
            this.stackSize = 1;
            this.oreID = OreDictionary.getOreID((String)oreName);
        }
    }

    public boolean isItemEqual(ComparableItemStack other) {
        return other != null && (this.oreID != -1 && this.oreID == other.oreID || this.item.equals(other.getItem()) && this.metadata == other.metadata);
    }

    public boolean isStackEqual(ComparableItemStack other) {
        return this.isItemEqual(other) && this.stackSize == other.stackSize;
    }

    public boolean isStackValid() {
        return this.item != null;
    }

    @Deprecated
    public Item getItem() {
        return this.item;
    }

    public ItemStack toItemStack() {
        return this.isStackValid() ? new ItemStack(this.item, this.stackSize, this.metadata) : null;
    }

    public ComparableItemStack clone() {
        return new ComparableItemStack(this);
    }

    public int hashCode() {
        return this.oreID != -1 ? this.oreID : this.metadata | Item.func_150891_b((Item)this.item) << 16;
    }

    public boolean equals(Object o) {
        return o instanceof ComparableItemStack && this.isItemEqual((ComparableItemStack)o);
    }
}

