/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.util.MiscUtils;

public class TileEntityNuclearBattery
extends TileEntity
implements IEnergyProvider {
    private EnergyStorage charge = new EnergyStorage(ArtificeConfig.nuclearBatteryCapacity);
    private int tickGen = 0;

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        this.tickGen = 0;
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int power = this.charge.getEnergyStored();
        if (power == 0 && meta != 3) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, 3);
        } else if (power > 0 && (double)power <= (double)ArtificeConfig.nuclearBatteryCapacity * 0.4 && meta != 2) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 3);
        } else if ((double)power > (double)ArtificeConfig.nuclearBatteryCapacity * 0.4 && (double)power <= (double)ArtificeConfig.nuclearBatteryCapacity * 0.7 && meta != 1) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
        } else if ((double)power > (double)ArtificeConfig.nuclearBatteryCapacity * 0.7 && meta != 0) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        }
        this.charge.receiveEnergy(MiscUtils.provideEnergyToNeighbors(this.charge.extractEnergy(ArtificeConfig.nuclearBatteryRate, false), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e), false);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.charge.readFromNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.charge.writeToNBT(tag);
    }

    public void setEnergy(int amount) {
        this.charge.setEnergyStored(amount);
    }

    public int getMaxRate() {
        float ratio = (float)this.charge.getEnergyStored() / (float)this.charge.getMaxEnergyStored();
        return (int)Math.ceil((float)ArtificeConfig.nuclearBatteryRate * ratio);
    }

    public int extractEnergy(ForgeDirection dir, int amount, boolean simulate) {
        int maxRate = this.getMaxRate();
        if (this.tickGen >= maxRate) {
            return 0;
        }
        if (amount > maxRate) {
            amount = maxRate;
        }
        int x = this.charge.extractEnergy(amount, simulate);
        if (!simulate) {
            this.tickGen += x;
        }
        return x;
    }

    public int getEnergyStored(ForgeDirection dir) {
        return this.charge.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection dir) {
        return this.charge.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(ForgeDirection dir) {
        return true;
    }
}

